//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindModule.cpp
 * @brief		Module NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindModule_CPP_

//======================================================================
// include
#include "WXFindModule.h"
#include "iris_xchar.hpp"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindModule<CHARTYPE_>::CTFindModule(void)
{
	SecureZeroMemory(&m_Entry, sizeof(m_Entry));
	m_Entry.dwSize = sizeof(m_Entry);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTFindModule<CHARTYPE_>::~CTFindModule(void)
{
}

/**********************************************************************//**
 *
 * vZXID猟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @return	W[nh
*//***********************************************************************/
template<typename CHARTYPE_>
HMODULE CTFindModule<CHARTYPE_>::FindModule(DWORD dwProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPMODULE) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPMODULE) ) return 0;
	}
	if( toolhelp.Module32First(&m_Entry) )
	{
		while(1)
		{
			if( m_Entry.th32ProcessID == dwProcessId )
			{
				return m_Entry.hModule;
			}
			if( !toolhelp.Module32Next(&m_Entry) ) break;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * vZXID玟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @return	W[nh
*//***********************************************************************/
template<typename CHARTYPE_>
HMODULE CTFindModule<CHARTYPE_>::FindModuleNext(DWORD dwProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Module32Next(&m_Entry) ) break;
		if( m_Entry.th32ProcessID == dwProcessId )
		{
			return m_Entry.hModule;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * st@CpX猟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @return	W[nh
*//***********************************************************************/
template<typename CHARTYPE_>
HMODULE CTFindModule<CHARTYPE_>::FindModule(_Mylpcstr lpszExePath)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPTHREAD) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPTHREAD) ) return 0;
	}
	if( toolhelp.Module32First(&m_Entry) )
	{
		while(1)
		{
			if( xcsicmp(m_Entry.szExePath, lpszExePath) == 0 )
			{
				return m_Entry.hModule;
			}
			if( !toolhelp.Module32Next(&m_Entry) ) break;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * st@CpX玟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @return	W[nh
*//***********************************************************************/
template<typename CHARTYPE_>
HMODULE CTFindModule<CHARTYPE_>::FindModuleNext(_Mylpcstr lpszExePath)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Module32Next(&m_Entry) ) break;
		if( xcsicmp(m_Entry.szExePath, lpszExePath) == 0 )
		{
			return m_Entry.hModule;
		}
	}
	return 0;
}

template class CTFindModule<CHAR>;
template class CTFindModule<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris_using.h"

TEST(CFindModuleTest, Function)
{
	CFindModule find;
	ASSERT_NE( (HMODULE)0, find.FindModule(::GetCurrentProcessId()) );
}

#endif
