//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindProcess.h
 * @brief		Process NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindProcess_H_
#define INCG_IRIS_WXFindProcess_H_

//======================================================================
// include
#include "WXToolHelp.h"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// decalre
template<typename CHARTYPE_>class CTFindProcess;

//======================================================================
// typedef
typedef CTFindProcess<CHAR>		CFindProcessA;
typedef CTFindProcess<WCHAR>	CFindProcessW;
typedef CTFindProcess<TCHAR>	CFindProcess;

//======================================================================
// class
/// vZXNX
template<typename CHARTYPE_>
class CTFindProcess : public IIrisObject
{
	typedef CTFindProcess<CHARTYPE_>	_Myt;
protected:
	typedef	CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;

#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), PROCESSENTRY32W, PROCESSENTRY32 >::type XPROCESSENTRY32;
#else
	typedef PROCESSENTRY32			XPROCESSENTRY32;
#endif
	typedef XPROCESSENTRY32			*LPXPROCESSENTRY32;
	typedef const XPROCESSENTRY32	*LPCXPROCESSENTRY32;
protected:
	XPROCESSENTRY32	m_Entry;	//!< vZXGg
public:
	// RXgN^
	CTFindProcess(void);
	// fXgN^
	~CTFindProcess(void);

public:
	// vZX猟
	DWORD	FindProcessId(_Mylpcstr lpszProcessName);
	// vZX玟
	DWORD	FindProcessIdNext(_Mylpcstr lpszProcessName);

	// vZXIDevZXID
	DWORD	FindParentProcessId(DWORD dwID);

public:
	/// Gg̎擾
	LPCXPROCESSENTRY32	GetEntry(void) const { return &m_Entry; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
