//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolHelp.cpp
 * @brief		toolhelp֐bp[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXToolHelp_CPP_

//======================================================================
// include
#include "WXToolHelp.h"
#include "fnd/utility/FndRefCounter.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment (lib, "toolhelp.lib")
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
namespace
{

// CToolHelp::NXCX^X
class CImplInstance : public fnd::CRefCounter
{
	typedef HANDLE	(WINAPI* fnCreateToolhelp32Snapshot)(DWORD, DWORD);
#if	!defined(IRIS_WIN32_WCE)
	typedef BOOL	(WINAPI* fnHeap32First)		(LPHEAPENTRY32, DWORD, ULONG_PTR);
	typedef BOOL	(WINAPI* fnHeap32Next)		(LPHEAPENTRY32);
#else
	typedef BOOL	(WINAPI* fnHeap32First)		(HANDLE, LPHEAPENTRY32, DWORD, ULONG_PTR);
	typedef BOOL	(WINAPI* fnHeap32Next)		(HANDLE, LPHEAPENTRY32);
#endif
	typedef BOOL	(WINAPI* fnHeap32ListFirst)	(HANDLE, LPHEAPLIST32);
	typedef BOOL	(WINAPI* fnHeap32ListNext)	(HANDLE, LPHEAPLIST32);
	typedef BOOL	(WINAPI* fnProcess32First)	(HANDLE, LPPROCESSENTRY32A);
	typedef BOOL	(WINAPI* fnProcess32Next)	(HANDLE, LPPROCESSENTRY32A);
#if	!defined(IRIS_WIN32_WCE)
	typedef BOOL	(WINAPI* fnProcess32FirstW)	(HANDLE, LPPROCESSENTRY32W);
	typedef BOOL	(WINAPI* fnProcess32NextW)	(HANDLE, LPPROCESSENTRY32W);
#endif
	typedef BOOL	(WINAPI* fnThread32First)	(HANDLE, LPTHREADENTRY32);
	typedef BOOL	(WINAPI* fnThread32Next)	(HANDLE, LPTHREADENTRY32);
	typedef BOOL	(WINAPI* fnModule32First)	(HANDLE, LPMODULEENTRY32A);
	typedef BOOL	(WINAPI* fnModule32Next)	(HANDLE, LPMODULEENTRY32A);
#if	!defined(IRIS_WIN32_WCE)
	typedef BOOL	(WINAPI* fnModule32FirstW)	(HANDLE, LPMODULEENTRY32W);
	typedef BOOL	(WINAPI* fnModule32NextW)	(HANDLE, LPMODULEENTRY32W);
#endif

	HMODULE	m_hKernel;
	HANDLE	m_hProcess;
	DWORD	m_dwFlags;
	fnCreateToolhelp32Snapshot	m_pfnCreate;
	fnHeap32First				m_pfnHeapFirst;
	fnHeap32Next				m_pfnHeapNext;
	fnHeap32ListFirst			m_pfnHeapListFirst;
	fnHeap32ListNext			m_pfnHeapListNext;
	fnProcess32First			m_pfnProcessFirst;
	fnProcess32Next				m_pfnProcessNext;
#if	!defined(IRIS_WIN32_WCE)
	fnProcess32FirstW			m_pfnProcessFirstW;
	fnProcess32NextW			m_pfnProcessNextW;
#endif
	fnThread32First				m_pfnThreadFirst;
	fnThread32Next				m_pfnThreadNext;
	fnModule32First				m_pfnModuleFirst;
	fnModule32Next				m_pfnModuleNext;
#if	!defined(IRIS_WIN32_WCE)
	fnModule32FirstW			m_pfnModuleFirstW;
	fnModule32NextW				m_pfnModuleNextW;
#endif

public:
	CImplInstance(void)
	: m_hKernel(nullptr)
	, m_hProcess(nullptr)
	, m_pfnCreate(nullptr)
	, m_pfnHeapFirst(nullptr)
	, m_pfnHeapNext(nullptr)
	, m_pfnHeapListFirst(nullptr)
	, m_pfnHeapListNext(nullptr)
	, m_pfnProcessFirst(nullptr)
	, m_pfnProcessNext(nullptr)
#if	!defined(IRIS_WIN32_WCE)
	, m_pfnProcessFirstW(nullptr)
	, m_pfnProcessNextW(nullptr)
#endif
	, m_pfnThreadFirst(nullptr)
	, m_pfnThreadNext(nullptr)
	, m_pfnModuleFirst(nullptr)
	, m_pfnModuleNext(nullptr)
#if	!defined(IRIS_WIN32_WCE)
	, m_pfnModuleFirstW(nullptr)
	, m_pfnModuleNextW(nullptr)
#endif
	, m_dwFlags(0)
	{
	}

	~CImplInstance(void)
	{
		Close();
	}

	HANDLE	CreateToolhelp32Snapshot(DWORD dwFlags, DWORD dw32ID)
	{
		if( m_pfnCreate == nullptr ) return ::CreateToolhelp32Snapshot(dwFlags, dw32ID);
		return (*m_pfnCreate)(dwFlags, dw32ID);
	}

#if	!defined(IRIS_WIN32_WCE)
	BOOL	Heap32First(LPHEAPENTRY32 lphe32, DWORD th32ProcessID, ULONG_PTR th32HeapID)
	{
		if( m_pfnHeapFirst == nullptr ) return ::Heap32First(lphe32, th32ProcessID, th32HeapID);
		return (*m_pfnHeapFirst)(lphe32, th32ProcessID, th32HeapID);
	}
	BOOL	Heap32Next(LPHEAPENTRY32 lphe32)
	{
		if( m_pfnHeapFirst == nullptr ) return ::Heap32Next(lphe32);
		return (*m_pfnHeapNext)(lphe32);
	}
#else
	BOOL	Heap32First(HANDLE hSnapshot, LPHEAPENTRY32 lphe32, DWORD th32ProcessID, ULONG_PTR th32HeapID)
	{
		if( m_pfnHeapFirst == nullptr ) return ::Heap32First(hSnapshot, lphe32, th32ProcessID, th32HeapID);
		return (*m_pfnHeapFirst)(hSnapshot, lphe32, th32ProcessID, th32HeapID);
	}
	BOOL	Heap32Next(HANDLE hSnapshot, LPHEAPENTRY32 lphe32)
	{
		if( m_pfnHeapFirst == nullptr ) return ::Heap32Next(hSnapshot, lphe32);
		return (*m_pfnHeapNext)(hSnapshot, lphe32);
	}
#endif

	BOOL	Heap32ListFirst(HANDLE hSnapshot, LPHEAPLIST32 lphl32)
	{
		if( m_pfnHeapListFirst == nullptr ) return ::Heap32ListFirst(hSnapshot, lphl32);
		return (*m_pfnHeapListFirst)(hSnapshot, lphl32);
	}
	BOOL	Heap32ListNext(HANDLE hSnapshot, LPHEAPLIST32 lphl32)
	{
		if( m_pfnHeapListNext == nullptr ) return ::Heap32ListNext(hSnapshot, lphl32);
		return (*m_pfnHeapListNext)(hSnapshot, lphl32);
	}

	BOOL	Process32First(HANDLE hSnapshot, LPPROCESSENTRY32A lppe32)
	{
#if	defined(UNICODE) && defined(Process32First)
		#undef Process32First
		if( m_pfnProcessFirst == nullptr ) return ::Process32First(hSnapshot, lppe32);
		#define Process32First	Process32FirstW
#else
		if( m_pfnProcessFirst == nullptr ) return ::Process32First(hSnapshot, lppe32);
#endif
		return (*m_pfnProcessFirst)(hSnapshot, lppe32);
	}
	BOOL	Process32Next(HANDLE hSnapshot, LPPROCESSENTRY32A lppe32)
	{
#if	defined(UNICODE) && defined(Process32Next)
		#undef Process32Next
		if( m_pfnProcessNext == nullptr ) return ::Process32Next(hSnapshot, lppe32);
		#define Process32Next	Process32NextW
#else
		if( m_pfnProcessNext == nullptr ) return ::Process32Next(hSnapshot, lppe32);
#endif
		return (*m_pfnProcessNext)(hSnapshot, lppe32);
	}

#if !defined(IRIS_WIN32_WCE)
	BOOL	Process32FirstW(HANDLE hSnapshot, LPPROCESSENTRY32W lppe32)
	{
		if( m_pfnProcessFirstW == nullptr ) return ::Process32FirstW(hSnapshot, lppe32);
		return (*m_pfnProcessFirstW)(hSnapshot, lppe32);
	}
	BOOL	Process32NextW(HANDLE hSnapshot, LPPROCESSENTRY32W lppe32)
	{
		if( m_pfnProcessNextW == nullptr ) return ::Process32NextW(hSnapshot, lppe32);
		return (*m_pfnProcessNextW)(hSnapshot, lppe32);
	}
#endif

	BOOL	Thread32First(HANDLE hSnapshot, LPTHREADENTRY32 lpte32)
	{
		if( m_pfnThreadFirst == nullptr ) return ::Thread32First(hSnapshot, lpte32);
		return (*m_pfnThreadFirst)(hSnapshot, lpte32);
	}
	BOOL	Thread32Next(HANDLE hSnapshot, LPTHREADENTRY32 lpte32)
	{
		if( m_pfnThreadNext == nullptr ) return ::Thread32Next(hSnapshot, lpte32);
		return (*m_pfnThreadNext)(hSnapshot, lpte32);
	}

	BOOL	Module32First(HANDLE hSnapshot, LPMODULEENTRY32A lpme32)
	{
#if	defined(UNICODE) && defined(Module32First)
		#undef Module32First
		if( m_pfnModuleFirst == nullptr ) return ::Module32First(hSnapshot, lpme32);
		#define Module32First	Module32FirstW
#else
		if( m_pfnModuleFirst == nullptr ) return ::Module32First(hSnapshot, lpme32);
#endif
		return (*m_pfnModuleFirst)(hSnapshot, lpme32);
	}
	BOOL	Module32Next(HANDLE hSnapshot, LPMODULEENTRY32A lpme32)
	{
#if	defined(UNICODE) && defined(Module32Next)
		#undef Module32Next
		if( m_pfnModuleNext == nullptr ) return ::Module32Next(hSnapshot, lpme32);
		#define Module32Next	Module32NextW
#else
		if( m_pfnModuleNext == nullptr ) return ::Module32Next(hSnapshot, lpme32);
#endif
		return (*m_pfnModuleNext)(hSnapshot, lpme32);
	}

#if !defined(IRIS_WIN32_WCE)
	BOOL	Module32FirstW(HANDLE hSnapshot, LPMODULEENTRY32W lpme32)
	{
		if( m_pfnModuleFirstW == nullptr ) return ::Module32FirstW(hSnapshot, lpme32);
		return (*m_pfnModuleFirstW)(hSnapshot, lpme32);
	}
	BOOL	Module32NextW(HANDLE hSnapshot, LPMODULEENTRY32W lpme32)
	{
		if( m_pfnModuleNextW == nullptr ) return ::Module32NextW(hSnapshot, lpme32);
		return (*m_pfnModuleNextW)(hSnapshot, lpme32);
	}
#endif

public:
	// J
	BOOL	Open(DWORD dwFlags)
	{
		if( m_pfnCreate == nullptr )
		{
			m_hKernel = GetModuleHandle(TEXT("KERNEL32.DLL"));

IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
			m_pfnCreate	= (fnCreateToolhelp32Snapshot)GetProcAddressRaw(m_hKernel,
									"CreateToolhelp32Snapshot");
			m_pfnHeapFirst		= (fnHeap32First)GetProcAddressRaw(m_hKernel,
				"Heap32First");
			m_pfnHeapNext		= (fnHeap32Next)GetProcAddressRaw(m_hKernel,
				"Heap32Next");
			m_pfnHeapListFirst	= (fnHeap32ListFirst)GetProcAddressRaw(m_hKernel,
				"Heap32ListFirst");
			m_pfnHeapListNext	= (fnHeap32ListNext)GetProcAddressRaw(m_hKernel,
				"Heap32ListNext");
			m_pfnThreadFirst	= (fnThread32First)GetProcAddressRaw(m_hKernel,
				"Thread32First");
			m_pfnThreadNext		= (fnThread32Next)GetProcAddressRaw(m_hKernel,
				"Thread32Next");
			m_pfnProcessFirst	= (fnProcess32First)GetProcAddressRaw(m_hKernel,
				"Process32First");
			m_pfnProcessNext	= (fnProcess32Next)GetProcAddressRaw(m_hKernel,
				"Process32Next");
			m_pfnModuleFirst	= (fnModule32First)GetProcAddressRaw(m_hKernel,
				"Module32First");
			m_pfnModuleNext		= (fnModule32Next)GetProcAddressRaw(m_hKernel,
				"Module32Next");
#if !defined(IRIS_WIN32_WCE)
			m_pfnProcessFirstW	= (fnProcess32FirstW)GetProcAddressRaw(m_hKernel,
				"Process32FirstW");
			m_pfnProcessNextW	= (fnProcess32NextW)GetProcAddressRaw(m_hKernel,
				"Process32NextW");
			m_pfnModuleFirstW	= (fnModule32FirstW)GetProcAddressRaw(m_hKernel,
				"Module32FirstW");
			m_pfnModuleNextW	= (fnModule32NextW)GetProcAddressRaw(m_hKernel,
				"Module32NextW");
#endif
IRIS_MSC_PRAGMA_WARNING_END()
		}
		if( m_pfnCreate == nullptr ) return FALSE;
		if( m_dwFlags == dwFlags ) return TRUE;

		Close();
		HANDLE hProcess = CreateToolhelp32Snapshot(
									dwFlags, 0);
		if(hProcess == (HANDLE)-1)	return FALSE;
		m_hProcess = hProcess;
		m_dwFlags = dwFlags;
		return TRUE;
	}
	// 
	BOOL	Close(void)
	{
		HANDLE hProcess = m_hProcess;
		m_hProcess = nullptr;
		m_dwFlags = 0;
		return CloseHandle(hProcess);
	}

	DWORD	GetFlags(void)	const					{ return m_dwFlags; }
	BOOL	Heap32ListFirst(LPHEAPLIST32 lphl32)	{ return Heap32ListFirst(m_hProcess, lphl32); }
	BOOL	Heap32ListNext(LPHEAPLIST32 lphl32)		{ return Heap32ListNext(m_hProcess, lphl32); }
#if	defined(IRIS_WIN32_WCE)
	BOOL	Heap32First(LPHEAPENTRY32 lphe32, DWORD th32ProcessID, ULONG_PTR th32HeapID)		{ return Heap32First(m_hProcess, lphe32, th32ProcessID, th32HeapID); }
	BOOL	Heap32Next(LPHEAPENTRY32 lphe32)			{ return Heap32Next(m_hProcess, lphe32); }
#endif
	BOOL	Process32First(LPPROCESSENTRY32A lppe32)	{ return Process32First(m_hProcess, lppe32); }
	BOOL	Process32Next(LPPROCESSENTRY32A lppe32)		{ return Process32Next(m_hProcess, lppe32); }
#if !defined(IRIS_WIN32_WCE)
	BOOL	Process32FirstW(LPPROCESSENTRY32W lppe32)	{ return Process32FirstW(m_hProcess, lppe32); }
	BOOL	Process32NextW(LPPROCESSENTRY32W lppe32)	{ return Process32NextW(m_hProcess, lppe32); }
#endif
	BOOL	Thread32First(LPTHREADENTRY32 lpte32)		{ return Thread32First(m_hProcess, lpte32); }
	BOOL	Thread32Next(LPTHREADENTRY32 lpte32)		{ return Thread32Next(m_hProcess, lpte32); }
	BOOL	Module32First(LPMODULEENTRY32A lpme32)		{ return Module32First(m_hProcess, lpme32); }
	BOOL	Module32Next(LPMODULEENTRY32A lpme32)		{ return Module32Next(m_hProcess, lpme32); }
#if !defined(IRIS_WIN32_WCE)
	BOOL	Module32FirstW(LPMODULEENTRY32W lpme32)		{ return Module32FirstW(m_hProcess, lpme32); }
	BOOL	Module32NextW(LPMODULEENTRY32W lpme32)		{ return Module32NextW(m_hProcess, lpme32); }
#endif
};

}	// end of namespace

/**
 * @private
 * @internal
 * @brief	CToolHelp::NX
*/
class CToolHelp::CImpl : public CImplInstance
{
private:
	static CImpl**	GetInstancePtr(void)	{ static CImpl* pimpl = nullptr; return &pimpl; }
public:
	static CImpl*	GetInstance(void)		{ return *GetInstancePtr(); }
	static CImpl*	CreateInstance(void)
	{
		CImpl** ppimpl = GetInstancePtr();
		if( *ppimpl == nullptr )
		{
			CImpl* pImpl = new CImpl;
			*ppimpl = pImpl;
		}
		return *ppimpl;
	}
	static void		DeleteInstance(void)
	{
		CImpl** ppimpl = GetInstancePtr();
		IRIS_SAFE_DELETE( *ppimpl );
		*ppimpl = nullptr;
	}
};

//======================================================================
// CToolHelp

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CToolHelp::CToolHelp(void)
: m_pImpl(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CToolHelp::CToolHelp(const CToolHelp& rObject)
: m_pImpl(rObject.m_pImpl)
{
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
CToolHelp& CToolHelp::operator = ( CToolHelp& rObject )
{
	m_pImpl = rObject.m_pImpl;
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
	return *this;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CToolHelp::~CToolHelp(void)
{
	if( m_pImpl == nullptr ) return;
	m_pImpl->SubRef();
	if( m_pImpl->GetRef() <= 0 )
	{
		CImpl::DeleteInstance();
	}
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	CToolHelpCX^X
*//***********************************************************************/
CToolHelp CToolHelp::CreateImplement(void)
{
	CToolHelp ref;
	CImpl* pImpl = CImpl::GetInstance();
	if( pImpl == nullptr )
	{
		pImpl = CImpl::CreateInstance();
	}
	pImpl->AddRef();
	ref.m_pImpl = pImpl;
	return ref;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags	= TH32CS_***
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Open(DWORD dwFlags)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Open(dwFlags);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Close(void)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Close();
}

/**********************************************************************//**
 *
 * ŏ̃q[vubN擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lphe32			= o
 * @param [in]	th32ProcessId	= q[vێvZXReLXg̎ʎq
 * @param [in]	th32HeapId		= 񋓂q[v̎ʎq
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Heap32First(LPHEAPENTRY32 lphe32, DWORD th32ProcessId, ULONG_PTR th32HeapId)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Heap32First(lphe32, th32ProcessId, th32HeapId);
}

/**********************************************************************//**
 *
 * ̃q[vubN擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lphl32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Heap32Next(LPHEAPENTRY32 lphe32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Heap32Next(lphe32);
}

/**********************************************************************//**
 *
 * ŏ̃q[v擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lphl32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Heap32ListFirst(LPHEAPLIST32 lphl32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Heap32ListFirst(lphl32);
}

/**********************************************************************//**
 *
 * ̃q[v擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lphl32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Heap32ListNext(LPHEAPLIST32 lphl32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Heap32ListNext(lphl32);
}

/**********************************************************************//**
 *
 * ŏ̃vZX擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Process32First(LPPROCESSENTRY32A lppe32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Process32First(lppe32);
}
#if !defined(IRIS_WIN32_WCE)
BOOL CToolHelp::Process32First(LPPROCESSENTRY32W lppe32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Process32FirstW(lppe32);
}
#endif

/**********************************************************************//**
 *
 * ̃vZX擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Process32Next(LPPROCESSENTRY32A lppe32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Process32Next(lppe32);
}
#if !defined(IRIS_WIN32_WCE)
BOOL CToolHelp::Process32Next(LPPROCESSENTRY32W lppe32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Process32NextW(lppe32);
}
#endif

/**********************************************************************//**
 *
 * ŏ̃Xbh擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Thread32First(LPTHREADENTRY32 lpte32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Thread32First(lpte32);
}

/**********************************************************************//**
 *
 * ̃Xbh擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Thread32Next(LPTHREADENTRY32 lpte32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Thread32Next(lpte32);
}

/**********************************************************************//**
 *
 * ŏ̃W[擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Module32First(LPMODULEENTRY32A lpme32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Module32First(lpme32);
}
#if !defined(IRIS_WIN32_WCE)
BOOL CToolHelp::Module32First(LPMODULEENTRY32W lpme32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Module32FirstW(lpme32);
}
#endif

/**********************************************************************//**
 *
 * ̃W[擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpme32	= o
 * @return	
*//***********************************************************************/
BOOL CToolHelp::Module32Next(LPMODULEENTRY32A lpme32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Module32Next(lpme32);
}
#if !defined(IRIS_WIN32_WCE)
BOOL CToolHelp::Module32Next(LPMODULEENTRY32W lpme32)
{
	if( m_pImpl == nullptr ) return FALSE;
	return m_pImpl->Module32NextW(lpme32);
}
#endif

/**********************************************************************//**
 *
 * ̃vZXɊ蓖ĂꂽRs[
 *
 ----------------------------------------------------------------------
 * @param [out]	th32ProcessId		= vZXID
 * @param [out]	lpBaseAddr			= Rs[x[XAhX
 * @param [out]	lpBuffer			= o̓obt@
 * @param [out]	dwSize				= o̓obt@TCY
 * @param [out]	lpNumberOfBytesRead	= ǂݎTCYinullptrj
 * @return	
*//***********************************************************************/
BOOL CToolHelp::ReadProcessMemory(DWORD th32ProcessId, LPCVOID lpBaseAddr, LPVOID lpBuffer, DWORD dwSize, PSIZE_T lpNumberOfBytesRead)
{
	// MEMO : Impl ĂȂ
	return Toolhelp32ReadProcessMemory(th32ProcessId, lpBaseAddr, lpBuffer, dwSize, lpNumberOfBytesRead);
}

/**********************************************************************//**
 *
 * I[vtO̎擾
 *
 ----------------------------------------------------------------------
 * @return	tO
*//***********************************************************************/
DWORD CToolHelp::GetFlags(void)	const
{
	if( m_pImpl == nullptr ) return 0;
	return m_pImpl->GetFlags();
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include <tchar.h>
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXToolHelpUnitTest, Func)
{
	CToolHelp tlhelp = CToolHelp::CreateImplement();

	if( !tlhelp.Open(TH32CS_SNAPALL) ) return;

	while(1)
	{
		int cmd=0;
		std::cout << "0:quit 1:heaplist 2:process 3:thread 4:module" << std::endl;
		std::safe_cin >> cmd;

		switch( cmd )
		{
		case 0:
		default:
			return;
		case 1:
			{
				HEAPLIST32 hl32;
				hl32.dwSize = sizeof(hl32);
				BOOL ret = tlhelp.Heap32ListFirst(&hl32);
				while( ret )
				{
					printf( "HEAP ID:%d, PROCESS ID:%d\n", hl32.th32HeapID, hl32.th32ProcessID );
					ret = tlhelp.Heap32ListNext(&hl32);
				}
			}
			break;
		case 2:
			{
				PROCESSENTRY32 pe32;
				pe32.dwSize = sizeof(pe32);
				BOOL ret = tlhelp.Process32First(&pe32);
				while( ret )
				{
					_tprintf( TEXT("PROCESS ID:%d MODULE ID:%d\n"), pe32.th32ProcessID, pe32.th32ModuleID );
					ret = tlhelp.Process32Next(&pe32);
				}
			}
			break;
		case 3:
			{
				THREADENTRY32 te32;
				te32.dwSize = sizeof(te32);
				BOOL ret = tlhelp.Thread32First(&te32);
				while( ret )
				{
					_tprintf( TEXT("THREAD ID:%d OWNER PROCESS ID:%d\n"), te32.th32ThreadID, te32.th32OwnerProcessID );
					ret = tlhelp.Thread32Next(&te32);
				}
			}
			break;
		case 4:
			{
				MODULEENTRY32 me32;
				me32.dwSize = sizeof(me32);
				BOOL ret = tlhelp.Module32First(&me32);
				while( ret )
				{
					_tprintf( TEXT("%s\n"), me32.szModule );
					ret = tlhelp.Module32Next(&me32);
				}
			}
			break;
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
