//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCustomAccel.cpp
 * @brief		ANZ[^L[JX^}CY
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCustomAccel_CPP_

//======================================================================
// include
#include "WXCustomAccel.h"
#include <tchar.h>
#include <stdio.h>
#include <commctrl.h>
#include "../../wx_inchead.h"
#include "../../control/WXMenu.h"
#include "../../control/WXTabCtrl.h"
#include "../../registry/WXPrivateProfile.h"
#include "iris_debug.h"

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// define
namespace
{

static const TCHAR CUSTOMACCEL_INI_ENABLE[]		= TEXT("flag");
static const TCHAR CUSTOMACCEL_INI_FV[]			= TEXT("fv");
static const TCHAR CUSTOMACCEL_INI_KEY[]		= TEXT("key");
static const TCHAR CUSTOMACCEL_INI_OPTION[]		= TEXT("Option");
static const TCHAR CUSTOMACCEL_INI_WNDPLACE[]	= TEXT("WindowPlacement");

static const TCHAR CUSTOMACCEL_CLASSNAME[]		= TEXT("CCustomAccelDlg");
static const TCHAR CUSTOMACCEL_CLASSNAME_TAB[]	= TEXT("CCustomAccelTabDlg");

}

// resource id
#ifndef CCUSTOMACCEL_RESOURCEID_TOP
#define CCUSTOMACCEL_RESOURCEID_TOP			(6000)
#endif

#ifndef CCUSTOMACCEL_DLG_WIDTH
#define CCUSTOMACCEL_DLG_WIDTH				(360)
#endif
#ifndef CCUSTOMACCEL_HOTKEYEDIT_HEIGHT
#define CCUSTOMACCEL_HOTKEYEDIT_HEIGHT		(24)
#endif
#ifndef CCUSTOMACCEL_BUTTON_HEIGHT
#define CCUSTOMACCEL_BUTTON_HEIGHT			(22)
#endif

//======================================================================
// enum
typedef enum
{
	RESID_TOP = CCUSTOMACCEL_RESOURCEID_TOP,
	RESID_TABWND,
	RESID_TAB,

	RESID_CHECK1 = CCUSTOMACCEL_RESOURCEID_TOP + 50,

	RESID_HOTKEY1 = RESID_CHECK1 + 100,

	RESID_TERM
} ACCEL_RESOURCEID;


//======================================================================
// variable
static CCustomAccel* s_pCustomAccel = nullptr;
static bool	s_IsInitialize = false;

//======================================================================
// function
static LRESULT CALLBACK _DlgProc	(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	if( s_pCustomAccel == nullptr ) return 0;
	return s_pCustomAccel->DlgProc(hDlg, message, wParam, lParam);
}
static LRESULT CALLBACK _TabDlgProc	(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	if( s_pCustomAccel == nullptr ) return 0;
	return s_pCustomAccel->TabDlgProc(hDlg, message, wParam, lParam);
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCustomAccel::CCustomAccel(void)
: m_AccelNum(0)
, m_hInst(nullptr)
, m_hMenu(nullptr)
, m_ppGroupName(nullptr)
, m_GroupMaxNum(10)
, m_GroupNum(0)
, m_pHotkey(nullptr)
, m_pButton(nullptr)
, m_EditMenuGroup(0)
, m_pTempAccel(nullptr)
, m_EditS(0)
, m_EditE(0)
{
	for( int i=0; i < eTYPE_NUM; ++i )
	{
		m_pAccel[i] = nullptr;
		m_AccelTypeNum[i] = 0;
	}
	m_WndPlace.rcNormalPosition.left	= 0;
	m_WndPlace.rcNormalPosition.top		= 0;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCustomAccel::~CCustomAccel(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst			= CX^Xnh
 * @param [in]	hMenu			= ANZ[^L[ݒ̕擾Ώۃj[nh
 * @param [in]	hIcon			= _CAÕACR
 * @param [in]	pEdit			= ҏW\ANZ[^e[u
 * @param [in]	EditNum			= pEdit̏
 * @param [in]	pConst			= ҏW@\ȂANZ[^e[u
 * @param [in]	ConstNum		= pConst̏
 * @param [in]	pStaticConst	= ҏWs\ANZ[^e[u
 * @param [in]	StaticConstNum	= pStaticConst̏
 * @return	
*//***********************************************************************/
bool CCustomAccel::Initialize(HINSTANCE hInst, HMENU hMenu, HICON hIcon
							  , ACCELINFO *pEdit, int EditNum
							  , ACCELINFO *pConst, int ConstNum
							  , ACCELINFO *pStaticConst, int StaticConstNum)
{
	Release();
	m_hInst = hInst;
	m_hMenu = hMenu;

	const ACCELINFO*	p_ai[eTYPE_NUM] = { pEdit, pConst, pStaticConst };
	const int			n_ai[eTYPE_NUM] = { EditNum, ConstNum, StaticConstNum };

	for( int i=0; i < eTYPE_NUM; ++i )
	{
		int num = n_ai[i];
		if( p_ai[i] == nullptr ) num = 0;
		m_AccelTypeNum[i] = num;
		if( num > 0 )
		{
			m_AccelNum += num;
			m_pAccel[i] = new ACCELINFO [num];
			memcpy(m_pAccel[i], p_ai[i], sizeof(ACCELINFO)*num);
		}
	}

	int cnt=0;
	int group = -1;
	m_GroupMaxNum = -1;
	m_GroupNum = -1;
	ACCELINFO* ai = m_pAccel[eTYPE_EDIT];
	for( int i=0, n=m_AccelTypeNum[eTYPE_EDIT]; i < n; ++i, ++ai )
	{
		if( ai->group != group )
		{
			IRIS_ASSERTMSG( ai->group > group, "group order error.");
			if( cnt > m_GroupMaxNum ) m_GroupMaxNum = cnt;
			cnt = 0;
			group = ai->group;
			++m_GroupNum;
		}
		++cnt;
	}
	if( m_AccelTypeNum[eTYPE_EDIT] > 0 ) ++m_GroupNum;
	// O[vXg̐
	if( m_GroupNum > 0 )
	{
		m_ppGroupName = new TCHAR* [m_GroupNum];
		memset(m_ppGroupName, 0, sizeof(TCHAR*)*m_GroupNum);
	}
	// Rg[NX
	m_pHotkey = new CHotKey [m_GroupMaxNum];
	m_pButton = new CButton [m_GroupMaxNum];

	if( !s_IsInitialize )
	{
		// EBhENX̐ݒ
		if( !m_WindowClass.CreateEx<TCHAR>(CS_HREDRAW | CS_VREDRAW, hInst, _DlgProc
			, hIcon, LoadCursor(nullptr, IDC_ARROW), (HBRUSH)(COLOR_BTNFACE+1)
			, CUSTOMACCEL_CLASSNAME, nullptr, hIcon) )
		{
			return false;
		}
		if( !m_TabClass.CreateEx<TCHAR>(CS_HREDRAW | CS_VREDRAW, hInst, _TabDlgProc
			, hIcon, LoadCursor(nullptr, IDC_ARROW), (HBRUSH)(COLOR_BTNFACE+1)
			, CUSTOMACCEL_CLASSNAME_TAB, nullptr, hIcon) )
		{
			return false;
		}
		s_IsInitialize = true;
	}
	return true;
}

/**********************************************************************//**
 *
 * O[vo^
 *
 ----------------------------------------------------------------------
 * @param [in]	group	= O[vCfbNX
 * @param [in]	name	= O[v
 * @param [in]	size	= O[v
 * @return	
*//***********************************************************************/
bool CCustomAccel::SetGroupName(int group, LPCTSTR name, size_t size)
{
	if( m_ppGroupName == nullptr ) return false;
	int idx = GroupToIndex(group);
	if( idx < 0 || idx >= m_GroupNum ) return false;
	IRIS_SAFE_DELETE_ARRAY( m_ppGroupName[idx] );

	if( size <= 0 ) return false;
	if( name == nullptr ) return false;
	m_ppGroupName[idx] = new TCHAR [size+1];
	_tcscpy_s(m_ppGroupName[idx], size+1, name);
	return true;
}

/**********************************************************************//**
 *
 * O[vo^izŐݒj
 *
 ----------------------------------------------------------------------
 * @param [in]	ppArray	= O[vz
 * @param [in]	size	= O[vz
 * @return	
*//***********************************************************************/
bool CCustomAccel::SetGroupName(TCHAR** ppArray, int size)
{
	if( m_ppGroupName == nullptr ) return false;
	if( ppArray == nullptr ) return false;
	for( int i=0, n=size; i < n && i < m_GroupNum; ++i )
	{
		if( ppArray[i] == nullptr ) continue;
		IRIS_SAFE_DELETE_ARRAY( m_ppGroupName[i] );
		size_t len = _tcslen(ppArray[i]) + 1;
		m_ppGroupName[i] = new TCHAR [len];
		_tcscpy_s(m_ppGroupName[i], len , ppArray[i]);
	}
	return true;
}

/**********************************************************************//**
 *
 * O[vo^ij[玩ݒj
 *
 ----------------------------------------------------------------------
 * @param [in]	ppArray	= O[vz
 * @param [in]	size	= O[vz
 * @return	
*//***********************************************************************/
bool CCustomAccel::AutoSetGroupName(void)
{
	if( m_hMenu == nullptr ) return false;
	TCHAR str[256];
	ACCELINFO* ai = m_pAccel[eTYPE_EDIT];
	int idx = 0, n = m_AccelTypeNum[eTYPE_EDIT];
	int menu_num = ::GetMenuItemCount(m_hMenu);
	int grp = -1;
	UINT id = 0;
	for( int i=0, j=0; i < m_GroupNum; ++i )
	{
		for( ; j < n; ++j, ++ai )
		{
			if(ai->group != grp)
			{
				grp = ai->group;
				id = ai->resID;
				break;
			}
		}
		for( idx = 0; idx < menu_num; ++idx )
		{
			if( FindRootMenu(GetSubMenu(m_hMenu, idx), id) != nullptr ) break;
		}
		if( idx < menu_num )
		{
			GetMenuStringFromPos(m_hMenu, idx, str, 256);
			LPTSTR p = _tcsstr(str, TEXT("(&"));
			if( p != nullptr ) *p = TEXT('\0');
			SetGroupName(grp, str, _tcslen(str));
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCustomAccel::Release(void)
{
	for( int i=0; i < eTYPE_NUM; ++i )
	{
		IRIS_SAFE_DELETE_ARRAY( m_pAccel[i] );
		m_AccelTypeNum[i] = 0;
	}
	m_AccelNum = 0;
	for( int i=0; i < m_GroupNum; ++i )
	{
		IRIS_SAFE_DELETE_ARRAY( m_ppGroupName[i] );
	}
	IRIS_SAFE_DELETE_ARRAY( m_ppGroupName );
	IRIS_SAFE_DELETE_ARRAY( m_pHotkey );
	IRIS_SAFE_DELETE_ARRAY( m_pButton );

	m_WindowClass.Delete();
	m_TabClass.Delete();
}

/**********************************************************************//**
 *
 * O[vԍCfbNXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	group	= O[vԍ
 * @return	CfbNX
*//***********************************************************************/
int CCustomAccel::GroupToIndex(int group)
{
	int tmp = -1;
	int idx = -1;
	ACCELINFO* ai = m_pAccel[eTYPE_EDIT];
	for( int i=0, n=m_AccelTypeNum[eTYPE_EDIT]; i < n; ++i, ++ai )
	{
		if( ai->group != tmp )
		{
			tmp = ai->group;
			++idx;
		}
		if( ai->group == group ) break;
	}
	return idx;
}

/**********************************************************************//**
 *
 * CfbNXO[vԍɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	index	= CfbNX
 * @return	O[vԍ
*//***********************************************************************/
int CCustomAccel::IndexToGroup(int index)
{
	int tmp = -1;
	int idx = -1;
	ACCELINFO* ai = m_pAccel[eTYPE_EDIT];
	for( int i=0, n=m_AccelTypeNum[eTYPE_EDIT]; i < n; ++i, ++ai )
	{
		if( ai->group != tmp )
		{
			tmp = ai->group;
			++idx;
		}
		if( idx == index ) return ai->group;
	}
	return -1;
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	ptah	= pX
 * @return	
*//***********************************************************************/
bool CCustomAccel::Load(LPCTSTR path)
{
	if( path == nullptr ) return false;
	for( int i=0; i < eTYPE_SAVENUM; ++i )
	{
		ACCELINFO* ai = m_pAccel[i];
		for( int j=0, jn=m_AccelTypeNum[i]; j < jn; ++j, ++ai )
		{
			LPTSTR app = ai->comm;
			ai->flag= (GetPrivateProfileInt(app, CUSTOMACCEL_INI_ENABLE, ai->flag ? 1:0, path) != 0);
			ai->fv	= (BYTE)GetPrivateProfileInt(app, CUSTOMACCEL_INI_FV, ai->fv, path);
			ai->key = (BYTE)GetPrivateProfileInt(app, CUSTOMACCEL_INI_KEY, ai->key, path);
		}
	}

	if( GetPrivateProfileStruct( CUSTOMACCEL_INI_OPTION, CUSTOMACCEL_INI_WNDPLACE, &m_WndPlace, sizeof(m_WndPlace), path) )
	{
		if( (m_WndPlace.rcNormalPosition.right - m_WndPlace.rcNormalPosition.left) != CCUSTOMACCEL_DLG_WIDTH )
		{
			m_WndPlace.rcNormalPosition.right = m_WndPlace.rcNormalPosition.left + CCUSTOMACCEL_DLG_WIDTH;
		}
	}
	else
	{
		RECT rc;
		GetWindowRect( GetDesktopWindow(), &rc );
		LONG w = rc.right - rc.left;
		LONG h = rc.bottom - rc.top;
		rc.left		= (w-CCUSTOMACCEL_DLG_WIDTH)/2;
		rc.right	= (w+CCUSTOMACCEL_DLG_WIDTH)/2;
		rc.top		= (h-100)/2;
		rc.bottom	= (h+100)/2;
		m_WndPlace.rcNormalPosition = rc;
		m_WndPlace.length = 0;
	}
	return true;
}

/**********************************************************************//**
 *
 * ۑ
 *
 ----------------------------------------------------------------------
 * @param [in]	ptah	= pX
 * @return	
*//***********************************************************************/
bool CCustomAccel::Save(LPCTSTR path)
{
	if( path == nullptr ) return false;
	BOOL ret = 1;
	for( int i=0; i < eTYPE_SAVENUM; ++i )
	{
		ACCELINFO* ai = m_pAccel[i];
		for( int j=0, jn=m_AccelTypeNum[i]; j < jn; ++j, ++ai )
		{
			LPTSTR app = ai->comm;
			ret &= WritePrivateProfileString(app, CUSTOMACCEL_INI_ENABLE, ai->flag ? TEXT("1") : TEXT("0"), path);
			ret &= WritePrivateProfileInt(app, CUSTOMACCEL_INI_FV , ai->fv, path);
			ret &= WritePrivateProfileInt(app, CUSTOMACCEL_INI_KEY, ai->key, path);
		}
	}
	WritePrivateProfileStruct( CUSTOMACCEL_INI_OPTION, CUSTOMACCEL_INI_WNDPLACE, &m_WndPlace, sizeof(m_WndPlace), path);
	return (ret != 0);
}

/**********************************************************************//**
 *
 * ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hAccle	= ȑÕANZ[^L[nh
 * @return VANZ[^L[nh
*//***********************************************************************/
HACCEL CCustomAccel::SetAccel(HACCEL hAccel)
{
	DestroyAcceleratorTable(hAccel);

	ACCEL* accel = new ACCEL [ m_AccelNum ];

	for( int i=0, no=0; i < eTYPE_NUM; ++i )
	{
		ACCELINFO* ai = m_pAccel[i];
		for( int j=0, jn=m_AccelTypeNum[i]; j < jn; ++j, ++ai )
		{
			WORD cmd = ai->resID;
			if( ai->flag )
			{
				accel[no].fVirt	= ai->fv;
				accel[no].key	= ai->key;
				accel[no].cmd	= cmd;
				++no;
			}
		}
	}

	HACCEL hNewAccel = CreateAcceleratorTable(accel, m_AccelNum);
	IRIS_SAFE_DELETE_ARRAY( accel );
	return hNewAccel;
}

/**********************************************************************//**
 *
 * ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hAccle	= L[𔽉f郁j[nh
*//***********************************************************************/
void CCustomAccel::SetMenu(HMENU hMenu)
{
	HMENU menu;
	TCHAR str[256]=TEXT("");
	LPTSTR pc = str;
	MENUITEMINFO mi;
	ZeroMemory(&mi, sizeof(mi));
	mi.cbSize	= sizeof(mi);
	mi.fMask	= MIIM_ID | MIIM_TYPE;
	mi.fType	= MFT_STRING;

	for( int i=0; i < eTYPE_NUM; ++i )
	{
		ACCELINFO* ai = m_pAccel[i];
		for( int j=0, jn=m_AccelTypeNum[i]; j < jn; ++j, ++ai )
		{
			WORD cmd = ai->resID;
			mi.dwTypeData = 0;
			menu = FindMenuItemInfo(hMenu, cmd, MF_BYCOMMAND, &mi);
			if( menu != nullptr )
			{
				size_t size = 256;
				pc = str;
				++mi.cch;
				if( mi.cch > 256 )
				{
					// obt@Ȃ
					pc = new TCHAR [mi.cch];
					size = mi.cch;
				}
				mi.dwTypeData = pc;
				if( FindMenuItemInfo(menu, cmd, MF_BYCOMMAND, &mi) != nullptr )
				{
					LPTSTR p = _tcsrchr(pc, TEXT('\t'));
					if(p != nullptr) *p = TEXT('\0');
					if( ai->flag )
					{
						WORD key = ai->key;
						BYTE fv = ai->fv;
						_tcscat_s(pc, size, TEXT("\t"));
						TCHAR temp[8];
						if(fv & FCONTROL)
						{
							_tcscat_s(pc, size, TEXT("Ctrl+"));
						}
						if(fv & FSHIFT)
						{
							_tcscat_s(pc, size, TEXT("Shift+"));
						}
						if(fv & FALT)
						{
							_tcscat_s(pc, size, TEXT("Alt+"));
						}
						if( key >= TEXT('A') && key <= TEXT('Z'))
						{
							temp[0] = (TCHAR)key;
							temp[1] = TEXT('\0');
						}
						else if( key >= VK_F1 && key < VK_F24)
						{
							wsprintf(temp, TEXT("F%d"), key-VK_F1+1);
						}
						_tcscat_s(pc, size, temp);
					}

					SetMenuItemInfo(menu, cmd, 0, &mi);
				}

				if( pc != str )	IRIS_SAFE_DELETE_ARRAY( pc );
			}
		}
	}
}

/**********************************************************************//**
 *
 * ҏW_CAÕI[v
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent	= eEBhEnh
 * @param [in]	title	= ^Cg
 * @return	IR[h
*//***********************************************************************/
INT_PTR CCustomAccel::OpneDlg(HWND hParent, LPTSTR title)
{
	if( !s_IsInitialize ) return 0;
	if( s_pCustomAccel != nullptr ) return 0;
	HWND hWnd = nullptr;
	s_pCustomAccel = this;

	// Rs[쐬
	m_pTempAccel = new ACCELINFO [ m_AccelTypeNum[eTYPE_EDIT] ];
	memcpy(m_pTempAccel, m_pAccel[eTYPE_EDIT], sizeof(ACCELINFO)*m_AccelTypeNum[eTYPE_EDIT] );
	// TODO : ƂƌvZق
	int height = m_GroupMaxNum*CCUSTOMACCEL_HOTKEYEDIT_HEIGHT+CCUSTOMACCEL_BUTTON_HEIGHT + 22
		+ GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYDLGFRAME) + GetSystemMetrics(SM_CYBORDER);

	hWnd = m_Dlg.CreateWindow(CUSTOMACCEL_CLASSNAME_TAB, IRIS_TEXT("Edit Accelerator")
		, DS_SETFONT | DS_MODALFRAME | DS_FIXEDSYS | WS_POPUP | WS_CAPTION | WS_SYSMENU | WS_VISIBLE
		, CW_USEDEFAULT, CW_USEDEFAULT
		, CCUSTOMACCEL_DLG_WIDTH, height
		, hParent, nullptr, m_hInst, nullptr);
	if( hWnd != nullptr )
	{
		if( title != nullptr ) SetWindowText(hWnd, title);
		m_Dlg.DoModal();
	}
	// _CAȎIʂԂ
	s_pCustomAccel = nullptr;
	delete [] m_pTempAccel;
	m_pTempAccel = nullptr;
	return m_Dlg.GetExitCode();
}

/**********************************************************************//**
 *
 * ^u_CAO
 *
*//***********************************************************************/
LRESULT CALLBACK CCustomAccel::DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	// 
	case WM_CREATE:
		{
			if( m_pHotkey == nullptr ) return 0;
			HGDIOBJ hFont = GetStockObject(DEFAULT_GUI_FONT);
			RECT rc;
			GetClientRect(hDlg, &rc);
			int dh = (rc.bottom - rc.top);
			if( m_GroupMaxNum > 1 ) dh /= m_GroupMaxNum;
			int h  = dh * 5 / 6;
			int w  = (rc.right - rc.left);
			int hw = w / 3;
			int cw = w-hw-12;
			// ACe쐬
			for( int i=0; i < m_GroupMaxNum; ++i )
			{
				m_pButton[i].Create(WS_CHILD | BS_AUTOCHECKBOX | WS_TABSTOP
					, nullptr
					, 4, dh*i, cw, h
					, hDlg
					, RESID_CHECK1+i
					, nullptr );
				m_pButton[i].SetFont(hFont, 1);
				m_pButton[i].ShowWindow(SW_SHOW);

				m_pHotkey[i].Create(WS_CHILD | WS_BORDER | WS_TABSTOP
					, nullptr
					, rc.right-4-hw, dh*i, hw, h
					, hDlg
					, (RESID_HOTKEY1+i)
					, nullptr );
				m_pHotkey[i].SetFont(hFont, 1);
				m_pHotkey[i].ShowWindow(SW_SHOW);
				// [ݒiL[̒P̓͂͋֎~j
				m_pHotkey[i].SetRules(HKCOMB_NONE, HOTKEYF_ALT);
			}
			DeleteObject(hFont);
		}
	case WM_INITDIALOG:
		{
			m_EditS = m_AccelTypeNum[eTYPE_EDIT];
			m_EditE = m_AccelTypeNum[eTYPE_EDIT];
			bool b = true;
			int cnt=0;
			// O[v
			ACCELINFO* ai = m_pAccel[eTYPE_EDIT];
			for( int i=0, n=m_AccelTypeNum[eTYPE_EDIT]; i < n; ++i, ++ai )
			{
				if(b && ai->group == m_EditMenuGroup)
				{
					m_EditS = i;	// ҏWΏې擪CfbNXۑ
					b = false;
				}
				if(ai->group > m_EditMenuGroup )
				{
					m_EditE = i;	// ҏWΏۏI[CfbNXۑ
					break;
				}
			}

			// ҏWΏۂ̃f[^o^
			for(int no = m_EditS; no < m_EditE; ++cnt, ++no)
			{
				ACCELINFO* ai = &m_pTempAccel[no];
				m_pHotkey[cnt].ShowWindow(SW_SHOW);
				m_pButton[cnt].ShowWindow(SW_SHOW);
				//
				{
					WORD cmd = ai->resID;
					TCHAR str[256]=TEXT("");
					if( GetMenuStringFromID(m_hMenu, cmd, str, sizeof(str)) )
					{
						// j[𔭌
						int len = (int)_tcslen(str)+1;
						LPTSTR tmp = new TCHAR [len];
						_tcscpy_s(tmp, len, str);
						LPTSTR p = _tcsrchr(tmp, TEXT('\t'));
						if(p) *p = TEXT('\0');
						p = _tcsrchr(tmp, TEXT('('));
						if(p) *p = TEXT('\0');
						m_pButton[cnt].SetWindowText(tmp);
						delete [] tmp;
					}
					else
					{
						m_pButton[cnt].SetWindowText(ai->comm);
					}
				}
				m_pButton[cnt].SetCheck(ai->flag);
				BYTE mod = HKM_TransHotKeyF(ai->fv);
				m_pHotkey[cnt].SetHotKey(ai->key, mod);
			}
			// c͔\ɂ
			for(; cnt < m_GroupMaxNum; ++cnt)
			{
				ShowWindow(GetDlgItem(hDlg, RESID_CHECK1+cnt), SW_HIDE);
				m_pHotkey[cnt].ShowWindow(SW_HIDE);
			}
		}
		break;
	}
	return DefWindowProc(hDlg, message, wParam, lParam);
}

/**********************************************************************//**
 *
 * ^u_CAO
 *
*//***********************************************************************/
LRESULT CALLBACK CCustomAccel::TabDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	// 
	case WM_CREATE:
	case WM_INITDIALOG:
		{
			HGDIOBJ hFont = GetStockObject(DEFAULT_GUI_FONT);
			RECT rc, trc;
			GetClientRect(hDlg, &rc);
			HWND hWnd = nullptr;
			int th = rc.bottom-rc.top-28;
			m_EditMenuGroup = IndexToGroup(0);

			m_Tab.Create(WS_CHILD | WS_TABSTOP
				, 0, 0, rc.right-rc.left, th
				, hDlg
				, RESID_TAB
				, nullptr );
			m_Tab.SetFont(hFont, 1);
			m_Tab.ShowWindow(SW_SHOW);
			// ^uRg[̑}
			{
				TC_ITEM tcItem;
				tcItem.mask = TCIF_TEXT;
				for( int i=0; i < m_GroupNum; ++i )
				{
					TCHAR str[MAX_PATH];
					tcItem.pszText = m_ppGroupName[i];
					if( tcItem.pszText==nullptr )
					{
						// ftHg
						wsprintf(str, TEXT("Group %d"), i);
						tcItem.pszText = str;
					}
					m_Tab.InsertItem(i, &tcItem);
				}
			}

			int height = CCUSTOMACCEL_HOTKEYEDIT_HEIGHT;
			if( m_GroupMaxNum > 1 ) height *= m_GroupMaxNum;

			m_Tab.GetDrawRect(&trc);
			m_TabWindow.CreateWindow( CUSTOMACCEL_CLASSNAME, TEXT("")
				, DS_SETFONT | DS_FIXEDSYS | WS_CHILD
				, trc.left, trc.top + 4
				, trc.right-trc.left, height
				, hDlg, nullptr, m_hInst, nullptr);
			m_TabWindow.ShowWindow(SW_SHOW);
			trc.bottom = trc.top + height;
			m_Tab.DrawToWindowRect(&trc);
			trc.bottom += 8;
			m_Tab.MoveWindow(0, 0, trc.right-trc.left, trc.bottom-trc.top, 1);
			trc.bottom += 30;
			rc = trc;
			trc.bottom += GetSystemMetrics( SM_CYDLGFRAME )*2 + GetSystemMetrics( SM_CYCAPTION );

			hWnd = CreateWindow(WC_BUTTON, TEXT("OK"), WS_CHILD | WS_TABSTOP
				, rc.right-rc.left-132, rc.bottom-rc.top-CCUSTOMACCEL_BUTTON_HEIGHT-4, 60, CCUSTOMACCEL_BUTTON_HEIGHT
				, hDlg
				, (HMENU)IDOK
				, m_hInst
				, nullptr );
			SendMessage(hWnd, WM_SETFONT, (WPARAM)hFont, 1);
			ShowWindow(hWnd, SW_SHOW);

			hWnd = CreateWindow(WC_BUTTON, TEXT("LZ"), WS_CHILD | WS_TABSTOP
				, rc.right-rc.left-66, rc.bottom-rc.top-CCUSTOMACCEL_BUTTON_HEIGHT-4, 60, CCUSTOMACCEL_BUTTON_HEIGHT
				, hDlg
				, (HMENU)IDCANCEL
				, m_hInst
				, nullptr );
			SendMessage(hWnd, WM_SETFONT, (WPARAM)hFont, 1);

			GetWindowRect(hDlg, &rc);
			::AdjustWindowRect(&rc, GetWindowLong(hDlg, GWL_STYLE), FALSE);
			m_WndPlace.rcNormalPosition.right  = m_WndPlace.rcNormalPosition.left + (rc.right - rc.left);
			m_WndPlace.rcNormalPosition.bottom = m_WndPlace.rcNormalPosition.top  + (rc.bottom - rc.top);
			if( m_WndPlace.length == sizeof(WINDOWPLACEMENT) )
			{
				SetWindowPlacement(hDlg, &m_WndPlace);
			}
			else
			{
				trc = m_WndPlace.rcNormalPosition;
				LPPOINT pt = (LPPOINT)&trc;
				HWND hParent = GetParent(hDlg);
				if( hParent != nullptr ) ::ClientToScreen(hParent, pt);
				MoveWindow(hDlg, trc.left, trc.top, rc.right-rc.left, rc.bottom-rc.top, 1 );
			}

			ShowWindow(hWnd, SW_SHOW);
			DeleteObject(hFont);
		}
		break;
	case WM_NOTIFY:
		switch (((NMHDR *)lParam)->code)
		{
		// Ⴄy[Wꂽ
		case TCN_SELCHANGE:
			{
				// ҏWf[^擾
				for(int i=0, no = m_EditS; no < m_EditE; ++i, ++no)
				{
					ACCELINFO* ai = &m_pTempAccel[no];
					bool flag = (m_pButton[i].GetCheck() != 0);
					BYTE uMod, uKey;
					m_pHotkey[i].GetHotKey(&uKey, &uMod);
					ai->key = uKey;
					ai->fv = HKM_TransMod(uMod) | FVIRTKEY;
					if( ai->key == 0 )
					{
						flag = false;
					}
					ai->flag = flag;
				}
				// ҏW̃y[Wԍo^
				m_EditMenuGroup = IndexToGroup(m_Tab.GetCurSel());
				SendMessage(m_TabWindow.GetHWND(), WM_INITDIALOG, 0, 0);
			}
			break;
		}
		break;
	case WM_KEYDOWN:
		switch( wParam )
		{
		case VK_ESCAPE:
			SendMessage(hDlg, WM_CLOSE, 0, 0);
			break;
		}
		break;
	case WM_CLOSE:
		GetWindowPlacement(hDlg, &m_WndPlace);
		m_Dlg.EndDialog(IDCANCEL);
		break;
	// R}h
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDOK:
			{
				// f[^擾
				for(int i=0, no = m_EditS; no < m_EditE; ++i, ++no)
				{
					ACCELINFO* ai = &m_pTempAccel[no];
					bool flag = (m_pButton[i].GetCheck() != 0);
					BYTE uMod, uKey;
					m_pHotkey[i].GetHotKey(&uKey, &uMod);
					ai->key = uKey;
					ai->fv = HKM_TransMod(uMod) | FVIRTKEY;
					if( ai->key == 0 )
					{
						flag = false;
					}
					ai->flag = flag;
				}
				memcpy(m_pAccel[eTYPE_EDIT], m_pTempAccel, sizeof(ACCELINFO)*m_AccelTypeNum[eTYPE_EDIT]);
			}
			GetWindowPlacement(hDlg, &m_WndPlace);
			m_Dlg.EndDialog(IDOK);
			break;
		case IDCANCEL:
			GetWindowPlacement(hDlg, &m_WndPlace);
			m_Dlg.EndDialog(IDCANCEL);
			break;
		}
		break;
	}
	return DefWindowProc(hDlg, message, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
