//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInstallRegistry.h
 * @brief		WXg̃CXg[擾NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXInstallRegistry_H_
#define INCG_IRIS_WXInstallRegistry_H_

//======================================================================
// include
#include "../../registry/WXRegistry.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// CXg[WXg擾NX
class CInstallRegistry : public IIrisObject
{
public:
	// CXg[ς݂ǂ
	static bool		IsInstall (LPCTSTR pDisplayName);
	static bool		IsInstallA(LPCSTR  pDisplayName);
	static bool		IsInstallW(LPCWSTR pDisplayName);
	// CXg[pX̎擾
	static bool		GetPath (LPTSTR pDst, DWORD dwSize, LPCTSTR pDisplayName);
	static bool		GetPathA(LPSTR  pDst, DWORD dwSize, LPCSTR  pDisplayName);
	static bool		GetPathW(LPWSTR pDst, DWORD dwSize, LPCWSTR pDisplayName);

public:
	// CXg[ς݂ǂ
	template<typename _Op, typename _Arg>
	static bool		IsInstall(const _Op& func, _Arg pDisplayName)
	{
		CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
		CHAR key[MAX_PATH];
		DWORD key_size = MAX_PATH;
		CRegistry root;
		if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
		DWORD dwIndex = 0;
		DWORD dwValueSize = 0, dwType;
		for( dwIndex = 0; ; ++dwIndex )
		{
			LSTATUS lstatus = root.EnumKey(dwIndex, key, key_size);
			if( lstatus == ERROR_NO_MORE_ITEMS ) break;
			IRIS_ASSERT( lstatus == ERROR_SUCCESS );

			CRegistry reg;
			if( !reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) ) continue;

			if( reg.QueryValueEx("DisplayName", &dwType, nullptr, &dwValueSize) )
			{
				LPSTR value = new char [dwValueSize];
				if( reg.QueryValueEx("DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
				{
					if( func(value, pDisplayName) )
					{
						delete [] value;
						return true;
					}
				}
				delete [] value;
			}
		}
		return false;
	}

	// CXg[pX̎擾
	template<typename _Op, typename _Arg1, typename _Arg2>
	static bool		GetPath(const _Op& func, _Arg1 pDst, DWORD dwSize, _Arg2 pDisplayName)
	{
		CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
		CHAR key[MAX_PATH];
		DWORD key_size = MAX_PATH;
		CRegistry root;
		if( !root.OpenExA(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
		DWORD dwIndex = 0;
		DWORD dwValueSize = 0, dwType;
		for( dwIndex = 0; ; ++dwIndex )
		{
			LSTATUS lstatus = root.EnumKeyA(dwIndex, key, key_size);
			if( lstatus == ERROR_NO_MORE_ITEMS ) break;
			IRIS_ASSERT( lstatus == ERROR_SUCCESS );

			CRegistry reg;
			if( reg.OpenEx(root, key, 0, KEY_ALL_ACCESS) )
			{
				if( reg.QueryValueEx("DisplayName", &dwType, nullptr, &dwValueSize) )
				{
					LPSTR value = new char [dwValueSize];
					if( reg.QueryValueEx("DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
					{
						if( func(value, pDisplayName) )
						{
							if( reg.QueryValueEx("InstallLocation", &dwType, nullptr, &dwValueSize) )
							{
								delete [] value;
								if( pDst != nullptr && dwSize <= dwValueSize )
								{
									reg.QueryValueEx("InstallLocation", &dwType, pointer_cast<LPBYTE>(pDst), &dwValueSize);
								}
								return true;
							}
						}
					}
					delete [] value;
				}
			}
		}
		return false;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
