//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVSInstallRegistry.cpp
 * @brief		Visual Studio WXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXVSInstallRegistry_CPP_

//======================================================================
// include
#include "WXVSInstallRegistry.h"
#include "c++0x/cpp0x_regex.hpp"
#include "iris_debug.h"
#include "misc/iris_allegrex.h"

namespace iris {
namespace wx
{

namespace
{

//======================================================================
// variable
static const char* s_VSType[CVSInstallRegistry::eTYPENUM] =
{
	  ".*?"
	, "Studio"
	, "Basic"
	, "C\\+\\+"
	, "C#"
	, "Web"
};

//======================================================================
// struct
typedef struct _tagFindEnumInfo
{
	CVSInstallRegistry* dst;
	DWORD	index;
} FindEnumInfo;

}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CVSInstallRegistry::CVSInstallRegistry(void)
: m_AD(0)
, m_Type(0)
{
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	AD	= o[W()
 * @param [in]	Type= ^Cv
 * @return	
*//***********************************************************************/
bool CVSInstallRegistry::Open(int AD, int Type)
{
	CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	CRegistry root;
	Close();
	m_AD = AD;
	m_Type = Type;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return false;
	if( !root.EnumKeyProc(_EnumProcEntry, this) ) return false;
	if( !m_Registry.IsValid() ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CVSInstallRegistry::Close(void)
{
	m_AD = 0;
	m_Registry.Close();
}

/**********************************************************************//**
 *
 * ĊJ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex	= N_
 * @return	qbgCfbNXiqbgȂꍇ́A(DWORD)-1j
*//***********************************************************************/
DWORD CVSInstallRegistry::Find(DWORD dwIndex, int Type)
{
	return Find(dwIndex, 0, Type);
}

/**********************************************************************//**
 *
 * ĊJ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex	= N_
 * @param [in]	ad		= o[W()
 * @return	qbgCfbNXiqbgȂꍇ́A(DWORD)-1j
*//***********************************************************************/
DWORD CVSInstallRegistry::Find(DWORD dwIndex, int AD, int Type)
{
	FindEnumInfo fei = { this, dwIndex };
	CHAR root_key[] = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
	CRegistry root;
	Close();
	m_AD = AD;
	m_Type = Type;
	if( !root.OpenEx(HKEY_LOCAL_MACHINE, root_key, 0, KEY_ALL_ACCESS) ) return (DWORD)-1;
	if( !root.EnumKeyProc(_FindEnumProcEntry, &fei) ) return (DWORD)-1;
	if( !m_Registry.IsValid() ) return (DWORD)-1;
	return fei.index;
}

/**********************************************************************//**
 *
 * CXg[pX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	dwSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
bool CVSInstallRegistry::GetPath (LPTSTR lpString, DWORD dwSize)
{
#ifdef UNICODE
	return GetPathW(lpString, dwSize);
#else
	return GetPathA(lpString, dwSize);
#endif
}
/// CVSInstallRegistry::GetPath Q
bool CVSInstallRegistry::GetPathA(LPSTR  lpString, DWORD dwSize)
{
	DWORD dwType = 0;
	DWORD dwValueSize = 0;
	if( !m_Registry.IsValid() ) return false;
	if( !m_Registry.QueryValueEx("InstallLocation", &dwType, nullptr, &dwValueSize) ) return false;

	if( dwSize < dwValueSize ) return false;
	if( !m_Registry.QueryValueEx("InstallLocation", &dwType, pointer_cast<LPBYTE>(lpString), &dwValueSize) ) return false;
	return true;
}
/// CVSInstallRegistry::GetPath Q
bool CVSInstallRegistry::GetPathW(LPWSTR lpString, DWORD dwSize)
{
	DWORD dwType = 0;
	DWORD dwValueSize = 0;
	if( !m_Registry.IsValid() ) return false;
	if( !m_Registry.QueryValueEx(L"InstallLocation", &dwType, nullptr, &dwValueSize) ) return false;

	if( dwSize < dwValueSize ) return false;
	if( !m_Registry.QueryValueEx(L"InstallLocation", &dwType, pointer_cast<LPBYTE>(lpString), &dwValueSize) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * st@C̃pX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	dwSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
bool CVSInstallRegistry::GetExePath (LPTSTR lpString, DWORD dwSize)
{
#ifdef UNICODE
	return GetExePathW(lpString, dwSize);
#else
	return GetExePathA(lpString, dwSize);
#endif
}
/// CVSInstallRegistry::GetExePath Q
bool CVSInstallRegistry::GetExePathA(LPSTR  lpString, DWORD dwSize)
{
	if( !GetExeDirectoryPathA(lpString, dwSize) ) return false;
	switch( m_Type )
	{
	case VS:
		strcat_s(lpString, dwSize, "\\devenv.exe");
		break;
	case VC:
		strcat_s(lpString, dwSize, "\\VCExpress.exe");
		break;
	case VCS:
		strcat_s(lpString, dwSize, "\\VCSExpress.exe");
		break;
	}
	return true;
}
/// CVSInstallRegistry::GetExePath Q
bool CVSInstallRegistry::GetExePathW(LPWSTR lpString, DWORD dwSize)
{
	if( !GetExeDirectoryPathW(lpString, dwSize) ) return false;
	switch( m_Type )
	{
	case VS:
		wcscat_s(lpString, dwSize, L"\\devenv.exe");
		break;
	case VC:
		wcscat_s(lpString, dwSize, L"\\VCExpress.exe");
		break;
	case VCS:
		wcscat_s(lpString, dwSize, L"\\VCSExpress.exe");
		break;
	}
	return true;
}

/**********************************************************************//**
 *
 * st@C̃pX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpString	= o̓obt@
 * @param [in]	dwSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
bool CVSInstallRegistry::GetExeDirectoryPath (LPTSTR lpString, DWORD dwSize)
{
#ifdef UNICODE
	return GetExeDirectoryPathW(lpString, dwSize);
#else
	return GetExeDirectoryPathA(lpString, dwSize);
#endif
}
/// CVSInstallRegistry::GetExeDirectoryPath Q
bool CVSInstallRegistry::GetExeDirectoryPathA(LPSTR  lpString, DWORD dwSize)
{
	if( !GetPathA(lpString, dwSize) ) return false;
	strcat_s(lpString, dwSize, "Common7\\IDE");
	return true;
}
/// CVSInstallRegistry::GetExeDirectoryPath Q
bool CVSInstallRegistry::GetExeDirectoryPathW(LPWSTR lpString, DWORD dwSize)
{
	if( !GetPathW(lpString, dwSize) ) return false;
	wcscat_s(lpString, dwSize, L"Common7\\IDE");
	return true;
}

/**********************************************************************//**
 *
 * visual studio ̃^Cv擾
 *
 ----------------------------------------------------------------------
 * @return	^Cv
*//***********************************************************************/
int CVSInstallRegistry::GetType(void)
{
	return m_Type;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey	= L[
 * @param [in]	dwIndex	= CfbNX
 * @param [in]	lpArg	= CVSInstallRegistry*
*//***********************************************************************/
BOOL CVSInstallRegistry::_EnumProcEntry(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg)
{
	IRIS_ASSERT( lpArg != nullptr );
	CVSInstallRegistry* vsir = static_cast<CVSInstallRegistry*>(lpArg);
	return vsir->_EnumProc(rKey, dwIndex);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey	= L[
 * @param [in]	dwIndex	= CfbNX
*//***********************************************************************/
BOOL CVSInstallRegistry::_EnumProc(CRegistry& rKey, DWORD dwIndex)
{
	IRIS_UNUSED_VAR(dwIndex);
	BOOL ret = TRUE;
	DWORD dwValueSize = 0;
	CHAR key[MAX_PATH];
	CHAR type[128];
	int typenum = 0;
	if( m_Type == NONE )
	{
		strcpy_s(type, sizeof(type), s_VSType[eNONE]);
	}
	else
	{
		CHAR OR[2] = "";
		strcpy_s(type, sizeof(type), "(");
		for( int i=eVS; i < eTYPENUM; ++i )
		{
			if( m_Type & (1<<i) )
			{
				strcat_s(type, sizeof(type), OR);
				strcat_s(type, sizeof(type), s_VSType[i]);
				OR[0] = '|';
				OR[1] = '\0';
				++typenum;
			}
		}
		strcat_s(type, sizeof(type), ")");
	}
	if( m_AD )
	{
		sprintf_s(key, MAX_PATH, "Microsoft\\sVisual\\s%s\\s%d\\s(.*?Edition|.??Express)", type, m_AD);
	}
	else
	{
		sprintf_s(key, MAX_PATH, "Microsoft\\sVisual\\s%s\\s[0-9]*?\\s(.*?Edition|.??Express)", type);
	}
#if defined(_IRIS_SUPPORT_REGEX)
	DWORD dwType;
	cpp0x::tr1::cmatch r;
	cpp0x::tr1::regex regex(key);
	if( rKey.QueryValueEx("DisplayName", &dwType, nullptr, &dwValueSize) )
	{
		LPSTR value = new char [dwValueSize];
		if( rKey.QueryValueEx("DisplayName", &dwType, pointer_cast<LPBYTE>(value), &dwValueSize) )
		{
			if( cpp0x::tr1::regex_search(value, r, regex, cpp0x::tr1::regex_constants::match_default) )
			{
				if( rKey.QueryValueEx("InstallLocation", &dwType, nullptr, &dwValueSize) && dwValueSize > 1)
				{
					m_Registry.Attach( rKey.Detach() );
					if( m_AD == 0 )
					{
						cpp0x::tr1::regex regex2("[0-9]+");
						cpp0x::tr1::regex_search(value, r, regex2, cpp0x::tr1::regex_constants::match_default);
						m_AD = atoi(r.str().c_str());
					}
					if( m_Type == NONE || typenum > 1  )
					{
						for( int i=eVS; i < eTYPENUM; ++i )
						{
							cpp0x::tr1::regex regex2(s_VSType[i]);
							if( cpp0x::tr1::regex_search(value, r, regex2, cpp0x::tr1::regex_constants::match_default) )
							{
								m_Type = 1<<i;
								break;
							}
						}
					}
					ret = FALSE;
				}
			}
		}
		delete [] value;
	}
#else
	(void)typenum;
	ret = FALSE;
#endif
	return ret;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey	= L[
 * @param [in]	dwIndex	= CfbNX
 * @param [in]	lpArg	= CVSInstallRegistry*
*//***********************************************************************/
BOOL CVSInstallRegistry::_FindEnumProcEntry(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg)
{
	IRIS_ASSERT( lpArg != nullptr );
	FindEnumInfo* fei = static_cast<FindEnumInfo*>(lpArg);
	if( dwIndex <= fei->index && fei->index != (DWORD)-1 ) return TRUE;
	if( !fei->dst->_EnumProc(rKey, dwIndex) )
	{
		fei->index = dwIndex;
		return FALSE;
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
