//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWallpaper.cpp
 * @brief		ǎύXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXWallpaper_CPP_

//======================================================================
// include
#include "WXWallpaper.h"
#include "../../registry/WXRegistry.h"
#include "../../shell/WXActiveDesktop.h"

namespace iris {
namespace wx
{

//======================================================================
// define
#define DESKTOP_REG_ROOTA			"Control Panel\\desktop"
#define DESKTOP_REG_ROOTW			L"Control Panel\\desktop"
#define WALLPAPER_REG_NAMEA			"Wallpaper"
#define WALLPAPER_REG_NAMEW			L"Wallpaper"
#define TILEWALLPAPER_REG_NAMEA		"TileWallpaper"
#define TILEWALLPAPER_REG_NAMEW		L"TileWallpaper"
#define WALLPAPERSTYLE_REG_NAMEA	"Wallpaperstyle"
#define WALLPAPERSTYLE_REG_NAMEW	L"Wallpaperstyle"

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWallpaper::CWallpaper(void)
: m_pAD(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWallpaper::~CWallpaper(void)
{
	ReleaseActiveDesktop();
}

/**********************************************************************//**
 *
 * ANeBufXNgbv̎gp
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CWallpaper::CreateActiveDesktop(void)
{
	// ActiveDesktop̎gp݂
	if( m_pAD != nullptr ) return TRUE;
	m_pAD = new CActiveDesktop;
	if( m_pAD->Initialize() )
	{
		m_pAD->Activate(TRUE, TRUE);
		return TRUE;
	}
	IRIS_SAFE_DELETE( m_pAD );
	return FALSE;
}

/**********************************************************************//**
 *
 * ANeBufXNgbv̉
 *
*//***********************************************************************/
void CWallpaper::ReleaseActiveDesktop(void)
{
	IRIS_SAFE_DELETE(m_pAD);
}

/**********************************************************************//**
 *
 * ǎt@C̃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @param [in]	cchWallpaper	= lpszWallpaper̃obt@TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CWallpaper::GetWallpaper<CHAR>(LPSTR lpszWallpaper, UINT cchWallpaper) const
{
	if( lpszWallpaper == nullptr ) return FALSE;
	if( m_pAD != nullptr )
	{
		if( SUCCEEDED( m_pAD->GetWallpaper(lpszWallpaper, cchWallpaper) ) )
			return TRUE;
	}

	// WXg擾
	DWORD ValueType;
	DWORD ValueSize;
	CRegistry reg;
	if( !reg.OpenEx(HKEY_CURRENT_USER, DESKTOP_REG_ROOTA, 0, KEY_READ | KEY_WRITE) )
		return 0;
	if( !reg.QueryValueEx(WALLPAPER_REG_NAMEA, &ValueType, nullptr, &ValueSize) )
		return 0;
	if( ValueType != REG_SZ ) return FALSE;
	if( cchWallpaper < ValueSize ) return FALSE;
	return reg.QueryValueEx(WALLPAPER_REG_NAMEA, &ValueType, (LPBYTE)lpszWallpaper, &ValueSize);
}
template<>
BOOL CWallpaper::GetWallpaper<WCHAR>(LPWSTR lpszWallpaper, UINT cchWallpaper) const
{
	if( lpszWallpaper == nullptr ) return FALSE;
	if( m_pAD != nullptr )
	{
		if( SUCCEEDED( m_pAD->GetWallpaper(lpszWallpaper, cchWallpaper) ) )
			return TRUE;
	}

	// WXg擾
	DWORD ValueType;
	DWORD ValueSize;
	CRegistry reg;
	if( !reg.OpenEx(HKEY_CURRENT_USER, DESKTOP_REG_ROOTW, 0, KEY_READ | KEY_WRITE) )
		return 0;
	if( !reg.QueryValueEx(WALLPAPER_REG_NAMEW, &ValueType, nullptr, &ValueSize) )
		return 0;
	if( ValueType != REG_SZ ) return FALSE;
	if( cchWallpaper < ValueSize ) return FALSE;
	return reg.QueryValueEx(WALLPAPER_REG_NAMEW, &ValueType, (LPBYTE)lpszWallpaper, &ValueSize);
}

/**********************************************************************//**
 *
 * ǎt@C̃pXݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @return	
*//***********************************************************************/
template<>
BOOL CWallpaper::SetWallpaper<CHAR>(LPCSTR  lpszWallpaper)
{
	if( m_pAD != nullptr )
	{
		if( SUCCEEDED( m_pAD->SetWallpaper(lpszWallpaper) ) )
		{
			if( SUCCEEDED( m_pAD->ApplyChanges(AD_APPLY_ALL) ) )
				return TRUE;
		}
	}
	if( lpszWallpaper != nullptr )
	{
		LPCSTR p = strrchr(lpszWallpaper, '.');
		if( p == nullptr ) return FALSE;
 		if( strcmp(p, ".bmp") != 0 )	// bmp̂ݑΉ
			return FALSE;
	}

#if	!defined(IRIS_WIN32_WCE)
	if(!SystemParametersInfoA(SPI_SETDESKWALLPAPER, 0, (LPVOID)lpszWallpaper, SPIF_UPDATEINIFILE | SPIF_SENDCHANGE))
		return FALSE;
#endif
	// WXgݒ
	//CRegistry reg;
	//if( !reg.OpenExA(HKEY_CURRENT_USER, "Control Panel\\desktop", 0, KEY_READ | KEY_WRITE) )
	//	return FALSE;
	//if( !reg.SetValueExA("Wallpaper", REG_SZ, (const BYTE*)lpszWallpaper, (DWORD)strlen(lpszWallpaper) ) )
	//	return FALSE;
	return TRUE;
}
/// CWallpaper::SetWallpaper Q]
template<>
BOOL CWallpaper::SetWallpaper<WCHAR>(LPCWSTR lpszWallpaper)
{
	if( m_pAD != nullptr )
	{
		if( SUCCEEDED( m_pAD->SetWallpaper(lpszWallpaper) ) )
		{
			m_pAD->ApplyChanges(AD_APPLY_ALL);
			return TRUE;
		}
	}
	if( lpszWallpaper != nullptr )
	{
		LPCWSTR p = wcsrchr(lpszWallpaper, '.');
		if( p == nullptr ) return FALSE;
		if( wcscmp(p, L".bmp") != 0 )
			return FALSE;
	}

	if(!SystemParametersInfoW(SPI_SETDESKWALLPAPER, 0, (LPVOID)lpszWallpaper, SPIF_UPDATEINIFILE | SPIF_SENDCHANGE))
		return FALSE;
	//// WXgݒ
	//CRegistry reg;
	//if( !reg.OpenExW(HKEY_CURRENT_USER, L"Control Panel\\desktop", 0, KEY_READ | KEY_WRITE) )
	//	return FALSE;
	//if( !reg.SetValueExW(L"Wallpaper", REG_SZ, (const BYTE*)lpszWallpaper, (DWORD)wcslen(lpszWallpaper) ) )
	//	return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * X^C擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwStyle	= ǎ̃X^C
 * @return	
*//***********************************************************************/
BOOL CWallpaper::GetStyle(LPDWORD lpdwStyle)
{
	if( lpdwStyle == nullptr ) return FALSE;
	if( m_pAD != nullptr )
	{
		WALLPAPEROPT wpo;
		wpo.dwSize = sizeof(wpo);
		if( SUCCEEDED( m_pAD->GetWallpaperOptions( &wpo ) ) )
		{
			*lpdwStyle = wpo.dwStyle;
			return TRUE;
		}
	}

	// WXg擾
	DWORD ValueType;
	DWORD ValueSize;
	char cStyle[2];
	char cTile[2];
	CRegistry reg;
	if( !reg.OpenEx(HKEY_CURRENT_USER, DESKTOP_REG_ROOTA, 0, KEY_READ | KEY_WRITE) )
		return FALSE;
	if( !reg.QueryValueEx(WALLPAPERSTYLE_REG_NAMEA, &ValueType, nullptr, &ValueSize) )
		return FALSE;
	if( (ValueType != REG_SZ) || (ValueSize > 2) ) return FALSE;
	if( !reg.QueryValueEx(WALLPAPERSTYLE_REG_NAMEA, &ValueType, (LPBYTE)cStyle, &ValueSize) )
		return FALSE;

	if( !reg.QueryValueEx(TILEWALLPAPER_REG_NAMEA, &ValueType, nullptr, &ValueSize) )
		return FALSE;
	if( (ValueType != REG_SZ) || (ValueSize > 2) ) return FALSE;
	if( !reg.QueryValueEx(TILEWALLPAPER_REG_NAMEA, &ValueType, (LPBYTE)cTile, &ValueSize) )
		return FALSE;

	if( *cStyle == '0' && *cTile == '0' )
	{
		*lpdwStyle = eWPSTYLE_CENTER;
	}
	else if(*cStyle == '1' || (*cStyle == '0' && *cTile == '1'))
	{
		*lpdwStyle = eWPSTYLE_TILE;
	}
	else
	{
		*lpdwStyle = eWPSTYLE_STRETCH;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * X^Cݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle	= ǎ̃X^C
 * @return	
*//***********************************************************************/
BOOL CWallpaper::SetStyle(DWORD dwStyle)
{
	if( m_pAD != nullptr )
	{
		WALLPAPEROPT wpo;
		wpo.dwSize = sizeof(wpo);
		wpo.dwStyle = dwStyle;
		if( SUCCEEDED( m_pAD->SetWallpaperOptions(&wpo) ) )
		{
			m_pAD->ApplyChanges(AD_APPLY_ALL);
			return TRUE;
		}
	}

	// WXgݒ
	char cStyle[2] = "0";
	char cTile[2] = "0";
	if( dwStyle == eWPSTYLE_TILE )
	{
		*cStyle = *cTile = '1';
	}
	else if( dwStyle == eWPSTYLE_STRETCH )
	{
		*cStyle = '2';
	}
	CRegistry reg;
	if( !reg.OpenEx(HKEY_CURRENT_USER, DESKTOP_REG_ROOTA, 0, KEY_READ | KEY_WRITE) )
		return FALSE;
	if( !reg.SetValueEx(WALLPAPERSTYLE_REG_NAMEA, REG_SZ, (LPBYTE)cStyle, 1) )
		return FALSE;
	if( !reg.SetValueEx(TILEWALLPAPER_REG_NAMEA , REG_SZ, (LPBYTE)cTile , 1) )
		return FALSE;

	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CWXWallpaperUnitTest, Func)
{
	CWallpaper wallpaper;
	TCHAR path[MAX_PATH];
	for( int i=0; i < 2; ++i )
	{
		printf("ǎ̃t@CpXF");
		if( wallpaper.GetWallpaper(path, MAX_PATH) )
		{
			_putts(path);
		}
		else
		{
			puts("擾s");
		}
		DWORD dwStyle;
		printf("ǎ̃X^CF");
		if( wallpaper.GetStyle(&dwStyle) )
		{
			printf("%d\n", dwStyle);
		}
		else
		{
			puts("擾s");
		}

		if( i == 0 )
		{
			// 2ڂ̓ANeBufXNgbvg
			wallpaper.CreateActiveDesktop();
			puts("ANeBufXNgbvgp");
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
