//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXExplorer.cpp
 * @brief		Explorer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXExplorer_CPP_

//======================================================================
// include
#include "WXExplorer.h"
#include "iris_xchar.hpp"

namespace iris {
namespace wx
{

//======================================================================
template<typename T>
struct kCommand
{
	static const T* open;
	static const T* explorer;
	static const T* select;
};
template<>
const WCHAR* kCommand<WCHAR>::open = L"open";
template<>
const WCHAR* kCommand<WCHAR>::explorer = L"explorer";
template<>
const WCHAR* kCommand<WCHAR>::select = L"/select,";
template<>
const CHAR* kCommand<CHAR>::open = "open";
template<>
const CHAR* kCommand<CHAR>::explorer = "explorer";
template<>
const CHAR* kCommand<CHAR>::select = "/select,";

//======================================================================
// class

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpPath			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
template<typename CHARTYPE_>
HINSTANCE CTExplorer<CHARTYPE_>::Open(HWND hwnd, _Mylpcstr lpPath, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd)
{
	return Run(hwnd, kCommand<CHARTYPE_>::open, lpPath, lpParameters, lpDirectory, nShowCmd);
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpFile			= pX
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
template<typename CHARTYPE_>
HINSTANCE CTExplorer<CHARTYPE_>::OpenByFile(HWND hwnd, _Mylpcstr lpFile
					, _Mylpcstr lpDirectory, INT nShowCmd)
{
	_Mychar param[512];
	xcscpy_s(param, elementof(param), kCommand<CHARTYPE_>::select);
	xcscat_s(param, elementof(param), lpFile);
	return Run(hwnd, kCommand<CHARTYPE_>::open, kCommand<CHARTYPE_>::explorer, param, lpDirectory, nShowCmd);
}

template class CTExplorer<CHAR>;
template class CTExplorer<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXExplorerUnitTest, Func)
{
	CExplorer explorer;
	explorer.OpenByFile(nullptr, IRIS_TEXT("C:\\Windows"), nullptr, SW_SHOW);
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
