//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDPI.cpp
 * @brief		𑜓x擾NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDPI_CPP_

//======================================================================
// include
#include "WXDPI.h"
#include "../gdi/WXWndDC.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * 𑜓x̎擾ij
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 CDPI::GetHDPI(void)	const
{
	CWndDC hDC(GetDesktopWindow());
	s32 dpi = hDC.GetDeviceCaps(LOGPIXELSX);
	return dpi;
}

/**********************************************************************//**
 *
 * 𑜓x̎擾icj
 *
 -----------------------------------------------------------------------
 * @return 𑜓x
*//***********************************************************************/
s32 CDPI::GetVDPI(void)	const
{
	CWndDC hDC(GetDesktopWindow());
	s32 dpi = hDC.GetDeviceCaps(LOGPIXELSX);
	return dpi;
}

class CDPIInstance : public fnd::CDPI
{
	wx::CDPI	m_DPI;
public:
	// 𑜓x̎擾ij
	virtual s32	GetHDPI(void)	const	{ return m_DPI.GetHDPI(); }
	// 𑜓x̎擾icj
	virtual s32	GetVDPI(void)	const	{ return m_DPI.GetVDPI(); }
};

static CDPIInstance	s_dpiInstance_;

}	// end of namespace wx
}	// end of namespace iris
