//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDeviceContext.cpp
 * @brief		foCXReLXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDeviceContext_CPP_

//======================================================================
// include
#include "WXDeviceContext.h"
#include "../os/modules/WXMMsimg.h"
#include "../wx_inchead.h"

#include "../debug/WXDebugLeakCheckMacro.h"


//======================================================================
// link
#ifdef _IRIS_WX_SUPPORT_GRADIENT
#  pragma comment( lib, "msimg32.lib" )
#endif

namespace iris {
namespace wx
{

//======================================================================
// define

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDeviceContext::CDeviceContext(void)
: m_hDC(nullptr)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc	= AttachfoCXReLXg
*//***********************************************************************/
CDeviceContext::CDeviceContext(HDC hdc)
: m_hDC(nullptr)
{
	Attach(hdc);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc	= AttachfoCXReLXg
*//***********************************************************************/
CDeviceContext::CDeviceContext(CDeviceContext& rObj)
: m_hDC(nullptr)
{
	Attach(rObj.Detach());
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDeviceContext::~CDeviceContext(void)
{
	DeleteDC();
}

/**********************************************************************//**
 *
 * foCXReLXg֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC	= foCXReLXg
 * @return	
*//***********************************************************************/
bool CDeviceContext::Attach(HDC hDC)
{
	if( hDC == nullptr && m_hDC != nullptr )
		return false;
	m_hDC = hDC;
	return true;
}

/**********************************************************************//**
 *
 * foCXReLXg̊֘At𕪗
 *
 ----------------------------------------------------------------------
 * @return	֘AtĂfoCXReLXg
*//***********************************************************************/
HDC CDeviceContext::Detach(void)
{
	HDC hDC = m_hDC;
	if( hDC != nullptr )
	{
	}
	m_hDC = nullptr;
	return hDC;
}

/**********************************************************************//**
 *
 * foCXƃeLXgƌ݊̂郁foCXReLXg̍쐬
 *
 ----------------------------------------------------------------------
 * @return	foCXReLXg
*//***********************************************************************/
HDC CDeviceContext::CreateCompatibleDC(void)
{
	return ::CreateCompatibleDC( m_hDC );
}

/**********************************************************************//**
 *
 * foCXReLXgj
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::DeleteDC(void)
{
	if( m_hDC == nullptr ) return FALSE;
	return ::DeleteDC( Detach() );
}

/**********************************************************************//**
 *
 * foCXReLXg
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::Release(HWND hWnd)
{
	if( m_hDC == nullptr ) return FALSE;
	return ::ReleaseDC( hWnd, Detach() );
}

/**********************************************************************//**
 *
 * ̃NbsO[WAw肳ꂽ`O
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= `̍W
 * @param [in]	top			= `̏W
 * @param [in]	right		= `̉EW
 * @param [in]	bottom		= `̉W
 * @return	`̕G
 * @retval	NULLREGION		= Oڋ`͋
 * @retval	SIMPLEREGION	= P̋`
 * @retval	COMPLEXREGION	= GȌ`
 * @retval	ERROR			= G[
*//***********************************************************************/
int CDeviceContext::ExcludeClipRect(int left, int top, int right, int bottom)
{
	return ::ExcludeClipRect(m_hDC, left, top, right, bottom);
}

/**********************************************************************//**
 *
 * ݂̃NbsO[WɁA`
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= `̍W
 * @param [in]	top			= `̏W
 * @param [in]	right		= `̉EW
 * @param [in]	bottom		= `̉W
 * @return	`̕G
 * @retval	NULLREGION		= Oڋ`͋
 * @retval	SIMPLEREGION	= P̋`
 * @retval	COMPLEXREGION	= GȌ`
 * @retval	ERROR			= G[
*//***********************************************************************/
int CDeviceContext::IntersectClipRect(int left, int top, int right, int bottom)
{
	return ::IntersectClipRect(m_hDC, left, top, right, bottom);
}

/**********************************************************************//**
 *
 * ݂̃[Wƍ
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn		= [W
 * @param [in]	mode		= [W̑I[h(RGN_***)
 * @return	`̕G
 * @retval	NULLREGION		= Oڋ`͋
 * @retval	SIMPLEREGION	= P̋`
 * @retval	COMPLEXREGION	= GȌ`
 * @retval	ERROR			= G[
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
int CDeviceContext::ExtSelectClipRgn(HRGN hRgn, int mode)
{
	return ::ExtSelectClipRgn(m_hDC, hRgn, mode);
}
#endif

/**********************************************************************//**
 *
 * ݂̃pXƃ[W
 *
 ----------------------------------------------------------------------
 * @param [in]	mode		= [W̑I[h(RGN_***)
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::SelectClipPath(int mode)
{
	return ::SelectClipPath(m_hDC, mode);
}
#endif

/**********************************************************************//**
 *
 * [Wݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hRgn		= [W
 * @return	`̕G
 * @retval	NULLREGION		= Oڋ`͋
 * @retval	SIMPLEREGION	= P̋`
 * @retval	COMPLEXREGION	= GȌ`
 * @retval	ERROR			= G[
*//***********************************************************************/
int CDeviceContext::SelectClipRgn(HRGN hRgn)
{
	return ::SelectClipRgn(m_hDC, hRgn);
}

/**********************************************************************//**
 *
 * foCX̍ŏ̉`擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lprc		= o
 * @return	`̕G
 * @retval	NULLREGION		= Oڋ`͋
 * @retval	SIMPLEREGION	= P̋`
 * @retval	COMPLEXREGION	= GȌ`
 * @retval	ERROR			= G[
*//***********************************************************************/
int CDeviceContext::GetClipBox(LPRECT lprc) const
{
	return ::GetClipBox(m_hDC, lprc);
}

/**********************************************************************//**
 *
 * ݂̃[W擾
 *
 ----------------------------------------------------------------------
 * @param [out]	hRgn	= o
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::GetClipRgn(HRGN hRgn) const
{
	return ::GetClipRgn(m_hDC, hRgn);
}

/**********************************************************************//**
 *
 * ݂̃^̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	hRgn	= o
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::GetMetaRgn(HRGN hRgn) const
{
	return ::GetMetaRgn(m_hDC, hRgn);
}
#endif

/**********************************************************************//**
 *
 * VXeNbsO[WRs[
 *
 ----------------------------------------------------------------------
 * @param [out]	hRgn	= o
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::GetRandomRgn(HRGN hRgn) const
{
	return ::GetRandomRgn(m_hDC, hRgn, SYSRGN);
}
#endif

/**********************************************************************//**
 *
 * NbsO[Ẅړ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= ړ(x)
 * @param [in]	y	= ړ(y)
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
int CDeviceContext::OffsetClipRgn(int x, int y)
{
	return ::OffsetClipRgn(m_hDC, x, y);
}
#endif

/**********************************************************************//**
 *
 * wWNbsO[Wɂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::PtVisible(int x, int y) const
{
	return ::PtVisible(m_hDC, x, y);
}
#endif

/**********************************************************************//**
 *
 * wWNbsO[Wɂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= xW
 * @param [in]	y	= yW
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::RectVisible(const LPRECT lprc) const
{
	return ::RectVisible(m_hDC, lprc);
}

/**********************************************************************//**
 *
 * foCXReLXgɃIuWFNgI
 *
 ----------------------------------------------------------------------
 * @param [in]	hGDI	= GDIIuWFNg
 * @return	ȑOGDIIuWFNg
*//***********************************************************************/
HGDIOBJ CDeviceContext::SelectObject(HGDIOBJ hGDI)
{
	return ::SelectObject(m_hDC, hGDI);
}

/**********************************************************************//**
 *
 * foCXReLXgփrbg}bvRs[
 *
 ----------------------------------------------------------------------
 * @param [in]	 x		 = Rs[̋`̍xW
 * @param [in]	 y		 = Rs[̋`̍yW
 * @param [in]	 nWidth	 = Rs[̋`̕
 * @param [in]	 nHeight = Rs[̋`̍
 * @param [in]	 SrcDC	 = Rs[̃foCXReLXg̃nh
 * @param [in]	 xSrc	 = Rs[̋`̍xW
 * @param [in]	 ySrc	 = Rs[̋`̍yW
 * @param [in]	 dwRop	 = Rs[̃X^@w肷萔
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::BitBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC, int xSrc, int ySrc, DWORD dwRop)
{
	return ::BitBlt(m_hDC, x, y, nWidth, nHeight, SrcDC, xSrc, ySrc, dwRop);
}

/**********************************************************************//**
 *
 * rbg}bvgEkăRs[
 *
 ----------------------------------------------------------------------
 * @param	x			= Rs[̋`̍xW
 * @param	y			= Rs[̋`̍yW
 * @param	nWidth		= Rs[̋`̕
 * @param	nHeight		= Rs[̋`̍
 * @param	SrcDC		= Rs[̃foCXReLXg̃nh
 * @param	xSrc		= Rs[̋`̍xW
 * @param	ySrc		= Rs[̋`̍yW
 * @param	nSrcWidth	= Rs[̋`̕
 * @param	nSrcHeight	= Rs[̋`̍
 * @param	dwRop		= Rs[̃X^@w肷萔
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::StretchBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC
								, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop)
{
	return ::StretchBlt(m_hDC, x, y, nWidth, nHeight, SrcDC, xSrc, ySrc, nSrcWidth, nSrcHeight, dwRop);
}

/**********************************************************************//**
 *
 * wiJ[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	 color	= F
 * @return	BOOLl
*//***********************************************************************/
COLORREF CDeviceContext::SetBkColor(COLORREF color)
{
	return ::SetBkColor(m_hDC, color);
}

/**********************************************************************//**
 *
 * wiJ[擾
 *
 ----------------------------------------------------------------------
 * @return	F
*//***********************************************************************/
COLORREF CDeviceContext::GetBkColor( void ) const
{
	return ::GetBkColor( m_hDC );
}

/**********************************************************************//**
 *
 * wi[hݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	 rop2	= wi[h(OPAQUE or TRANSPARENT)
 * @return	O̔wi[h
*//***********************************************************************/
int CDeviceContext::SetBkMode(int mode)
{
	return ::SetBkMode(m_hDC, mode);
}

/**********************************************************************//**
 *
 * wi[h擾
 *
 ----------------------------------------------------------------------
 * @return	wi[h(OPAQUE or TRANSPARENT)
*//***********************************************************************/
int CDeviceContext::GetBkMode(void) const
{
	return ::GetBkMode( m_hDC );
}

/**********************************************************************//**
 *
 * eLXgJ[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	 color	= F
 * @return	BOOLl
*//***********************************************************************/
COLORREF CDeviceContext::SetTextColor(COLORREF color)
{
	return ::SetTextColor(m_hDC, color);
}

/**********************************************************************//**
 *
 * eLXgJ[擾
 *
 ----------------------------------------------------------------------
 * @return	F
*//***********************************************************************/
COLORREF CDeviceContext::GetTextColor(void) const
{
	return ::GetTextColor( m_hDC );
}

/**********************************************************************//**
 *
 * eLXgẅʒuɏo͂
 *
 ----------------------------------------------------------------------
 * @param [in]	 x			 = ̈ʒu
 * @param [in]	 y			 = c̈ʒu
 * @param [in]	 nCount		 = ̒
 * @param [in]	 lpszString	 = 
 * @return	BOOLl
*//***********************************************************************/
template<>
BOOL CDeviceContext::TextOut<CHAR>(int x, int y, int nCount, LPCSTR lpszString)
{
#if	defined(IRIS_WIN32_WCE)
	return FALSE;
		//return ::ExtTextOutA(m_hDC, x, y, 0, nullptr, lpszString, nCount, nullptr);
#else
	return ::TextOutA(m_hDC, x, y, lpszString, nCount);
#endif
}
template<>
BOOL CDeviceContext::TextOut<WCHAR>(int x, int y, int nCount, LPCWSTR lpszString)
{
#if	defined(IRIS_WIN32_WCE)
	return ::ExtTextOutW(m_hDC, x, y, 0, nullptr, lpszString, nCount, nullptr);
#else
	return ::TextOutW(m_hDC, x, y, lpszString, nCount);
#endif
}
template<>
BOOL CDeviceContext::TextOut<CHAR>(int x, int y, LPCSTR lpszString, ...)
{
	BOOL ret = FALSE;
	int size = 64;	// K
	char* buf = nullptr;
	va_list	va;
	va_start(va, lpszString);
	for( int i=0; i < 2; ++i )
	{
		buf = new char [size];
		int ret = _vsnprintf_s(buf, size, _TRUNCATE, lpszString, va);
		if( ret >= 0 && ret < size )
		{
			size = ret;
			break;
		}
#if !defined(IRIS_WIN32_WCE) && (_MSC_VER > _MSC_VER_VC6)
		size = _vscprintf(lpszString, va) + 1;
#else
		size = 1024;
#endif
		delete [] buf;
		buf = nullptr;
	}
	va_end(va);

	if( buf != nullptr )
	{
		ret = TextOut(x, y, size, buf);
		delete [] buf;
	}
	return ret;
}

/**********************************************************************//**
 *
 * eLXg`
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc		= \̈
 * @param [in]	format		= tH[}bg(DT_***)
 * @param [in]	nCount		= ̒
 * @param [in]	lpszString	= 
 * @return	BOOLl
*//***********************************************************************/
template<>
BOOL CDeviceContext::DrawText<CHAR>(LPRECT lprc, UINT format, int nCount, LPCSTR lpszString)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::DrawTextA(m_hDC, lpszString, nCount, lprc, format);
#else
	return FALSE;
#endif
}
template<>
BOOL CDeviceContext::DrawText<WCHAR>(LPRECT lprc, UINT format, int nCount, LPCWSTR lpszString)
{
	return ::DrawTextW(m_hDC, lpszString, nCount, lprc, format);
}
template<>
BOOL CDeviceContext::DrawText<CHAR>(LPRECT lprc, UINT format, LPCSTR lpszString, ...)
{
	BOOL ret = FALSE;
	int size = 64;	// K
	char* buf = nullptr;
	va_list	va;
	va_start(va, lpszString);
	for( int i=0; i < 2; ++i )
	{
		buf = new char [size];
		int ret = _vsnprintf_s(buf, size, _TRUNCATE, lpszString, va);
		if( ret >= 0 && ret < size )
		{
			size = ret;
			break;
		}
#if !defined(IRIS_WIN32_WCE) && (_MSC_VER > _MSC_VER_VC6)
		size = _vscprintf(lpszString, va) + 1;
#else
		size = 1024;
#endif
		delete [] buf;
		buf = nullptr;
	}
	va_end(va);

	if( buf != nullptr )
	{
		DrawText(lprc, format, size, buf);
		delete [] buf;
	}
	return ret;
}

/**********************************************************************//**
 *
 * At@uh
 *
 ----------------------------------------------------------------------
 * @param [in]	xorgDest	= dst  x N_
 * @param [in]	yorgDest	= dst  x N_
 * @param [in]	wDest		= dst ̕
 * @param [in]	hDest		= dst ̍
 * @param [in]	hdcSrc		= \[X
 * @param [in]	xorgDest	= src  x N_
 * @param [in]	yorgDest	= src  x N_
 * @param [in]	wDest		= src ̕
 * @param [in]	hDest		= src ̍
 * @param [in]	ftn			= uhIy[^
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::AlphaBlend(int xorgDest, int yorgDest, int wDest, int hDest
								, HDC hdcSrc, int xorgSrc, int yorgSrc, int wSrc, int hSrc, const BLENDFUNCTION& ftn)
{
	return CMsimg::AlphaBlend(m_hDC, xorgDest, yorgDest, wDest, hDest, hdcSrc, xorgSrc, yorgSrc, wSrc, hSrc, ftn);
}

/**********************************************************************//**
 *
 * _ړ
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= ̈ʒu
 * @param [in]	y	= c̈ʒu
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::MoveToEx(int x, int y, LPPOINT lppt)
{
	return ::MoveToEx(m_hDC, x, y, lppt);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	x	= ̈ʒu
 * @param [in]	y	= c̈ʒu
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::LineTo(int x, int y)
{
	return ::LineTo(m_hDC, x, y);
}

/**********************************************************************//**
 *
 * A
 *
 ----------------------------------------------------------------------
 * @param [in]	apt		= ʒu̔z
 * @param [in]	cpt		= zvf
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::Polyline(const POINT* apt, int cpt)
{
	return ::Polyline(m_hDC, apt, cpt);
}
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::PolylineTo(const POINT* apt, DWORD cpt)
{
	return ::PolylineTo(m_hDC, apt, cpt);
}
#endif

/**********************************************************************//**
 *
 * ̘A
 *
 ----------------------------------------------------------------------
 * @param [in]	apt		= ʒu̔z
 * @param [in]	asz		= eA̒_z
 * @param [in]	csz		= A̐
 * @return	BOOLl
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::PolyPolyline(const POINT* apt, const DWORD* asz, DWORD csz)
{
	return ::PolyPolyline(m_hDC, apt, asz, csz);
}
#endif

/**********************************************************************//**
 *
 * xWFȐ̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	apt		= ʒu̔z
 * @param [in]	cpt		= zvf
 * @return	BOOLl
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::PolyBezierTo(const POINT* apt, DWORD cpt)
{
	return ::PolyBezierTo(m_hDC, apt, cpt);
}
BOOL CDeviceContext::PolyBezier(const POINT* apt, DWORD cpt)
{
	return ::PolyBezier(m_hDC, apt, cpt);
}
#endif

/**********************************************************************//**
 *
 * ~̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= [
 * @param [in]	top			= [
 * @param [in]	right		= E[
 * @param [in]	bottom		= [
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::Ellipse(int left, int top, int right, int bottom)
{
	return ::Ellipse(m_hDC, left, top, right, bottom);
}

/**********************************************************************//**
 *
 * ʂ̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= [
 * @param [in]	top			= [
 * @param [in]	right		= E[
 * @param [in]	bottom		= [
 * @param [in]	sx			= n_xW
 * @param [in]	sy			= n_yW
 * @param [in]	ex			= I_xW
 * @param [in]	ey			= I_yW
 * @return	BOOLl
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::Arc(int left, int top, int right, int bottom, int sx, int sy, int ex, int ey)
{
	return ::Arc(m_hDC, left, top, right, bottom, sx, sy, ex, ey);
}
BOOL CDeviceContext::Pie(int left, int top, int right, int bottom, int sx, int sy, int ex, int ey)
{
	return ::Pie(m_hDC, left, top, right, bottom, sx, sy, ex, ey);
}
BOOL CDeviceContext::Chord(int left, int top, int right, int bottom, int sx, int sy, int ex, int ey)
{
	return ::Chord(m_hDC, left, top, right, bottom, sx, sy, ex, ey);
}
#endif

/**********************************************************************//**
 *
 * `̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= [
 * @param [in]	top			= [
 * @param [in]	right		= E[
 * @param [in]	bottom		= [
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::Rectangle(int left, int top, int right, int bottom)
{
	return ::Rectangle(m_hDC, left, top, right, bottom);
}

/**********************************************************************//**
 *
 * pے`̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	left		= [
 * @param [in]	top			= [
 * @param [in]	right		= E[
 * @param [in]	bottom		= [
 * @param [in]	width		= ۂݕ
 * @param [in]	height		= ۂݍ
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::RoundRect(int left, int top, int right, int bottom, int width, int height)
{
	return ::RoundRect(m_hDC, left, top, right, bottom, width, height);
}

/**********************************************************************//**
 *
 * p`̕`
 *
 ----------------------------------------------------------------------
 * @param [in]	apt			= ʒu̔z
 * @param [in]	cpt			= zvf
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::Polygon(const POINT* apt, int cpt)
{
	return ::Polygon(m_hDC, apt, cpt);
}

/**********************************************************************//**
 *
 * p`hԂ[h̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	mode		= hԂ[h(ALTERNATE or WINDING)
 * @return	O̓hԂ[h
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
int CDeviceContext::SetPolyFillMode(int mode)
{
	return ::SetPolyFillMode(m_hDC, mode);
}
#endif

/**********************************************************************//**
 *
 * p`hԂ[h̎擾
 *
 ----------------------------------------------------------------------
 * @return	hԂ[h
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
int CDeviceContext::GetPolyFillMode(void)
{
	return ::GetPolyFillMode( m_hDC );
}
#endif

/**********************************************************************//**
 *
 * hԂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lprc		= ̈
 * @param [in]	hbr			= uV
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::FillRect(const RECT* lprc, HBRUSH hbr)
{
	return ::FillRect( m_hDC, lprc, hbr );
}
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::FrameRect(const RECT* lprc, HBRUSH hbr)
{
	return ::FrameRect( m_hDC, lprc, hbr );
}
#endif

/**********************************************************************//**
 *
 * [W`
 *
 ----------------------------------------------------------------------
 * @param [in]	hrgn		= [W
 * @param [in]	hbr			= uV
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::FillRgn(HRGN hrgn, HBRUSH hbr)
{
	return ::FillRgn(m_hDC, hrgn, hbr);
}
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::PaintRgn(HRGN hrgn)
{
	return ::PaintRgn(m_hDC, hrgn);
}
#endif

/**********************************************************************//**
 *
 * [Wg`
 *
 ----------------------------------------------------------------------
 * @param [in]	hrgn		= [W
 * @param [in]	hbr			= uV
 * @param [in]	width		= ̐̕
 * @param [in]	height		= ̐̕
 * @return	BOOLl
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::FrameRgn(HRGN hrgn, HBRUSH hbr, int width, int height)
{
	return ::FrameRgn(m_hDC, hrgn, hbr, width, height);
}
#endif

/**********************************************************************//**
 *
 * sNZ`
 *
 ----------------------------------------------------------------------
 * @param [in]	x			= ̈ʒu
 * @param [in]	y			= c̈ʒu
 * @param [in]	color		= F
 * @return	BOOLl
*//***********************************************************************/
COLORREF CDeviceContext::SetPixel(int x, int y, COLORREF color)
{
	return ::SetPixel(m_hDC, x, y, color);
}

/**********************************************************************//**
 *
 * sNZ`iw̃J[ɍł߂F`悷j
 *
 ----------------------------------------------------------------------
 * @param [in]	x			= ̈ʒu
 * @param [in]	y			= c̈ʒu
 * @param [in]	color		= F
 * @return	BOOLl
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::SetPixelV(int x, int y, COLORREF color)
{
	return ::SetPixelV(m_hDC, x, y, color);
}
#endif

/**********************************************************************//**
 *
 * sNZJ[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	x			= ̈ʒu
 * @param [in]	y			= c̈ʒu
 * @return	F
*//***********************************************************************/
COLORREF CDeviceContext::GetPixel(int x, int y) const
{
	return ::GetPixel(m_hDC, x, y);
}

/**********************************************************************//**
 *
 * pX`Jn
 *
 ----------------------------------------------------------------------
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::BeginPath(void)
{
	return ::BeginPath(m_hDC);
}

/**********************************************************************//**
 *
 * pX`I
 *
 ----------------------------------------------------------------------
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::EndPath(void)
{
	return ::EndPath(m_hDC);
}

/**********************************************************************//**
 *
 * pXhԂ
 *
 ----------------------------------------------------------------------
 * @return	BOOLl
*//***********************************************************************/
BOOL CDeviceContext::StrokeAndFillPath(void)
{
	return ::StrokeAndFillPath(m_hDC);
}

/**********************************************************************//**
 *
 * X^Iy[V̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	rop2		= Oi[h(R2_***)
 * @return	ȎOi[h
*//***********************************************************************/
int CDeviceContext::SetROP2(int rop2)
{
	return ::SetROP2(m_hDC, rop2);
}

/**********************************************************************//**
 *
 * X^Iy[V̎擾
 *
 ----------------------------------------------------------------------
 * @return	Oi[h(R2_***)
*//***********************************************************************/
int CDeviceContext::GetROP2(void) const
{
	return ::GetROP2(m_hDC);
}

/**********************************************************************//**
 *
 * CAPS 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	index	= \͂̃CfbNX
 * @return	vڂɑΉl
*//***********************************************************************/
int CDeviceContext::GetDeviceCaps(int index) const
{
	return ::GetDeviceCaps(m_hDC, index);
}

/**********************************************************************//**
 *
 * ݂̃uVŃT[tFCXhԂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x		= Jn_(x)
 * @param [in]	y		= Jn_(y)
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::FloodFill(int x, int y, COLORREF color)
{
	return ::FloodFill(m_hDC, x, y, color);
}
#endif

/**********************************************************************//**
 *
 * ݂̃uVŃT[tFCXhԂ
 *
 ----------------------------------------------------------------------
 * @param [in]	x			= Jn_(x)
 * @param [in]	y			= Jn_(y)
 * @param [in]	color		= F
 * @param [in]	uFillType	= hԂ̎
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CDeviceContext::ExtFloodFill(int x, int y, COLORREF color, UINT uFillType)
{
	return ::ExtFloodFill(m_hDC, x, y, color, uFillType);
}
#endif

/**********************************************************************//**
 *
 * `ƎOp`hԂ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpVertex	= Op`̒_
 * @param [in]	nVertex		= Op`̒_
 * @param [in]	pMesh		= LPGRADIENT_TRIANGLE or LPGRADIENT_RECT
 * @param [in]	nMesh		= pMesh p[^̗vf
 * @param [in]	ulMode		= hԂ[h(GRADIENT_FILL_***)
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::GradientFill(LPTRIVERTEX lpVertex, ULONG nVertex, LPVOID pMesh, ULONG nMesh, ULONG ulMode)
{
#ifdef _IRIS_WX_SUPPORT_GRADIENT
	return ::GradientFill(m_hDC, lpVertex, nVertex, pMesh, nMesh, ulMode);
#else
	return CMsimg::GradientFill(m_hDC, lpVertex, nVertex, pMesh, nMesh, ulMode);
#endif
}

/**********************************************************************//**
 *
 * ݑIĂ DIB ZNṼrbg}bṽJ[e[ũGgF擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uStartIndex	= 擾JnCfbNX
 * @param [in]	uEntryies	= 擾
 * @param [out]	lpColors	= óBF
 * @return	
*//***********************************************************************/
UINT CDeviceContext::GetDIBColorTable(UINT uStartIndex, UINT uEntryies, LPRGBQUAD lpColors) const
{
	return ::GetDIBColorTable(m_hDC, uStartIndex, uEntryies, lpColors);
}

/**********************************************************************//**
 *
 * rbg}bvLk[h擾
 *
 ----------------------------------------------------------------------
 * @return	Lk[h
*//***********************************************************************/
int CDeviceContext::GetStretchBltMode(void) const
{
	return ::GetStretchBltMode(m_hDC);
}

/**********************************************************************//**
 *
 * rbg}bvLk[hݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	mode	= Lk[h
 * @return	ȑO̐Lk[h
*//***********************************************************************/
int CDeviceContext::SetStretchBltMode(int mode)
{
	return ::SetStretchBltMode(m_hDC, mode);
}

/**********************************************************************//**
 *
 * eLXg}gNX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lptm	= o
 * @return	
*//***********************************************************************/
BOOL CDeviceContext::GetTextMetricsA(LPTEXTMETRICA lptm) const
{
	return ::GetTextMetricsA(m_hDC, lptm);
}
BOOL CDeviceContext::GetTextMetricsW(LPTEXTMETRICW lptm) const
{
	return ::GetTextMetricsW(m_hDC, lptm);
}

/**********************************************************************//**
 *
 * Ot}gNX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uChar		= R[h
 * @param [in]	fuFormat	= tH[}bg
 * @param [in]	lpgm		= o
 * @param [in]	cjBuffer	= obt@TCY
 * @param [out]	pvBuffer	= tHgobt@
 * @param [in]	lpmat2		= }gbNX
 * @return	o̓obt@TCY
*//***********************************************************************/
DWORD CDeviceContext::GetGlyphOutlineA(UINT uChar, UINT fuFormat, LPGLYPHMETRICS lpgm, DWORD cjBuffer, LPVOID pvBuffer, const MAT2* lpmat2) const
{
	return ::GetGlyphOutlineA(m_hDC, uChar, fuFormat, lpgm, cjBuffer, pvBuffer, lpmat2);
}
DWORD CDeviceContext::GetGlyphOutlineW(UINT uChar, UINT fuFormat, LPGLYPHMETRICS lpgm, DWORD cjBuffer, LPVOID pvBuffer, const MAT2* lpmat2) const
{
	return ::GetGlyphOutlineW(m_hDC, uChar, fuFormat, lpgm, cjBuffer, pvBuffer, lpmat2);
}

/**********************************************************************//**
 *
 * LȃC[Wǂ
 *
 ----------------------------------------------------------------------
 * @return	obt@AhX
*//***********************************************************************/
bool CDeviceContext::IsValid(void)	const
{
	return m_hDC != nullptr;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
s32 CDeviceContext::GetWidth(void) const
{
	RECT rc;
	if( GetClipBox(&rc) == ERROR ) return 0;
	return rc.right - rc.left;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
s32 CDeviceContext::GetHeight(void) const
{
	RECT rc;
	if( GetClipBox(&rc) == ERROR ) return 0;
	return rc.bottom - rc.top;
}

/**********************************************************************//**
 *
 * sNZJ[̎擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDeviceContext::GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const
{
	COLORREF col = GetPixel(x, y);
	rgba.r = GetRValue(col);
	rgba.g = GetGValue(col);
	rgba.b = GetBValue(col);
	rgba.a = 0xFF;
	return true;
}

/**********************************************************************//**
 *
 * sNZJ[̐ݒ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDeviceContext::SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba)
{
	COLORREF col = RGB(rgba.r, rgba.g, rgba.b);
	return (SetPixel(x, y, col) != 0);
}

}	// end of namespace wx
}	// end of namespace iris
