//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiMetaFile.h
 * @brief		GDI^t@CIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXGdiMetaFile_CPP_

//======================================================================
// include
#include "WXGdiMetaFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGDIMetaFile::CGDIMetaFile(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGDIMetaFile::CGDIMetaFile(HENHMETAFILE hObj)
{
	Attach(hObj);
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CGDIMetaFile::CGDIMetaFile(const CGDIMetaFile& rObj)
{
	Attach(rObj);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CGDIMetaFile::~CGDIMetaFile(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * ֘Ats
 *
 ----------------------------------------------------------------------
 * @param [in]	hObj	= ֘Atnh
 * @return	
*//***********************************************************************/
BOOL CGDIMetaFile::TryAttach(HENHMETAFILE hObj)
{
#if !defined(IRIS_WIN32_WCE)
	if( Attach(hObj) ) return TRUE;
	::DeleteEnhMetaFile(hObj);
#endif
	return FALSE;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc			= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CGDIMetaFile::Create(HDC hdc)
{
#if !defined(IRIS_WIN32_WCE)
	return TryAttach( ::CloseEnhMetaFile(hdc) );
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Rs[
 *
 ----------------------------------------------------------------------
 * @param [in]	hObj		= Rs[nh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CGDIMetaFile::Copy<CHAR>(HENHMETAFILE hObj, LPCSTR lpFileName)
{
#if !defined(IRIS_WIN32_WCE)
	return TryAttach( ::CopyEnhMetaFileA(hObj, lpFileName) );
#else
	return FALSE;
#endif
}
template<>
BOOL CGDIMetaFile::Copy<WCHAR>(HENHMETAFILE hObj, LPCWSTR lpFileName)
{
#if !defined(IRIS_WIN32_WCE)
	return TryAttach( ::CopyEnhMetaFileW(hObj, lpFileName) );
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CGDIMetaFile::Delete(void)
{
#if !defined(IRIS_WIN32_WCE)
	return ::DeleteEnhMetaFile(Detach());
#else
	return TRUE;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CGDIMetaFile::Close(void)
{
	return IRIS_TO_bool(Delete());
}

}	// end of namespace wx
}	// end of namespace iris
