//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHIDPreparsedData.h
 * @brief		WXHIDPreparsedData t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXHIDPreparsedData_H_
#define INCG_IRIS_WXHIDPreparsedData_H_

//======================================================================
// include
#include "WXHID.h"

#if	defined(_IRIS_SUPPORT_WDK)

namespace iris {
namespace wx
{

//======================================================================
// class
/// HID NX
class CHIDPreparsedData : public IIrisObject
{
protected:
	PHIDP_PREPARSED_DATA	m_pData;	//!< f[^
public:
	// RXgN^
	CHIDPreparsedData(void);
	// fXgN^
	~CHIDPreparsedData(void);

public:
			PHIDP_PREPARSED_DATA&	operator ()(void)		{ return m_pData; }
	const	PHIDP_PREPARSED_DATA&	operator ()(void) const	{ return m_pData; }
	operator PHIDP_PREPARSED_DATA		(void)			{ return m_pData; }
	operator const PHIDP_PREPARSED_DATA (void) const	{ return m_pData; }

public:
	// HIDP_CAPS ̎擾
	BOOL	GetCaps(PHIDP_CAPS pCaps) const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
