//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMonitor.h
 * @brief		j^[foCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMonitor_H_
#define INCG_IRIS_WXMonitor_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

#if WINVER < 0x0500
typedef HANDLE	HMONITOR;
#endif

//======================================================================
// class
/**
 * @brief	j^[NX
*/
class CMonitor : public IHandleBase<HMONITOR>
{
	typedef IHandleBase<HMONITOR>	_MyBase;
public:
	// RXgN^
	CMonitor(void);
	CMonitor(HMONITOR hObj);
	CMonitor(const CMonitor& rhs);

public:
	// 
	virtual	bool	Close(void);

public:
	// ̎擾
	BOOL	GetInfo (LPMONITORINFO lpmi) const;
	BOOL	GetInfoA(LPMONITORINFO lpmi) const;
	BOOL	GetInfoW(LPMONITORINFO lpmi) const;

public:
	// ̈̎擾
	BOOL	GetRect(LPRECT lprc) const;
	BOOL	GetValidRect(LPRECT lprc) const;
	// vC}[j^[ǂ
	bool	IsPrimary(void) const;

protected:
	template<typename _FUNC>
	struct PARAM
	{
		MONITORENUMPROC		pfnEnum;
		LPARAM				lParam;
		const _FUNC*		pfnFunc;
	};
public:

	/**
	 * @brief	nh̗
	*/
	template<typename _FUNC>
	static BOOL	Enum(HDC hdc, LPRECT lprcClip, MONITORENUMPROC lpEnumFunc, LPARAM lParam, const _FUNC& func)
	{
		PARAM<_FUNC> p = { lpEnumFunc, lParam, &func };
		return ::EnumDisplayMonitors(hdc, lprcClip, _EnumMonitorsProc<_FUNC>, (LPARAM)&p);
	}

private:
	// 񋓊֐
	template<typename _FUNC>
	static BOOL CALLBACK _EnumMonitorsProc(HWND hWnd, LPARAM lParam)
	{
		PARAM<_FUNC>* param = reinterpret_cast<PARAM<_FUNC>*>(lParam);
		if( param->pfnFunc == nullptr || *(param->pfnFunc)(hWnd) )
		{
			if( param->pfnEnum != nullptr )
			{
				return param->pfnEnum(hWnd, param->lParam);
			}
		}
		return TRUE;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
