//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXBitmap.cpp
 * @brief		BitmapNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXBitmap_CPP_

//======================================================================
// include
#include "WXBitmap.h"
#include "../base/WXError.h"

#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CBitmap::CBitmap(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CBitmap::~CBitmap(void)
{
}

/**********************************************************************//**
 *
 * `(HDC)
 *
 -----------------------------------------------------------------------
 * @param [in]	hdc		= foCXReLXg
 * @param [in]	cx		= SW
 * @param [in]	cy		= SW
 * @param [in]	scale	= XP[
 * @param [in]	rop		= sNZIy[V(SRCCOPY etc...)
 * @return	
*//***********************************************************************/
void CBitmap::Draw(HDC hdc, s32 cx, s32 cy, f32 scale, DWORD rop)
{
	if( !IsValid() ) return;

	s32 dW = (s32)(m_bmp.info->biWidth*scale);
	s32 dH = (s32)(m_bmp.info->biHeight*scale);

	int ret = StretchDIBits(hdc, cx-(dW>>1), cy-(dH>>1), dW, dH
		, 0, 0, GetWidth(), GetHeight()
		, m_bmp.data, (LPBITMAPINFO)m_bmp.info
		, DIB_RGB_COLORS
		, rop);
	if( ret == 0 )
	{
		CScopedLastError e;
		CLastError le(e);
		printf("%d, %s\n", ret, le.ToStringA());
	}
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "../gdi/WXPaintStruct.h"
#include "iris_using.h"
#include "../../iris_iostream.h"
#include <stdio.h>
#include <string.h>
#include <tchar.h>

//======================================================================
// class
class CWXBitmapUnitTest : public iris::wx::dbg::CUnitTest<CWXBitmapUnitTest>
{
public:
	iris::wx::CBitmap m_bitmap;

public:
	virtual void OnPaint(HWND hWnd)
	{
		CPaintStruct ps(hWnd);
		m_bitmap.Draw(ps, m_bitmap.GetWidth()/2, m_bitmap.GetHeight()/2, 1.0f, SRCCOPY);
	}

protected:
	void test_base(void)
	{
		HWND hWnd = nullptr;

		RECT src = {0, 0, m_bitmap.GetWidth(), m_bitmap.GetHeight()};

		// EBhEg̒
		AdjustWindowRectEx(
			&src,
			WINDOW_STYLE,
			FALSE,
			WINDOW_STYLEEX );

		// EBhE̍쐬
		hWnd = wx::dbg::CreateUnitTestWindow(
			WINDOW_STYLEEX,
			GetTestName(),
			GetTestName(),
			WINDOW_STYLE,
			src.right,
			src.bottom,
			DrawTestWindowProc
			);

		// EBhE̍쐬Ɏs
		if( hWnd == nullptr ) return;

		// EBhE\
		ShowWindow(hWnd, SW_SHOW);
		// EBhE̍XV
		UpdateWindow(hWnd);
		// őOʂ
		SetForegroundWindow(hWnd);

		// bZ[W[v
		wx::dbg::UnitTestMainLoop(hWnd);
	}
};

//======================================================================
// test
IRIS_UNITTEST_F(CWXBitmapUnitTest, Bitmap)
{
	TCHAR path[MAX_PATH];
	std::cout << "Jbitmapt@C͂ĂB" << std::endl;
	std::tcin >> path;

	if( !m_bitmap.ReadFile(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	test_base();
}

#if defined(_IRIS_SUPPORT_PNG)

#include "fnd/image/FndPng.h"

IRIS_UNITTEST_F(CWXBitmapUnitTest, Png)
{
	TCHAR path[MAX_PATH];
	std::cout << "J png t@C͂ĂB" << std::endl;
	std::tcin >> path;
	fnd::CPng img;

	if( !img.ReadFile(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	m_bitmap.Duplicate(img);

	test_base();
}

#endif

#include "fnd/image/FndTga.h"

IRIS_UNITTEST_F(CWXBitmapUnitTest, Tga)
{
	TCHAR path[MAX_PATH];
	std::cout << "J tga t@C͂ĂB" << std::endl;
	std::tcin >> path;
	fnd::CTga img;

	if( !img.ReadFile(path) )
	{
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	m_bitmap.Duplicate(img);

	test_base();
}

#endif
