//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCursor.cpp
 * @brief		J[\NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCursor_CPP_

//======================================================================
// include
#include "WXCursor.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCursor::CCursor(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	hCursor = ֘AtJ[\nh
*//***********************************************************************/
CCursor::CCursor(HCURSOR hCursor)
: CIcon(hCursor)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCursor::~CCursor(void)
{
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	lpIconName	= J[\
 * @return	
*//***********************************************************************/
BOOL CCursor::LoadA(HINSTANCE hInst, LPCSTR  lpIconName)
{
#if	!defined(IRIS_WIN32_WCE)
	HCURSOR hCursor = ::LoadCursorA(hInst, lpIconName);
	return TryAttach(hCursor);
#else
	return FALSE;
#endif
}
/// CIcon::LoadA Q
BOOL CCursor::LoadW(HINSTANCE hInst, LPCWSTR lpIconName)
{
	HCURSOR hCursor = ::LoadCursorW(hInst, lpIconName);
	return TryAttach(hCursor);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	lpIconName	= J[\
 * @param [in]	cxDesired	= ]镝
 * @param [in]	cxDesired	= ]鍂
 * @param [in]	fuLoad		= [hIvViLR_***j
 * @return	
*//***********************************************************************/
BOOL CCursor::LoadA(HINSTANCE hInst, LPCSTR  lpIconName, int cxDesired, int cyDesired, UINT fuLoad)
{
#if	!defined(IRIS_WIN32_WCE)
	HCURSOR hCursor = reinterpret_cast<HCURSOR>(::LoadImageA(hInst, lpIconName, IMAGE_CURSOR, cxDesired, cyDesired, fuLoad));
	return TryAttach(hCursor);
#else
	return FALSE;
#endif
}
/// CCursor::LoadA Q
BOOL CCursor::LoadW(HINSTANCE hInst, LPCWSTR lpIconName, int cxDesired, int cyDesired, UINT fuLoad)
{
	HCURSOR hCursor = reinterpret_cast<HCURSOR>(::LoadImageW(hInst, lpIconName, IMAGE_CURSOR, cxDesired, cyDesired, fuLoad));
	return TryAttach(hCursor);
}

}	// end of namespace wx
}	// end of namespace iris
