//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIcon.h
 * @brief		ACRNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXIcon_H_
#define INCG_IRIS_WXIcon_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! nhNX
class CIcon : public IIrisObject
{
protected:
	HICON	m_hIcon;			//!< ACRnh
public:
	// RXgN^
	CIcon(void);
	// RXgN^
	CIcon(HICON hIcon);

	/// fXgN^
	virtual ~CIcon(void);

	HICON				GetHandle(void)		const	{ return m_hIcon; }
	HICON				GetIcon(void)		const	{ return m_hIcon; }
			operator	HICON (void)		{ return GetIcon(); }
	HICON	operator	() (void)			{ return GetIcon(); }
	CIcon&	operator	= (HICON hIcon)		{ Attach(hIcon); return *this; }

public:
	// ֘At
	BOOL	Attach(HICON hIcon);
	// ֘At
	HICON	Detach(void);

public:
	// 폜
	BOOL	Destroy(void);

public:
	// Lȃnhǂ
	BOOL	IsValid(void)	const	{ return IRIS_TO_BOOL(m_hIcon != nullptr); }

public:
	// 쐬
	BOOL	Create(HINSTANCE hInst, int nWidth, int nHeight, BYTE byPlanes, BYTE byBitsPixel, const BYTE* lpbANDbits, const BYTE* lpbXORbits);
	BOOL	CreateIndirect(PICONINFO pIconInfo);
#if	!defined(IRIS_WIN32_WCE)
	BOOL	CreateFromResource(PBYTE pResBits, DWORD dwResSize, DWORD dwVer=0x00030000);
	BOOL	CreateFromResourceEx(PBYTE pResBits, DWORD dwResSize, int w, int h, UINT uFlags, DWORD dwVer=0x00030000);
	// Rs[쐬
	BOOL	Copy(HICON hIcon);
	// 
	BOOL	Duplicate(HICON hIcon);
#endif
	// \[Xǂݍ
			template<typename CHARTYPE_>
			BOOL	Load (HINSTANCE hInst, const CHARTYPE_* lpIconName);
	virtual	BOOL	LoadA(HINSTANCE hInst, LPCSTR  lpIconName);
	virtual	BOOL	LoadW(HINSTANCE hInst, LPCWSTR lpIconName);

			template<typename CHARTYPE_>
			BOOL	Load (HINSTANCE hInst, const CHARTYPE_* lpIconName, int cxDesired, int cyDesired, UINT fuLoad);
	virtual	BOOL	LoadA(HINSTANCE hInst, LPCSTR  lpIconName, int cxDesired, int cyDesired, UINT fuLoad);
	virtual	BOOL	LoadW(HINSTANCE hInst, LPCWSTR lpIconName, int cxDesired, int cyDesired, UINT fuLoad);

	// t@CǍ
	BOOL	ExtractIconA(HINSTANCE hInst, LPCSTR  lpExeFileName, UINT uIndex);
	BOOL	ExtractIconW(HINSTANCE hInst, LPCWSTR lpExeFileName, UINT uIndex);
#if	!defined(IRIS_WIN32_WCE)
	// t@CǍ
	BOOL	ExtractAssociatedIconA(HINSTANCE hInst, LPSTR  lpPath, LPWORD lpIcon);
	BOOL	ExtractAssociatedIconW(HINSTANCE hInst, LPWSTR lpPath, LPWORD lpIcon);
#endif

public:
	// ACR̎擾
	BOOL	GetInfo(PICONINFO pIconInfo)	const;

public:
	// `
	BOOL	Draw(HDC hDC, int x, int y);
	BOOL	DrawEx(HDC hDC, int x, int y, int w, int h, HBRUSH hBrush, UINT diFlags);

protected:
	// 폜
	virtual	BOOL	Destroy(HICON hIcon)	{ return ::DestroyIcon(hIcon); }
	// ACR쐬̓o^
	inline	BOOL	TryAttach(HICON hIcon)
	{
		if( Attach(hIcon) ) return TRUE;
		Destroy(hIcon);
		return FALSE;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
