//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIconImage.h
 * @brief		icon C[WNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXIconImage_H_
#define INCG_IRIS_WXIconImage_H_

//======================================================================
// include
#include "WXIconFile.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//!< ACRC[WNX
class CIconImage : public fnd::IImage
{
protected:
	u8*						m_pBuffer;	//!< mۂ
	ICONIMAGE				m_Image;	//!< ACRC[W
public:
	// RXgN^
	CIconImage(void);
	// fXgN^
	virtual ~CIconImage(void);

public:
	// t@Cǂݍ
	bool	ReadFile(const CIconFile* lpFile, int nIndex);
	template<typename CHARTYPE_>
	bool	ReadFile(const CHARTYPE_* lpFileName, int nIndex)
	{
		CIconFile file;
		if( !file.Load(lpFileName) ) return false;
		return ReadFile(&file, nIndex);
	}

	// obt@ǂݍ
	bool	ReadOnMemory(const void* lpBuffer, int nIndex);
	bool	ReadOnMemory(const LPICONIMAGE lpIconImage);

protected:
	// obt@̊m
	bool	Alloc(u32 size);
public:
	// obt@̉
	void	Release(void);

public:
	// rbg}bv̍쐬
	bool	Create(u16 nBitCount, s32 nWidth, s32 nHeight);
	// Rs[
	bool	Duplicate(CIconImage& rIconImage);
	// Rs[
	bool	DuplicateOnMemory(const LPICONIMAGE lpIconImage);
	// wb_ɏ]ĕϊRs[
	bool	Transfer(CIconImage& rIconImage);

public:
	// f[^̃obt@TCY擾
	u32		GetBufferSize(void) const;
	// f[^Lǂ
	bool	IsValid(void) const;
	// ΉĂBitCountǂ
	static	bool	IsSupportedBitCoount(u16 nBitCount);

public:
	// rbgJEg擾
	u16				GetBitCount(void) const;
	// C[Wobt@̎擾
	u8*				GetXOR(void) const;
	// C[Wobt@̎擾
	void*			GetXOR(s32 x, s32 y) const;
	// }XNC[W̎擾
	u8*				GetAND(void) const;
	// }XNC[W̎擾
	BOOL			GetAND(s32 x, s32 y) const;
	// }XNC[W̐ݒ
	bool			SetAND(s32 x, s32 y, BOOL bAlpha);
	// pbg̎擾
	IrisRGBQUAD*	GetPallete(u32 idx) const;
	// pbgobt@̎擾
	IrisRGBQUAD*	GetPallete(void) const;
	// pbǧ擾
	u32				GetPalleteNum(void) const;

public:
	// sNZJ[̎擾
	virtual bool			GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool			SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	/// wb_[擾
	fnd::LPBMPINFOHEADER	GetInfoHeader(void)		{ return m_Image.pBmpInfo; }
	/// 擾
	virtual s32				GetWidth(void)	const	{ return m_Image.pBmpInfo->biWidth; }
	/// 擾
	virtual s32				GetHeight(void)	const	{ return m_Image.pBmpInfo->biHeight>>1; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
