//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFTP.cpp
 * @brief		FTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFTP_CPP_

//======================================================================
// include
#include "WXFTP.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFTP::CFTP(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hConnect		= ֘Atnh
*//***********************************************************************/
CFTP::CFTP(HINTERNET hConnect)
: CInternet(hConnect)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFTP::~CFTP(void)
{
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszSearchFile	= t@C(nullptr\)
 * @param [in]	lpFindFileData	= 
 * @param [in]	dwFlags			= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	nh
*//***********************************************************************/
template<>
HINTERNET CFTP::FindFirst<CHAR>(LPCSTR  lpszSearchFile, LPWIN32_FIND_DATAA lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpFindFirstFileA(m_hInternet, lpszSearchFile, lpFindFileData, dwFlags, dwContext);
}
/** @ref FindFirst */
template<>
HINTERNET CFTP::FindFirst<WCHAR>(LPCWSTR lpszSearchFile, LPWIN32_FIND_DATAW lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpFindFirstFileW(m_hInternet, lpszSearchFile, lpFindFileData, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * [gt@C擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszRemoteFile	= [g̃t@C
 * @param [in]	lpszNewFile		= ]t@C
 * @param [in]	bExists			= [JɊɑ݂ꍇɃG[ɂꍇ́ATRUE
 * @param [in]	dwAttributes	= FILE_ATTRIBUTE_***
 * @param [in]	dwFlags			= tO(FTP_TRANSFER_TYPE_*** or INTERNET_FLAG_***)
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::GetFile<CHAR>(LPCSTR  lpszRemoteFile, LPCSTR  lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileA(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}
/** @ref GetFile */
template<>
BOOL CFTP::GetFile<WCHAR>(LPCWSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileW(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}
/** @ref GetFile */
BOOL CFTP::GetFileEx(LPCSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileEx(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * [J烊[g̃t@C]
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszLocalFile			= [Jt@C
 * @param [in]	lpszNewRemoteFile		= ]t@C
 * @param [in]	dwFlags					= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext				= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::PutFile<CHAR>(LPCSTR  lpszLocalFile, LPCSTR  lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileA(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}
/** @ref PutFile */
template<>
BOOL CFTP::PutFile<WCHAR>(LPCWSTR lpszLocalFile, LPCWSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileW(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}
/** @ref PutFile */
BOOL CFTP::PutFileEx(LPCWSTR lpszLocalFile, LPCSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileEx(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * t@C폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::DeleteFile<CHAR>(LPCSTR  lpszFileName)
{
	return ::FtpDeleteFileA(m_hInternet, lpszFileName);
}
/** @ref DeleteFile */
template<>
BOOL CFTP::DeleteFile<WCHAR>(LPCWSTR lpszFileName)
{
	return ::FtpDeleteFileW(m_hInternet, lpszFileName);
}

/**********************************************************************//**
 *
 * l[
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszExisting	= ̃t@C
 * @param [in]	lpszNew			= VKt@C
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::RenameFile<CHAR>(LPCSTR  lpszExisting, LPCSTR  lpszNew)
{
	return ::FtpRenameFileA(m_hInternet, lpszExisting, lpszNew);
}
/** @ref RenameFile */
template<>
BOOL CFTP::RenameFile<WCHAR>(LPCWSTR lpszExisting, LPCWSTR lpszNew)
{
	return ::FtpRenameFileW(m_hInternet, lpszExisting, lpszNew);
}

/**********************************************************************//**
 *
 * t@CJ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @param [in]	dwAccess		= ANZXtO(GENERIC_READ, GENERIC_WRITE)
 * @param [in]	dwFlags			= tO((FTP_TRANSFER_TYPE_*** or INTERNET_FLAG_***))
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	nh
*//***********************************************************************/
template<>
HINTERNET CFTP::OpenFile<CHAR>(LPCSTR  lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpOpenFileA(m_hInternet, lpszFileName, dwAccess, dwFlags, dwContext);
}
/** @ref OpenFile */
template<>
HINTERNET CFTP::OpenFile<WCHAR>(LPCWSTR lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpOpenFileW(m_hInternet, lpszFileName, dwAccess, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * fBNg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNg
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::CreateDirectory<CHAR>(LPCSTR  lpszDirectory)
{
	return ::FtpCreateDirectoryA(m_hInternet, lpszDirectory);
}
/** @ref CreateDirectory */
template<>
BOOL CFTP::CreateDirectory<WCHAR>(LPCWSTR lpszDirectory)
{
	return ::FtpCreateDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * fBNg폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNg
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::RemoveDirectory<CHAR>(LPCSTR  lpszDirectory)
{
	return ::FtpRemoveDirectoryA(m_hInternet, lpszDirectory);
}
/** @ref RemoveDirectory */
template<>
BOOL CFTP::RemoveDirectory<WCHAR>(LPCWSTR lpszDirectory)
{
	return ::FtpRemoveDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * JgfBNgύX
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= JgfBNg
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::SetCurrentDirectory<CHAR>(LPCSTR  lpszDirectory)
{
	return ::FtpSetCurrentDirectoryA(m_hInternet, lpszDirectory);
}
/** @ref SetCurrentDirectory */
template<>
BOOL CFTP::SetCurrentDirectory<WCHAR>(LPCWSTR lpszDirectory)
{
	return ::FtpSetCurrentDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * JgfBNg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= óBJgfBNg
 * @param [in]	lpdwSize		= obt@TCYíj݃TCYiój
 * @return	
*//***********************************************************************/
template<>
BOOL CFTP::GetCurrentDirectory<CHAR>(LPSTR  lpszDirectory, LPDWORD lpdwSize)
{
	return ::FtpGetCurrentDirectoryA(m_hInternet, lpszDirectory, lpdwSize);
}
/** @ref GetCurrentDirectory */
template<>
BOOL CFTP::GetCurrentDirectory<WCHAR>(LPWSTR lpszDirectory, LPDWORD lpdwSize)
{
	return ::FtpGetCurrentDirectoryW(m_hInternet, lpszDirectory, lpdwSize);
}

/**********************************************************************//**
 *
 * R}hM
 *
 ----------------------------------------------------------------------
 * @param [in]	fExpectResponse	= 
 * @param [in]	dwFlags			= tO
 * @param [in]	lpszCommand		= R}h
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @param [in]	phFtpCommand	= 
 * @return	
*//***********************************************************************/
BOOL CFTP::Command (BOOL fExpectResponse, DWORD dwFlags, LPCTSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommand (m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}
/// CFTP::Command Q
BOOL CFTP::CommandA(BOOL fExpectResponse, DWORD dwFlags, LPCSTR  lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommandA(m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}
/// CFTP::Command Q
BOOL CFTP::CommandW(BOOL fExpectResponse, DWORD dwFlags, LPCWSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommandW(m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}

/**********************************************************************//**
 *
 * t@CTCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwFileSizeHigh	= TCYDWROD
 * @return	TCY
*//***********************************************************************/
DWORD CFTP::FtpGetFileSize(LPDWORD lpdwFileSizeHigh)
{
	return ::FtpGetFileSize(m_hInternet, lpdwFileSizeHigh);
}

}	// end of namespace wx
}	// end of namespace iris
