//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFTP.h
 * @brief		FTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFTP_H_
#define INCG_IRIS_WXFTP_H_

//======================================================================
// include
#include "WXInternet.h"
#include "ml/iml_type_select.hpp"
#include "c++0x/cpp0x_type_traits.hpp"

namespace iris {
namespace wx
{

//======================================================================
// class
//! FTPNX
class CFTP : public CInternet
{
public:
	template<typename CHARTYPE_>
	struct CharSet
	{
		typedef CHARTYPE_	type;
		typedef CHARTYPE_	*ptr;

		typedef typename iml::type_select< (cpp0x::is_same<type, WCHAR>::value), WIN32_FIND_DATAW, WIN32_FIND_DATAA >::type XWIN32_FIND_DATA;
		typedef XWIN32_FIND_DATA	*LPXWIN32_FIND_DATA;
	};
public:
	// RXgN^
	CFTP(void);
	CFTP(HINTERNET hConnect);
	// fXgN^
	~CFTP(void);

public:

	// t@C
	template<typename CHARTYPE_>
	HINTERNET	FindFirst(const CHARTYPE_*  lpszSearchFile, typename CharSet<CHARTYPE_>::LPXWIN32_FIND_DATA lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext=0);

	// [gt@C擾
	template<typename CHARTYPE_>
	BOOL		GetFile(const CHARTYPE_* lpszRemoteFile, const CHARTYPE_* lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		GetFileEx(LPCSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext=0);
	// [J烊[g̃t@C]
	template<typename CHARTYPE_>
	BOOL		PutFile(const CHARTYPE_* lpszLocalFile, const CHARTYPE_* lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		PutFileEx(LPCWSTR lpszLocalFile, LPCSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext=0);
	// t@C폜
	template<typename CHARTYPE_>
	BOOL		DeleteFile(const CHARTYPE_* lpszFileName);
	// l[
	template<typename CHARTYPE_>
	BOOL		RenameFile(const CHARTYPE_* lpszExisting, const CHARTYPE_* lpszNew);
	// t@CJ
	template<typename CHARTYPE_>
	HINTERNET	OpenFile(const CHARTYPE_* lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext=0);


	// fBNg쐬
	template<typename CHARTYPE_>
	BOOL		CreateDirectory(const CHARTYPE_* lpszDirectory);
	// fBNg폜
	template<typename CHARTYPE_>
	BOOL		RemoveDirectory(const CHARTYPE_* lpszDirectory);

	// JgfBNgύX
	template<typename CHARTYPE_>
	BOOL		SetCurrentDirectory(const CHARTYPE_* lpszDirectory);
	// JgfBNg擾
	template<typename CHARTYPE_>
	BOOL		GetCurrentDirectory(CHARTYPE_* lpszDirectory, LPDWORD lpdwSize);

	// R}hM
	BOOL		Command (BOOL fExpectResponse, DWORD dwFlags, LPCTSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);
	BOOL		CommandA(BOOL fExpectResponse, DWORD dwFlags, LPCSTR  lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);
	BOOL		CommandW(BOOL fExpectResponse, DWORD dwFlags, LPCWSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand);

	// t@CTCY擾
	DWORD		FtpGetFileSize(LPDWORD lpdwFileSizeHigh);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
