//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInetBase.h
 * @brief		HINTERNETx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXInetBase_H_
#define INCG_IRIS_WXInetBase_H_

//======================================================================
// include
#include "iris_object.h"
#include <wininet.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! HINTERNETx[XNX
class CInetBase : private INonCopyable<CInetBase>
{
protected:
	HINTERNET	m_hInternet;	//!< nh
public:
	// RXgN^
	CInetBase(void);
	CInetBase(HINTERNET hInternet);
	// fXgN^
	~CInetBase(void);

	HINTERNET	GetHandle(void)		{ return m_hInternet; }
	HINTERNET	operator () (void)	{ return GetHandle(); }
	operator HINTERNET (void)		{ return GetHandle(); }
public:
	// nh֘At
	BOOL		Attach(HINTERNET hInternet);
	// nh֘At̎s
	BOOL		TryAttach(HINTERNET hInternet);
	// nh̊֘At
	HINTERNET	Detach(void);

	// 
	BOOL		Close(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
