//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInternetFile.h
 * @brief		C^[lbgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXInternetFile_H_
#define INCG_IRIS_WXInternetFile_H_

//======================================================================
// include
#include "WXInetBase.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	C^[lbgt@CNX
 * @note	LHINTERNET擾֐(InternetOpenUrl, FtpOpenFile, GropherOpenFile, HttpOpenRequest)
*/
class CInternetFile : public CInetBase
{
public:
	// RXgN^
	CInternetFile(void);
	CInternetFile(HINTERNET hFile);
	// fXgN^
	~CInternetFile(void);

public:

	// t@Cobt@TCY̎擾
	BOOL		QueryDataAvailable(LPDWORD lpdwAvailable, DWORD dwFlags=0, DWORD_PTR dwContext=0);
	// Ǎ
	BOOL		Read(LPVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwReadSize);
	BOOL		ReadEx (LPINTERNET_BUFFERS  lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		ReadExA(LPINTERNET_BUFFERSA lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		ReadExW(LPINTERNET_BUFFERSW lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	// 
	BOOL		Write(LPCVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwWrittenSize);

	// t@CTCY擾
	DWORD		GetSize(void)	const;

	// t@C̈ʒu擾
	DWORD		Tell(void)	const;
	// t@C̈ʒuړ
	DWORD		Seek(LONG lDistanceToMove, DWORD dwMoveMethod, DWORD_PTR dwContext=0);
	// t@C̏I[Ɉړ
	DWORD		SetEndOfFile(void);

public:
	// 
	BOOL		LockRequest(HANDLE* lphLockRequestInfo);
	BOOL		UnlockRequest(HANDLE hLockRequestInfo);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
