//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXUrlCachEntryInfo.h
 * @brief		C^[lbgLbVnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXUrlCachEntryInfo_H_
#define INCG_IRIS_WXUrlCachEntryInfo_H_

//======================================================================
// include
#include "WXFindUrlCach.h"
#include "fnd/container/FndAllocator.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_, typename Allocator_>class CTUrlCachEntryInfo;

//======================================================================
// class
template<typename Allocator_ = fnd::CNewAllocator<u8> >class CUrlCachEntryInfoA : public CTUrlCachEntryInfo< CHAR, Allocator_> {};
template<typename Allocator_ = fnd::CNewAllocator<u8> >class CUrlCachEntryInfoW : public CTUrlCachEntryInfo<WCHAR, Allocator_> {};
template<typename Allocator_ = fnd::CNewAllocator<u8> >class CUrlCachEntryInfo  : public CTUrlCachEntryInfo<TCHAR, Allocator_> {};

//======================================================================
// class
//! C^[lbgLbVnhNX
template<typename CHARTYPE_, typename Allocator_ = fnd::CNewAllocator<u8> >
class CTUrlCachEntryInfo : public CFindUrlCach
{
	typedef CTUrlCachEntryInfo<CHARTYPE_>	_Myt;
protected:
	typedef CHARTYPE_			_Mychar;
	typedef CHARTYPE_			*_Mylpstr;
	typedef const CHARTYPE_		*_Mylpcstr;
	typedef typename CharSet<CHARTYPE_>::XINTERNET_CACHE_ENTRY_INFO		XINTERNET_CACHE_ENTRY_INFO;
	typedef typename CharSet<CHARTYPE_>::LPXINTERNET_CACHE_ENTRY_INFO	LPXINTERNET_CACHE_ENTRY_INFO;

	typedef typename Allocator_::template rebind<u8>::type allocator_type;
	typedef fnd::CAllocatorInstance<allocator_type>	Allocator;

protected:
	LPXINTERNET_CACHE_ENTRY_INFO	m_pEntryInfo;	//!< Gg[
	DWORD							m_BufferSize;	//!< obt@TCY

public:
	/**
	 * @name RXgN^
	 * @{
	*/
	CTUrlCachEntryInfo(void) : m_pEntryInfo(nullptr), m_BufferSize(0) {}
	CTUrlCachEntryInfo(HANDLE hCach) : CUrlCach(hCach), m_pEntryInfo(nullptr), m_BufferSize(0) {}
	/**
	 * @}
	*/
	/**
	 * @brief fXgN^
	*/
	virtual ~CTUrlCachEntryInfo(void)	{ Close(); }

public:

	/**
	 * @brief	
	*/
	virtual bool	Close(void)
	{
		ReleaseBuffer();
		return CFindUrlCach::Close();
	}

public:
	/**
	 * @brief	LbV폜
	*/
	BOOL	Delete(void)
	{
		return CFindUrlCach::Delete(GetUrlName());
	}

public:
	/**
	 * @brief	LbV
	*/
	BOOL	FindFirst(_Mylpcstr lpszUrlSearchPattern)
	{
		DWORD dwSize = m_BufferSize;
		if( !CFindUrlCach::FindFirst(lpszUrlSearchPattern, m_pEntryInfo, &dwSize) )
		{
			if( m_BufferSize < dwSize )
			{
				AllocBuffer(dwSize);
				return CFindUrlCach::FindFirst(lpszUrlSearchPattern, m_pEntryInfo, &dwSize);
			}
			return FALSE;
		}
		return TRUE;
	}

	/**
	 * @brief	
	*/
	BOOL	FindNext(void)
	{
		DWORD dwSize = m_BufferSize;
		if( !CFindUrlCach::FindNext(m_pEntryInfo, &dwSize) )
		{
			if( m_BufferSize < dwSize )
			{
				AllocBuffer(dwSize);
				return CFindUrlCach::FindNext(m_pEntryInfo, &dwSize);
			}
			return FALSE;
		}
		return TRUE;
	}

public:
	/**
	 * @brief	LbV
	*/
	BOOL	FindFirstEx(_Mylpcstr lpszUrlSearchPattern, DWORD dwFilter=URLCACHE_FIND_DEFAULT_FILTER, GROUPID GroupId=0)
	{
		DWORD dwSize = m_BufferSize;
		if( !CFindUrlCach::FindFirstEx(lpszUrlSearchPattern, 0, dwFilter, GroupId, nullptr, &dwSize) )
		{
			if( m_BufferSize < dwSize )
			{
				AllocBuffer(dwSize);
				return CFindUrlCach::FindFirstEx(lpszUrlSearchPattern, 0, dwFilter, GroupId, m_pEntryInfo, &dwSize);
			}
			return FALSE;
		}
		return TRUE;
	}

	/**
	 * @brief	
	*/
	BOOL	FindNextEx(void)
	{
		DWORD dwSize = m_BufferSize;
		if( !CFindUrlCach::FindNextEx(m_pEntryInfo, &dwSize) )
		{
			if( m_BufferSize < dwSize )
			{
				AllocBuffer(dwSize);
				return CFindUrlCach::FindNextEx(m_pEntryInfo, &dwSize);
			}
			return FALSE;
		}
		return TRUE;
	}

public:
	LPXINTERNET_CACHE_ENTRY_INFO		operator -> (void)			{ return GetEntryInfo(); }
	const LPXINTERNET_CACHE_ENTRY_INFO	operator -> (void)	const	{ return GetEntryInfo(); }

	LPXINTERNET_CACHE_ENTRY_INFO		GetEntryInfo(void)			{ return m_pEntryInfo; }
	const LPXINTERNET_CACHE_ENTRY_INFO	GetEntryInfo(void)	const	{ return m_pEntryInfo; }

public:
	/**
	 * @brief	URL ̎擾
	*/
	_Mylpcstr	GetUrlName(void)	const	{ return m_pEntryInfo->lpszSourceUrlName; }
	/**
	 * @brief	LbVt@C̃pX擾
	*/
	_Mylpcstr	GetFilePath(void)	const	{ return m_pEntryInfo->lpszLocalFileName; }

public:
	/**
	 * @brief	obt@TCY̎擾
	*/
	DWORD	GetBufferSize(void)	const	{ return m_BufferSize; }
	/**
	 * @brief	obt@̊m
	*/
	void	AllocBuffer(DWORD size)
	{
		ReleaseBuffer();
		m_pEntryInfo = static_cast<LPXINTERNET_CACHE_ENTRY_INFO>(Allocator::allocator().alloc(size));
		m_BufferSize = size;
	}
	/**
	 * @brief	obt@̉
	*/
	void	ReleaseBuffer(void)
	{
		if( m_pEntryInfo != nullptr )
		{
			Allocator::allocator().dealloc(m_pEntryInfo);
			m_pEntryInfo = nullptr;
			m_BufferSize = 0;
		}
	}

};

}	// end of namespace wx
}	// end of namespace iris

#endif
