//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXAccelerator.h
 * @brief		ANZ[^NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXAccelerator_H_
#define INCG_IRIS_WXAccelerator_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ANZ[^NX
*/
class CAccelerator : public IHandle
{
protected:
	HACCEL	m_hAccel;	//!< ANZ[^nh

public:
	// RXgN^
	CAccelerator(void);
	// RXgN^
	CAccelerator(HACCEL hAccel);

	// fXgN^
	virtual ~CAccelerator(void);

	HACCEL						GetAccel(void)		{ return m_hAccel; }	//!< nh̎擾
					operator	HACCEL (void)		{ return m_hAccel; }
	HACCEL			operator	() (void)			{ return m_hAccel; }
	CAccelerator&	operator	= (HACCEL hAccel)	{ Attach(hAccel); return *this; }

public:
	// ֘At
	BOOL	Attach(HACCEL hAccel);
	BOOL	TryAttach(HACCEL hAccel);
	// ֘At̉
	HACCEL	Detach(void);

public:
	// ANZ[^e[u̍쐬
	BOOL	Create (LPACCEL lpAccel, s32 nAccel);
	BOOL	CreateA(LPACCEL lpAccel, s32 nAccel);
	BOOL	CreateW(LPACCEL lpAccel, s32 nAccel);

	/// ANZ[^e[u̔j
	virtual	bool	Close(void)	{ return IRIS_TO_bool(Destroy()); }
	BOOL	Destroy(void);

	// ANZ[^e[ũ\[Xǂݍ
	template<typename CHARTYPE_>
	BOOL	Load(HINSTANCE hInstance, const CHARTYPE_* lpTableName);

public:
	// ANZ[^e[ũRs[
	int		CopyTable (LPACCEL lpAccelDst, int nCount);
	int		CopyTableA(LPACCEL lpAccelDst, int nCount);
	int		CopyTableW(LPACCEL lpAccelDst, int nCount);

	// ANZ[^e[u̐擾
	int		GetTableNum(void);

public:
	// j[ɃANZ[^̏ݒ
	BOOL	ApplyMenu(HMENU hMenu);

	static BOOL	ApplyMenu(HMENU hMenu, LPACCEL lpAccel, int nCount);

public:
	// ANZ[^̏
	BOOL	Translate (HWND hWnd, LPMSG lpMsg);
	BOOL	TranslateA(HWND hWnd, LPMSG lpMsg);
	BOOL	TranslateW(HWND hWnd, LPMSG lpMsg);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
