//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboard.h
 * @brief		Nbv{[hNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXClipboard_H_
#define INCG_IRIS_WXClipboard_H_

//======================================================================
// include
#include "fnd/types/FndSerializable.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! Nbv{[hNX
class CClipboard : public fnd::ISerializable, private INonCopyable<CClipboard>
{
private:
	HWND	m_hOwner;		//!< I[i[EBhE
	bool	m_isOpen;
public:
	// RXgN^
	CClipboard(void);
	explicit CClipboard(HWND hWndNewOwner);
	// fXgN^
	~CClipboard(void);

public:

	// J
	BOOL	Open(HWND hWndNewOwner);
	// 
	BOOL	Close(void);
	// JĂ邩
	bool	IsOpen(void)	const;

public:
	// f[^ݒ
	HANDLE	SetData(UINT uFormat, HANDLE hMem);
	// f[^擾
	HANDLE	GetData(UINT uFormat)	const;
	// f[^ɂ
	BOOL	Empty(void);
	// f[^̗L
	BOOL	IsFormatAvailable(UINT uFormat)	const;

public:
	// I[i[EBhEnh擾
	HWND	GetOwner(void)	const;
	// OpenĂEBhEnh擾
	HWND	GetOpenWindow(void)	const;
	// Nbv{[h̃V[PXԍ擾
	DWORD	GetSequenceNumber(void)	const;
	// tH[}bg̎擾
	int		CountFormats(void)	const;
	// tH[}bg̗
	UINT	EnumFormats(UINT uFormat);
	// Xg̒ŏɗpłNbv{[htH[}bg̎擾
	int		GetPriorityFormat(UINT* paPriorityList, int nFormats)	const;
	// Nbv{[h̐VtH[}bg Windows VXeɓo^
	UINT	RegisterFormat (LPCTSTR lpszFormat);
	UINT	RegisterFormatA(LPCSTR  lpszFormat);
	UINT	RegisterFormatW(LPCWSTR lpszFormat);
	// o^ς݃tH[}bg擾
	int		GetFormatName (UINT uFormat, LPTSTR lpszFormatName, int cchMaxCount)	const;
	int		GetFormatNameA(UINT uFormat, LPSTR  lpszFormatName, int cchMaxCount)	const;
	int		GetFormatNameW(UINT uFormat, LPWSTR lpszFormatName, int cchMaxCount)	const;

public:
	// Nbv{[hr[Ã`FCɂŏ̃EBhE擾
	HWND	GetViewer(void)	const;

public:
	// VACY
	virtual u32		Serialize(void* buf, u32 size)		{ return Serialize(buf, size, CF_TEXT); }
			u32		Serialize(void* buf, u32 size, UINT uFormat);
	// fVACY
	virtual u32		Deserialize(void* buf, u32 size)	{ return Deserialize(buf, size, CF_TEXT); }
			u32		Deserialize(void* buf, u32 size, UINT uFormat);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
