//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindFile.h
 * @brief		t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindFile_H_
#define INCG_IRIS_WXFindFile_H_

//======================================================================
// include
#include "ml/iml_type_select.hpp"
#include "c++0x/cpp0x_type_traits.hpp"
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTFindFile;

//======================================================================
// typedef
typedef CTFindFile<CHAR>	CFindFileA;
typedef CTFindFile<WCHAR>	CFindFileW;
typedef CTFindFile<TCHAR>	CFindFile;

//======================================================================
// class
//! t@CNX
template<typename CHARTYPE_>
class CTFindFile : public CHandle
{
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;
public:
	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), WIN32_FIND_DATAW, WIN32_FIND_DATAA >::type	FIND_DATA;
protected:
	FIND_DATA	m_FindData;
public:
	// RXgN^
	CTFindFile(void);
	// fXgN^
	~CTFindFile(void);

public:
	// 擪
	BOOL	FindFirst(_Mylpcstr lpFileName);
#if	(_WIN32_WINNT >= 0x0400)
	BOOL	FindFirstEx(_Mylpcstr lpFileName, FINDEX_INFO_LEVELS fInfoLevelId, FINDEX_SEARCH_OPS fSearchOp
					, LPVOID lpSearchFilter, DWORD dwAdditionalFlags);
#endif
	// 
	BOOL	FindNext(void);
	// 
	virtual	bool	Close(void);

public:
	FIND_DATA*			operator -> (void)			{ return &m_FindData; }
	const FIND_DATA*	operator -> (void)	const	{ return &m_FindData; }

	FIND_DATA&			GetFindData(void)			{ return m_FindData; }
	const FIND_DATA&	GetFindData(void)	const	{ return m_FindData; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
