//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMAviStream.cpp
 * @brief		AviStream t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMAviStream_CPP_

//======================================================================
// include
#include "WXMMAviStream.h"
#include "../os/modules/WXMAvifil.h"

namespace iris {
namespace wx
{


/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMAviStream::CMMAviStream(void)
: m_pStream(nullptr)
{
}

/**********************************************************************//**
 *
 * Rs[RXgN^
 *
*//***********************************************************************/
CMMAviStream::CMMAviStream(const CMMAviStream& rhs)
: m_pStream(nullptr)
{
	Clone(rhs);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMAviStream::~CMMAviStream(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= t@C
 * @param [in]	fccType		= Xg[^Cv
 * @param [in]	lParam		=
 * @param [in]	uMode		= t@CI[v[h
 * @param [in]	lpHandler	=
 * @return	
*//***********************************************************************/
template<>
bool CMMAviStream::Open<CHAR>(LPCSTR	filename, DWORD fccType, LONG lParam, UINT uMode, LPCLSID lpHandler)
{
	if( FAILED( CAvifil::AVIStreamOpenFromFileA(&m_pStream, filename, fccType, lParam, uMode, lpHandler) ) ) return false;
	return IsValid();
}
template<>
bool CMMAviStream::Open<WCHAR>(LPCWSTR	filename, DWORD fccType, LONG lParam, UINT uMode, LPCLSID lpHandler)
{
	if( FAILED( CAvifil::AVIStreamOpenFromFileW(&m_pStream, filename, fccType, lParam, uMode, lpHandler) ) ) return false;
	return IsValid();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fccType		= Xg[^Cv
 * @param [in]	lParam		=
 * @return	
*//***********************************************************************/
bool CMMAviStream::Open(PAVIFILE pfile, DWORD fccType, LONG lParam)
{
	if( FAILED( CAvifil::AVIFileGetStream(pfile, &m_pStream, fccType, lParam) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CMMAviStream::IsValid(void) const
{
	if( m_pStream == nullptr ) return false;
	return true;
}

/**********************************************************************//**
 *
 * t@C
 *
*//***********************************************************************/
void CMMAviStream::Close(void)
{
	if( m_pStream != nullptr )
	{
		CAvifil::AVIStreamRelease(m_pStream);
		m_pStream = nullptr;
	}
}

/**********************************************************************//**
 *
 * Nbv{[h쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	cfFormat	= Nbv{[h̃tH[}bg
 * @param [in]	hGlobal		= Nbv{[hnh
 * @return	
*//***********************************************************************/
bool CMMAviStream::Create(UINT cfFormat, HANDLE hGlobal)
{
	Close();
	if( FAILED( CAvifil::AVIMakeStreamFromClipboard(cfFormat, hGlobal, &m_pStream) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * fB[vRs[
 *
 ----------------------------------------------------------------------
 * @param [in]	rhs		= Rs[
 * @return	
*//***********************************************************************/
bool CMMAviStream::Copy(const CMMAviStream& rhs, LPAVICOMPRESSOPTIONS lpOstions, LPCLSID lpHandler)
{
	Close();
	if( FAILED( CAvifil::AVIMakeCompressedStream(&m_pStream, rhs.m_pStream, lpOstions, lpHandler) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * V[Rs[
 *
 ----------------------------------------------------------------------
 * @param [in]	rhs		= Rs[
*//***********************************************************************/
void CMMAviStream::Clone(const CMMAviStream& rhs)
{
	Close();
	if( rhs.m_pStream == nullptr ) return;
	m_pStream = rhs.m_pStream;
	CAvifil::AVIStreamAddRef(m_pStream);
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpInfo		= o
 * @param [in]	lSize		= o̓obt@TCY
 * @return 
*//***********************************************************************/
template<>
bool CMMAviStream::GetInfo(LPAVISTREAMINFOA lpInfo, s32 lSize) const
{
	if( lpInfo == nullptr ) return false;
	if( FAILED( CAvifil::AVIStreamInfoA(m_pStream, lpInfo, lSize) ) ) return false;
	return true;
}
template<>
bool CMMAviStream::GetInfo(LPAVISTREAMINFOW lpInfo, s32 lSize) const
{
	if( lpInfo == nullptr ) return false;
	if( FAILED( CAvifil::AVIStreamInfoW(m_pStream, lpInfo, lSize) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * f[^̓ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	lStart			= ǂݎJnʒu
 * @param [in]	lSamples		= ǂݎTv
 * @param [out]	lpBuffer		= o̓obt@
 * @param [in]	lSize			= o̓obt@TCY
 * @param [out]	lpReadBytes		= ǂݎoCg
 * @param [out]	lpReadSamples	= ǂݎTv
 * @return	
*//***********************************************************************/
bool CMMAviStream::Read(s32 lStart, s32 lSamples, LPVOID lpBuffer, s32 lSize, s32* lpReadBytes, s32* lpReadSamples) const
{
	if( !IsValid() ) return false;
	if( FAILED( CAvifil::AVIStreamRead(m_pStream, lStart, lSamples, lpBuffer, lSize, lpReadBytes, lpReadSamples) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * tH[}bg̓ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	lStart		= ǂݎJnʒu
 * @param [out]	lpFormat	= o̓obt@
 * @param [in]	lpSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
bool CMMAviStream::ReadFormat(s32 lStart, LPVOID lpFormat, s32* lpSize) const
{
	if( !IsValid() ) return false;
	if( FAILED( CAvifil::AVIStreamReadFormat(m_pStream, lStart, lpFormat, lpSize) ) ) return false;
	return true;
}

/**********************************************************************//**
 *
 * Xg[̐擪Tv̔ԍ
 *
 ----------------------------------------------------------------------
 * @return	Xg[̐擪Tv̔ԍ
*//***********************************************************************/
s32 CMMAviStream::GetStartSample(void) const
{
	if( !IsValid() ) return -1;
	return CAvifil::AVIStreamStart(m_pStream);
}

/**********************************************************************//**
 *
 * ~bԂTvԍɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= 
 * @return	Tv̔ԍ
*//***********************************************************************/
s32 CMMAviStream::TimeToSample(s32 time) const
{
	if( !IsValid() ) return -1;
	return CAvifil::AVIStreamTimeToSample(m_pStream, time);
}

/**********************************************************************//**
 *
 * Tvԍ~bԂɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	sample	= 
 * @return	Tv̔ԍ
*//***********************************************************************/
s32 CMMAviStream::SampleToTime(s32 sample) const
{
	if( !IsValid() ) return -1;
	return CAvifil::AVIStreamSampleToTime(m_pStream, sample);
}

/**********************************************************************//**
 *
 * Xg[̒擾
 *
 ----------------------------------------------------------------------
 * @return	Xg[̒
*//***********************************************************************/
s32 CMMAviStream::GetLength(void) const
{
	if( !IsValid() ) return -1;
	return CAvifil::AVIStreamLength(m_pStream);
}


}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_tchar.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMMAviStreamTest, Info)
{
	CMMAviStream stream;

	TCHAR path[MAX_PATH];
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "Jt@C͂ĂB" << std::endl;
	std::tcin >> path;
#endif

	if( !stream.Open(path, CMMAviStream::ALL, 0, OF_READ) )
	{
		_tprintf(path);
		_tprintf(IRIS_TEXT("\n"));
		std::cout << "t@CI[vɎs܂B" << std::endl;
		return;
	}

	AVISTREAMINFO asi;
	if( !stream.GetInfo(&asi, sizeof(asi)) ) return;

    _tprintf(IRIS_TEXT("dwCaps                = 0x%x\n")  , asi.dwCaps );
    _tprintf(IRIS_TEXT("dwEditCount           = %d\n")    , asi.dwEditCount );
    _tprintf(IRIS_TEXT("dwFlags               = 0x%x\n")  , asi.dwFlags );
	_tprintf(IRIS_TEXT("dwFormatChangeCount   = %d\n")    , asi.dwFormatChangeCount );
	_tprintf(IRIS_TEXT("dwInitialFrames       = 0x%x\n")  , asi.dwInitialFrames );
    _tprintf(IRIS_TEXT("dwLength              = 0x%x\n")  , asi.dwLength );
	_tprintf(IRIS_TEXT("dwQuality             = 0x%x\n")  , asi.dwQuality );
    _tprintf(IRIS_TEXT("dwRate                = 0x%x\n")  , asi.dwRate );
	_tprintf(IRIS_TEXT("dwSampleSize          = %d\n")    , asi.dwSampleSize );
    _tprintf(IRIS_TEXT("dwScale               = 0x%x\n")  , asi.dwScale );
    _tprintf(IRIS_TEXT("dwSuggestedBufferSize = 0x%x\n")  , asi.dwSuggestedBufferSize );
	_tprintf(IRIS_TEXT("fccHandler            = 0x%x\n")  , asi.fccHandler );
	_tprintf(IRIS_TEXT("fccType               = 0x%x\n")  , asi.fccType );
	_tprintf(IRIS_TEXT("rcFrame.left          = %d\n")    , asi.rcFrame.left );
	_tprintf(IRIS_TEXT("rcFrame.top           = %d\n")    , asi.rcFrame.top );
	_tprintf(IRIS_TEXT("rcFrame.right         = %d\n")    , asi.rcFrame.right );
	_tprintf(IRIS_TEXT("rcFrame.bottom        = %d\n")    , asi.rcFrame.bottom );
	_tprintf(IRIS_TEXT("szName                = %s\n")    , asi.szName );
	_tprintf(IRIS_TEXT("wLanguage             = 0x%x\n")  , asi.wLanguage );
	_tprintf(IRIS_TEXT("wPriority             = 0x%x\n")  , asi.wPriority );

}

#endif
