//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMPfmTimer.h
 * @brief		^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMMPfmTimer_H_
#define INCG_IRIS_WXMMPfmTimer_H_

//======================================================================
// include
#include "fnd/system/FndTimer.h"
#include "WXMMTimePeriod.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ԂǗNX
 * @note	QueryPerformanceCounter𗘗p^C}[NX
 *			QueryPerformanceCountergȂꍇ́AtimeGetTimeg
*/
class CMMPfmTimer : public fnd::ITimer
{
protected:
	CMMTimePeriod	m_Period;		//!< \ݒ
	u64				m_ToMillisec;	//!< ~bPʕϊ萔
	LARGE_INTEGER	m_Freq;			//!< g

public:
	// RXgN^
	CMMPfmTimer(void);
	// fXgN^
	~CMMPfmTimer(void);

protected:
	// ݂̃^C}[JEg擾
	virtual u64		GetNowTime(void)	const;

public:
	// oߎԂ̎擾
	// out : oߎ
	u64		GetElapsedMilliSecond(void)	const;
	// AvP[VԂ̎擾
	// out : NĂ̎
	u64		GetStockMilliSecond(void)	const;

public:
	// GetSecond
	u64		GetElapsedMilliSecondRef(void)	const;
	// Sync(XVԂASPFɂȂ悤Sync)
	bool	Sync(bool sleep);
	// Sync̍XVԂ̎擾
	float	GetSyncElapsedSecond(void)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif
