//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMSound.cpp
 * @brief		MultiMediaSoundNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMMSound_CPP_

//======================================================================
// include
#include "WXMMSound.h"
#include <mmsystem.h>

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	!defined(IRIS_WIN32_WCE)
#pragma comment( lib, "winmm.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * Đ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszSound	= TEhobt@
 * @param [in]	hModule		= W[nh
 * @param [in]	fuSound		= tO
 * @return	
*//***********************************************************************/
template<>
BOOL CMMSound::Play<CHAR>(LPCSTR  pszSound, HMODULE hModule, UINT fuSound)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::PlaySoundA(pszSound, hModule, fuSound);
#else
	return FALSE;
#endif
}
/// @ref Play
template<>
BOOL CMMSound::Play<WCHAR>(LPCWSTR pszSound, HMODULE hModule, UINT fuSound)
{
	return ::PlaySoundW(pszSound, hModule, fuSound);
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMMSound::Stop(void)
{
	return ::PlaySound(nullptr, nullptr, 0);
}

}	// end of namespace wx
}	// end of namespace iris
