//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEvent.h
 * @brief		CxgnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXEvent_H_
#define INCG_IRIS_WXEvent_H_

//======================================================================
// include
#include "WXSyncObject.h"

namespace iris {
namespace wx
{

//======================================================================
// define
#ifndef CREATE_EVENT_MANUAL_RESET
#  define	CREATE_EVENT_MANUAL_RESET	0x00000001
#endif
#ifndef CREATE_EVENT_INITIAL_SET
#  define	CREATE_EVENT_INITIAL_SET	0x00000002
#endif

//======================================================================
// class
/// CxgNX
class CEvent : public ISyncObject
{
public:
	// RXgN^
	CEvent(void);
	// fXgN^
	~CEvent(void);

public:
	// 쐬
	BOOL	Create (LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCTSTR lpName=nullptr);
	BOOL	CreateA(LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCSTR  lpName=nullptr);
	BOOL	CreateW(LPSECURITY_ATTRIBUTES lpSecurityAttribute, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName=nullptr);

	// 쐬
	BOOL	CreateEx (LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCTSTR lpName, DWORD dwFlags, DWORD dwDesiredAccess);
	BOOL	CreateExA(LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCSTR  lpName, DWORD dwFlags, DWORD dwDesiredAccess);
	BOOL	CreateExW(LPSECURITY_ATTRIBUTES lpSecurityAttribute, LPCWSTR lpName, DWORD dwFlags, DWORD dwDesiredAccess);

	// ̖OtCxgJ
	BOOL	Open (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCTSTR lpName);
	BOOL	OpenA(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR  lpName);
	BOOL	OpenW(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);

public:
	// Cxg̃VOiԂݒ
	BOOL	Signal(BOOL bSignal);

public:
	// CxgVOiԂɂ
	BOOL	SetSignal(void);
	// CxgVOiԂɂ
	BOOL	ResetSignal(void);
	// VOiԂɐݒ肵Aҋ@Xbh݂ꍇ͓K؂Ȑ̃XbhǍŔVOiԂɖ߂
	BOOL	Pulse(void);

public:
	// AbN
	BOOL	Unlock(LONG lCount=0, LONG *pPrevCount = nullptr);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
