//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXModule.cpp
 * @brief		W[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXModule_CPP_

//======================================================================
// include
#include "WXModule.h"

#ifdef _IRIS_DEBUG
#include "../base/WXError.h"
#include <tchar.h>
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CModule::CModule(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CModule::~CModule(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in] lpModuleName	= W[t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CModule::Load<CHAR>(LPCSTR  lpModuleName)
{
#if !defined(IRIS_WIN32_WCE)
	HMODULE hModule = LoadLibraryA(lpModuleName);
	if( hModule == nullptr )
	{
#ifdef _IRIS_DEBUG
		CScopedLastError sle;
		CLastError le(sle);
		_tprintf(le.ToString());
#endif
		return FALSE;
	}
	if( !Attach(reinterpret_cast<HANDLE>(hModule)) )
	{
		FreeLibrary(hModule);
		return FALSE;
	}
	return TRUE;
#else
	return FALSE;
#endif
}
/// CModule::Load Q
template<>
BOOL CModule::Load<WCHAR>(LPCWSTR lpModuleName)
{
	HMODULE hModule = LoadLibraryW(lpModuleName);
	if( hModule == nullptr )
	{
#ifdef _IRIS_DEBUG
		CScopedLastError sle;
		CLastError le(sle);
		_tprintf(le.ToString());
#endif
		return FALSE;
	}
	if( !Attach(reinterpret_cast<HANDLE>(hModule)) )
	{
		FreeLibrary(hModule);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CModule::Release(void)
{
	return FreeLibrary(reinterpret_cast<HMODULE>(Detach()));
}

/**********************************************************************//**
 *
 * J
 *
 * @note	QƃJE^CNgȂ̂ŁA
 *			ReleaseƂ͒
 *
 ----------------------------------------------------------------------
 * @param [in] lpModuleName	= W[
 * @return	
*//***********************************************************************/
template<>
BOOL CModule::Open<CHAR>(LPCSTR  lpModuleName)
{
#if !defined(IRIS_WIN32_WCE)
	HMODULE hModule = GetModuleHandleA(lpModuleName);
	if( hModule == nullptr ) return FALSE;
	return Attach(reinterpret_cast<HANDLE>(hModule));
#else
	return FALSE;
#endif
}
/// CModule::Open Q
template<>
BOOL CModule::Open<WCHAR>(LPCWSTR lpModuleName)
{
	HMODULE hModule = GetModuleHandleW(lpModuleName);
	if( hModule == nullptr ) return FALSE;
	return Attach(reinterpret_cast<HANDLE>(hModule));
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
bool CModule::Close(void)
{
	Detach();
	return true;
}

/**********************************************************************//**
 *
 * AhX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpProcName	= ֐
 * @return	AhX
*//***********************************************************************/
template<>
PROC CModule::GetProcAddress<CHAR>(LPCSTR lpProcName) const
{
#if	!defined(IRIS_WIN32_WCE)
	return ::GetProcAddress(static_cast<HMODULE>(m_hObject), lpProcName);
#else
	return ::GetProcAddressA(static_cast<HMODULE>(m_hObject), lpProcName);
#endif
}
template<>
PROC CModule::GetProcAddress<WCHAR>(LPCWSTR lpProcName) const
{
#if	!defined(IRIS_WIN32_WCE)
	CHAR path[MAX_PATH];
	size_t ret;
	wcstombs_s(&ret, path, MAX_PATH, lpProcName, _TRUNCATE);
	return ::GetProcAddress(static_cast<HMODULE>(m_hObject), path);
#else
	return ::GetProcAddressW(static_cast<HMODULE>(m_hObject), lpProcName);
#endif
}

/**********************************************************************//**
 *
 * W[t@CpX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpszFileName	= o̓obt@
 * @param [in]	dwLength		= o̓obt@TCY
 * @return	񂾃TCY
*//***********************************************************************/
template<>
DWORD CModule::GetFileName<CHAR>(LPSTR  lpszFileName, DWORD dwLength) const
{
#if !defined(IRIS_WIN32_WCE)
	return ::GetModuleFileNameA(static_cast<HMODULE>(m_hObject), lpszFileName, dwLength);
#else
	return 0;
#endif
}
template<>
DWORD CModule::GetFileName<WCHAR>(LPWSTR lpszFileName, DWORD dwLength) const
{
	return ::GetModuleFileNameW(static_cast<HMODULE>(m_hObject), lpszFileName, dwLength);
}

}	// end of namespace wx
}	// end of namespace iris
