//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXModule.h
 * @brief		W[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXModule_H_
#define INCG_IRIS_WXModule_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// W[NX
class CModule : public CHandle
{
public:
	// RXgN^
	CModule(void);
	// fXgN^
	virtual ~CModule(void);

#ifdef STRICT
	CModule(HMODULE hModule) : CHandle(reinterpret_cast<HANDLE>(hModule)) {}
				operator	HMODULE (void)		{ return static_cast<HMODULE>(GetHandle()); }
	CModule&	operator	= (HMODULE hObj)	{ Attach(static_cast<HANDLE>(hObj)); return *this; }
#endif

public:
	// ǂݍ
	template<typename CHARTYPE_>
	BOOL	Load(const CHARTYPE_* lpModuleName);
	// 
	BOOL	Release(void);

	// J
	template<typename CHARTYPE_>
	BOOL	Open(const CHARTYPE_* lpModuleName);
	// 
	bool	Close(void);
public:
	// AhX擾
	template<typename CHARTYPE_>
	PROC	GetProcAddress(const CHARTYPE_ * lpProcName) const;

public:
	template<typename CHARTYPE_>
	DWORD	GetFileName(CHARTYPE_* lpszFileName, DWORD dwLength) const;
	template<typename CHARTYPE_, size_t SIZE_>
	DWORD	GetFileName(CHARTYPE_ (&lpszFileName)[SIZE_]) const	{ return GetFileName(lpszFileName, SIZE_); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
