//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMutex.cpp
 * @brief		mutexNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMutex_CPP_

//======================================================================
// include
#include "WXMutex.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMutex::CMutex(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMutex::~CMutex(void)
{
	Unlock();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in] bInitiallyOwn	= ŏ̏L
 * @param [in] lpszName			= mutex
 * @param [in] psaAttribute		= ZLeBLqq
 * @return	
*//***********************************************************************/
template<>
BOOL CMutex::Init<CHAR>(BOOL bInitiallyOwn, LPCSTR  lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
#if !defined(IRIS_WIN32_WCE)
	HANDLE hMutex = ::CreateMutexA(psaAttribute, bInitiallyOwn, lpszName);
	if( hMutex == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hMutex);
#else
	return FALSE;
#endif
}
/// iris::wx::CMutex::Init Q
template<>
BOOL CMutex::Init<WCHAR>(BOOL bInitiallyOwn, LPCWSTR lpszName, SECURITY_ATTRIBUTES* psaAttribute)
{
	HANDLE hMutex = ::CreateMutexW(psaAttribute, bInitiallyOwn, lpszName);
	if( hMutex == INVALID_HANDLE_VALUE ) return FALSE;
	return TryAttach(hMutex);
}

/**********************************************************************//**
 *
 * ̖OtmutexJ
 *
 -----------------------------------------------------------------------
 * @param [in] dwDesiredAccess	= ANZX
 * @param [in] bInheritHandle	= pIvV
 * @param [in] lpName			= mutex
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
template<>
BOOL CMutex::Open<CHAR>(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR  lpName)
{
	HANDLE hMutex = ::OpenMutexA(dwDesiredAccess, bInheritHandle, lpName);
	if( hMutex == nullptr ) return FALSE;
	return TryAttach(hMutex);
}
/// CMutex::Open Q
template<>
BOOL CMutex::Open<WCHAR>(DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
	HANDLE hMutex = ::OpenMutexW(dwDesiredAccess, bInheritHandle, lpName);
	if( hMutex == nullptr ) return FALSE;
	return TryAttach(hMutex);
}
#endif

/**********************************************************************//**
 *
 * bN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CMutex::Unlock(LONG lCount, LONG *pPrevCount)
{
	IRIS_UNUSED_VARIABLE(lCount);
	IRIS_UNUSED_VARIABLE(pPrevCount);
    return ::ReleaseMutex(m_hObject);
}


}	// end of namespace wx
}	// end of namespace iris
