//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOS.cpp
 * @brief		Windows֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXOS_CPP_

//======================================================================
// include
#include "WXOS.h"
#include <stdio.h>
#include <tchar.h>
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * Windows̏I
 *
 -----------------------------------------------------------------------
 * @param [in]	uFlags		= IIvV(EWX_***)
 * @param [in]	dwReason	= IR
 * @return 
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CWindowsOS::ExitWindowsEx(UINT uFlags, DWORD dwReason)
{
    HANDLE hToken;
    TOKEN_PRIVILEGES tkp;
	// ̃vZX Token 擾܂
	if( !OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken))
	{
		puts("failed OpenProcessToken.");
		return FALSE;
	}

	// Vbg_Ep LUID 擾܂
	if( !LookupPrivilegeValue(nullptr, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid) )
	{
		puts("failed LookupPrivilegeValue.");
		return FALSE;
	}

	tkp.PrivilegeCount = 1;      // one privilege to set
	tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	// ̃vZXp Vbg_E擾܂
	if( AdjustTokenPrivileges(hToken, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES)nullptr, 0) )
	{
		puts("failed AdjustTokenPrivileges.");
		return FALSE;
	}
	if( !::ExitWindowsEx(uFlags, dwReason) )
	{
		puts("failed ExitWindowsEx.");
		return FALSE;
	}
	return TRUE;
}
#endif

/**********************************************************************//**
 *
 * j^[̓d𑀍삷
 *
 -----------------------------------------------------------------------
 * @param [in]	bPower	= on/off
 * @return 
*//***********************************************************************/
BOOL CWindowsOS::SetMonitorPower(BOOL bPower)
{
#if	!defined(IRIS_WIN32_WCE)
	return ::PostMessage(HWND_BROADCAST, WM_SYSCOMMAND, SC_MONITORPOWER, bPower ? -1 : 2);
#else
	return FALSE;
#endif
}


}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "environment/WXPCName.h"
#include "../base/WXError.h"
#include <stdio.h>
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXOSUnitTest, Func)
{
	CPCName<> pcname;
	std::cout << pcname << std::endl;
}

IRIS_UNITTEST(CWXOSUnitTest, LastError)
{
	CScopedLastError sle;
	CLastError le(sle);
	std::cout << le.ToString() << std::endl;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
