//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPfmTimer.cpp
 * @brief		Performance^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXPfmTimer_CPP_

//======================================================================
// include
#include "WXPfmTimer.h"
#include "fnd/system/FndFps.h"
#include <stdio.h>

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPfmTimer::CPfmTimer(void)
{
	m_Freq.QuadPart = 1;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPfmTimer::~CPfmTimer(void)
{
}

/**********************************************************************//**
 *
 * ݂̎擾
 *
 -----------------------------------------------------------------------
 * @return ݂̎
*//***********************************************************************/
u64 CPfmTimer::GetNowTime(void)	const
{
	if( !IsActive() ) return m_StopTime;
	LARGE_INTEGER cnt;
	QueryPerformanceCounter(&cnt);
	return cnt.QuadPart;
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CPfmTimer::Reset(void)
{
	if( !QueryPerformanceFrequency(&m_Freq) )
	{
		puts("failed QueryPerformanceFrequency.\n");
		return;
	}
	ITimer::Reset();
}

/**********************************************************************//**
 *
 * oߎԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return oߎ(~b)
*//***********************************************************************/
u64 CPfmTimer::GetElapsedMilliSecond(void)	const
{
	u64 time = GetNowTime();
	u64 elapsedtime = ( (time - m_LastTime)*1000 / m_Freq.QuadPart );
	m_LastTime = time;
	return elapsedtime;
}

/**********************************************************************//**
 *
 * AvP[VԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return NĂ̎
*//***********************************************************************/
u64 CPfmTimer::GetStockMilliSecond(void)	const
{
	u64 time = GetNowTime();
	u64 elapsedtime = ( (time - m_BaseTime)*1000 / m_Freq.QuadPart );
	return elapsedtime;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iXVj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
u64 CPfmTimer::GetElapsedMilliSecondRef(void)	const
{
	u64 time = GetNowTime();
	u64 elapsedtime = ( (time - m_LastTime)*1000 / m_Freq.QuadPart );
	return elapsedtime;
}

/**********************************************************************//**
 *
 * Sync
 *
 ----------------------------------------------------------------------
 * @return	syncꍇ́Atrue
*//***********************************************************************/
bool CPfmTimer::Sync(bool sleep)
{
	while(1)
	{
		u64 mspf = (u64)fnd::MSPF();
		u64 time = GetElapsedMilliSecondRef();
		if( time > mspf )
		{
			m_LastTime += mspf;
			return true;
		}
		if( !sleep ) break;

		Sleep((DWORD)(mspf-time));
	}
	return false;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iSyncj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
float CPfmTimer::GetSyncElapsedSecond(void)	const
{
	return fnd::SPF();
}

/**********************************************************************//**
 *
 * p\ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
bool CPfmTimer::IsSupported(void)
{
	LARGE_INTEGER cnt;
	return (QueryPerformanceCounter(&cnt) != 0 );
}

}	// end of namespace wx
}	// end of namespace iris
