//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStartupInfo.cpp
 * @brief		WXStartupInfo t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStartupInfo_CPP_

//======================================================================
// include
#include "WXStartupInfo.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename SI>
CTStartupInfo<SI>::CTStartupInfo(void)
{
	ZeroMemory(&m_si, sizeof(m_si));
	m_si.cb = sizeof(m_si);
}

/**********************************************************************//**
 *
 * g̃vZX擾
 *
*//***********************************************************************/
template<>
void CTStartupInfo<STARTUPINFOA>::GetSelf(void)
{
	GetStartupInfoA(&m_si);
}
template<>
void CTStartupInfo<STARTUPINFOW>::GetSelf(void)
{
	GetStartupInfoW(&m_si);
}

/**********************************************************************//**
 *
 * \ݒ
 *
*//***********************************************************************/
template<typename SI>
void CTStartupInfo<SI>::Hide(void)
{
	m_si.dwFlags |= STARTF_USESHOWWINDOW;
	m_si.wShowWindow = SW_HIDE;
}

/**********************************************************************//**
 *
 * \ݒ
 *
*//***********************************************************************/
template<typename SI>
void CTStartupInfo<SI>::Show(void)
{
	m_si.dwFlags |= STARTF_USESHOWWINDOW;
	m_si.wShowWindow = SW_SHOW;
}

/**********************************************************************//**
 *
 * Wo͂̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hChildStdOut	= Wo
 * @param [in]	hChildStdIn		= W
 * @param [in]	hChildStdErr	= WG[
*//***********************************************************************/
template<typename SI>
void CTStartupInfo<SI>::UseStdHandles(HANDLE hChildStdOut, HANDLE hChildStdIn, HANDLE hChildStdErr)
{
	m_si.dwFlags |= STARTF_USESTDHANDLES;
	m_si.hStdOutput = hChildStdOut;
	m_si.hStdInput  = hChildStdIn;
	m_si.hStdError  = hChildStdErr;
}

/**********************************************************************//**
 *
 * Wo͂̐ݒ
 *
*//***********************************************************************/
template<typename SI>
void CTStartupInfo<SI>::UseStdHandles(void)
{
	UseStdHandles( GetStdHandle(STD_OUTPUT_HANDLE)
		, GetStdHandle(STD_INPUT_HANDLE)
		, GetStdHandle(STD_ERROR_HANDLE) );
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
template<typename SI>
void CTStartupInfo<SI>::Restore(void)
{
	if( m_si.dwFlags & STARTF_USESTDHANDLES )
	{
		// ꂿ
		if( GetStdHandle(STD_OUTPUT_HANDLE) == nullptr )
			freopen_s(nullptr, "CON", "w", stdout);
		if( GetStdHandle(STD_INPUT_HANDLE) == nullptr )
			freopen_s(nullptr , "CON", "r", stdin);
		if( GetStdHandle(STD_ERROR_HANDLE) == nullptr )
			freopen_s(nullptr, "CON", "w", stderr);
	}
}

template class CTStartupInfo<STARTUPINFOA>;
template class CTStartupInfo<STARTUPINFOW>;

}	// end of namespace wx
}	// end of namespace iris
