//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOSVersion.cpp
 * @brief		OS Version t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXOSVersion_CPP_

//======================================================================
// include
#include "WXOSVersion.h"
#include "WXSystemInfo.h"
#include <stdio.h>
#include <tchar.h>
#include "iris_xchar.hpp"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<>
CTOSVersionInfo<CHAR>::CTOSVersionInfo(void)
{
#if	!defined(IRIS_WIN32_WCE)
	m_Osviex.dwOSVersionInfoSize = sizeof(_Myosvi);
	BOOL bOSVersionInfoEx = GetVersionExA(pointer_cast<LPOSVI>(&m_Osviex));
	if( !bOSVersionInfoEx )
	{
		// Windows NT 4.0 SP5 ȑO Windows 9x
		m_Osviex.dwOSVersionInfoSize = sizeof(OSVI);
		if( !GetVersionExA(reinterpret_cast<LPOSVI>(&m_Osviex)) )
		{
			m_Osviex.dwOSVersionInfoSize = 0;
		}
	}
#else
#endif
}
template<>
CTOSVersionInfo<WCHAR>::CTOSVersionInfo(void)
{
	m_Osviex.dwOSVersionInfoSize = sizeof(_Myosvi);
	BOOL bOSVersionInfoEx = GetVersionExW(pointer_cast<LPOSVI>(&m_Osviex));
	if( !bOSVersionInfoEx )
	{
		// Windows NT 4.0 SP5 ȑO Windows 9x
		m_Osviex.dwOSVersionInfoSize = sizeof(OSVI);
		if( !GetVersionExW(pointer_cast<LPOSVI>(&m_Osviex)) )
		{
			m_Osviex.dwOSVersionInfoSize = 0;
		}
	}
}

/**********************************************************************//**
 *
 * Windows NT n
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTOSVersionInfo<CHARTYPE_>::IsWindowsNT(void) const
{
	IRIS_ASSERT( IsValid() );
	return ( m_Osviex.dwPlatformId == VER_PLATFORM_WIN32_NT && m_Osviex.dwMajorVersion >= 3 );
}

/**********************************************************************//**
 *
 * WindowsOSo[W̕o
 *
 -----------------------------------------------------------------------
 * @param [in]	lpString	= o̓obt@
 * @param [in]	dwLength	= o̓obt@TCY
 * @return 
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTOSVersionInfo<CHARTYPE_>::GetString(_Mylpstr lpString, DWORD dwLength) const
{
	BOOL bOSVersionInfoEx = IsEx();
	CSystemInfo csi;

	xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ""));

#if	!defined(IRIS_WIN32_WCE)

	if( IsWindowsNT() )	// NT n
	{
		// Vista / 2008 / 7 / 2008 R2
		if( m_Osviex.dwMajorVersion == 6 )
		{
			_Mychar MajVerStr[16] = {0};
			if( m_Osviex.wProductType == VER_NT_WORKSTATION )	// Vista / 7
			{
				if( m_Osviex.dwMinorVersion == 0 )		xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Vista "));
				else if( m_Osviex.dwMinorVersion == 1 )	xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows 7 "));
				else									xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows NT 6.x(unknown) "));
			}
			else	// Server 2008 / R2
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Server "));
				if( m_Osviex.dwMinorVersion == 0 )		xcscpy_s(MajVerStr, 16, IRIS_XTEXT(_Mychar, "2008"));
				else if( m_Osviex.dwMinorVersion == 1 )	xcscpy_s(MajVerStr, 16, IRIS_XTEXT(_Mychar, "2008 R2"));
				else									xcscpy_s(MajVerStr, 16, IRIS_XTEXT(_Mychar, "6.x(unknown)"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " "));
			}
			// Vista ȍ~łGetProductInfogp\
			typedef BOOL (WINAPI *PFN_GETPRODUCTINFO)(DWORD, DWORD, DWORD, DWORD, PDWORD);
			PFN_GETPRODUCTINFO pfnGetProductInfo = reinterpret_cast<PFN_GETPRODUCTINFO>(GetProcAddress(
				GetModuleHandle(IRIS_TEXT("kernel32.dll")), "GetProductInfo"));
			IRIS_ASSERT( pfnGetProductInfo != nullptr );
			DWORD dwType = 0;
			(*pfnGetProductInfo)(m_Osviex.dwMajorVersion, m_Osviex.dwMinorVersion, 0, 0, &dwType);
			switch( dwType )
			{
			// Windows Vista / 7
			case PRODUCT_ULTIMATE:
			case PRODUCT_ULTIMATE_N:
			case PRODUCT_ULTIMATE_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Ultimate Edition"));		break;
			case PRODUCT_HOME_PREMIUM:
			case PRODUCT_HOME_PREMIUM_N:
			case PRODUCT_HOME_PREMIUM_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Home Premium Edition"));	break;
			case PRODUCT_HOME_BASIC:
			case PRODUCT_HOME_BASIC_N:
			case PRODUCT_HOME_BASIC_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Home Basic Edition"));		break;
			case PRODUCT_ENTERPRISE:
			case PRODUCT_ENTERPRISE_N:
			case PRODUCT_ENTERPRISE_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Enterprise Edition"));		break;
			case PRODUCT_BUSINESS:
			case PRODUCT_BUSINESS_N:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Business Edition"));		break;
			case PRODUCT_STARTER:
			case PRODUCT_STARTER_N:
			case PRODUCT_STARTER_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Starter Edition"));		break;
			case PRODUCT_PROFESSIONAL:
			case PRODUCT_PROFESSIONAL_N:
			case PRODUCT_PROFESSIONAL_E:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Professional Edition"));	break;

			// Winodws Server 2008 / R2
			case PRODUCT_STANDARD_SERVER:
			case PRODUCT_STANDARD_SERVER_V:
			case PRODUCT_STANDARD_SERVER_CORE:
			case PRODUCT_STANDARD_SERVER_CORE_V:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Standard Edition"));		break;
			case PRODUCT_DATACENTER_SERVER:
			case PRODUCT_DATACENTER_SERVER_V:
			case PRODUCT_DATACENTER_SERVER_CORE:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Datacenter Edition"));		break;
			case PRODUCT_ENTERPRISE_SERVER:
			case PRODUCT_ENTERPRISE_SERVER_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Enterprise Edition"));		break;
			case PRODUCT_ENTERPRISE_SERVER_IA64:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Enterprise Edition for Itanium-based Systems "));	break;

			case PRODUCT_WEB_SERVER:
			case PRODUCT_WEB_SERVER_CORE:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Web Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				break;
			case PRODUCT_CLUSTER_SERVER:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows HPC Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				break;
			case PRODUCT_HOME_SERVER:
			case PRODUCT_HOME_SERVER_PREMIUM:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Home Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				if( dwType == PRODUCT_HOME_SERVER_PREMIUM )
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Premium Edition"));
				break;
			case PRODUCT_SMALLBUSINESS_SERVER:
			case PRODUCT_SMALLBUSINESS_SERVER_PREMIUM:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Small Business Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				if( dwType == PRODUCT_SMALLBUSINESS_SERVER_PREMIUM )
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Premium Edition"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Small Business Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Management Server"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Small Business Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Security Server"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Small Business Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Messaging Server"));
				break;

			case PRODUCT_SERVER_FOUNDATION:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Foundation"));						break;
			case PRODUCT_SERVER_FOR_SMALLBUSINESS:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "for Small Business Edition"));		break;
			case PRODUCT_SERVER_FOR_SMALLBUSINESS_V:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "for Windows Essential Server Solutions"));		break;
			case PRODUCT_HYPERV:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Hyper-V Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				break;

			case PRODUCT_STORAGE_EXPRESS_SERVER:
			case PRODUCT_STORAGE_EXPRESS_SERVER_CORE:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Storage Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Express Edition"));
				break;
			case PRODUCT_STORAGE_STANDARD_SERVER:
			case PRODUCT_STORAGE_STANDARD_SERVER_CORE:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Storage Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Standard Edition"));
				break;
			case PRODUCT_STORAGE_WORKGROUP_SERVER:
			case PRODUCT_STORAGE_WORKGROUP_SERVER_CORE:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Storage Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Workgroup Edition"));
				break;
			case PRODUCT_STORAGE_ENTERPRISE_SERVER:
			case PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE:
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Storage Server"));
				xcscat_s(lpString, dwLength, MajVerStr);
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Enterprise Edition"));
				break;
			default:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Unknown Edition"));	break;
			}

			// without Hyper-V
			switch( dwType )
			{
			case PRODUCT_STANDARD_SERVER_V:
			case PRODUCT_STANDARD_SERVER_CORE_V:
			case PRODUCT_DATACENTER_SERVER_V:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
			case PRODUCT_ENTERPRISE_SERVER_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
			case PRODUCT_SERVER_FOR_SMALLBUSINESS_V:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " without Hyper-V"));	break;
				break;
			}

			// core installation
			switch( dwType )
			{
			case PRODUCT_STANDARD_SERVER_CORE:
			case PRODUCT_STANDARD_SERVER_CORE_V:
			case PRODUCT_DATACENTER_SERVER_CORE:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
			case PRODUCT_WEB_SERVER_CORE:
			case PRODUCT_STORAGE_EXPRESS_SERVER_CORE:
			case PRODUCT_STORAGE_STANDARD_SERVER_CORE:
			case PRODUCT_STORAGE_WORKGROUP_SERVER_CORE:
			case PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE:
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " (core installation)"));	break;
				break;
			}

			// x86 or x64
			if( csi.Is64bitOS() )
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", 64-bit"));
			else if( csi.Is32bitOS() )
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", 32-bit"));
		}	// // Vista / 2008 / 7 / 2008 R2

		// Windows Server 2003 / XP x64
		if( m_Osviex.dwMajorVersion == 5 && m_Osviex.dwMinorVersion == 2 )
		{
			if( m_Osviex.wProductType == VER_NT_WORKSTATION )
			{
				// Windows XP Professional x64 Edition
				xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows XP Professional"));
				if( csi->wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64 )
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " x64 Edition"));
			}
			else
			{
				// Windows Server 2003
				if( m_Osviex.wSuiteMask & VER_SUITE_COMPUTE_SERVER )
				{
					xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Compute Cluster Server 2003"));
				}
				else if( m_Osviex.wSuiteMask & VER_SUITE_WH_SERVER )
				{
					xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Home Server"));
				}
				else
				{
					if( m_Osviex.wSuiteMask & (VER_SUITE_SMALLBUSINESS | VER_SUITE_SMALLBUSINESS_RESTRICTED) )
					{
						xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Small Business Server 2003"));
					}
					else if( m_Osviex.wSuiteMask & VER_SUITE_STORAGE_SERVER )
					{
						xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Storage Server 2003"));
					}
					else
					{
						xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows Server 2003"));
					}

					if( GetSystemMetrics(SM_SERVERR2) )	xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " R2"));
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", "));
					if( m_Osviex.wSuiteMask & VER_SUITE_DATACENTER )
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Datacenter"));
					}
					else if( m_Osviex.wSuiteMask & VER_SUITE_ENTERPRISE )
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Enterprise"));
					}
					else if( m_Osviex.wSuiteMask & VER_SUITE_BLADE )
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Web"));
					}
					else
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Standard"));
					}

					// x64
					if( csi->wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64 ) xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " x64"));
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Edition"));
					// IA64
					if( csi->wProcessorArchitecture == PROCESSOR_ARCHITECTURE_IA64 ) xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " for Itanium-based Systems"));
				}
			}
		}

		// XP
		if( m_Osviex.dwMajorVersion == 5 && m_Osviex.dwMinorVersion == 1 )
		{
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows XP "));
			if( GetSystemMetrics(SM_TABLETPC) )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Tablet PC Edition"));
			}
			else if( GetSystemMetrics(SM_MEDIACENTER) )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Tablet PC Edition"));
			}
			else if( GetSystemMetrics(SM_STARTER) )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Starter Edition"));
			}
			else if( m_Osviex.wSuiteMask & VER_SUITE_PERSONAL )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Home Edition"));
			}
			else if( m_Osviex.wSuiteMask & (VER_SUITE_EMBEDDEDNT | VER_SUITE_EMBEDDED_RESTRICTED) )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Embedded"));
			}
			else
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Professional"));
			}
		}

		// 2000
		if( m_Osviex.dwMajorVersion == 5 && m_Osviex.dwMinorVersion == 0 )
		{
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows 2000 "));
			if( m_Osviex.wProductType == VER_NT_WORKSTATION )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Professional"));
			}
			else
			{
				if( m_Osviex.wSuiteMask & VER_SUITE_DATACENTER )
				{
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Datacenter "));
				}
				else if( m_Osviex.wSuiteMask & VER_SUITE_ENTERPRISE )
				{
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Advanced "));
				}
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Server"));

			}
		}

		// NT 3 / 4
		if( m_Osviex.dwMajorVersion == 4 || m_Osviex.dwMajorVersion == 3 )
		{
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows NT "));
			if( bOSVersionInfoEx )
			{
				if( m_Osviex.wProductType == VER_NT_WORKSTATION )
				{
					if( m_Osviex.dwMajorVersion == 4 )
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "4.0 "));
					else
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "3.51 "));
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Workstation"));
				}
				else
				{
					xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Server"));
					if( m_Osviex.wSuiteMask & VER_SUITE_ENTERPRISE )
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", Enterprise Edition"));
					}
					else if( m_Osviex.wSuiteMask & VER_SUITE_TERMINAL )
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", Terminal Server Edition"));
					}
					else if( m_Osviex.wSuiteMask & (VER_SUITE_EMBEDDEDNT | VER_SUITE_EMBEDDED_RESTRICTED))
					{
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, ", Embedded Edition"));
					}
					if( m_Osviex.dwMajorVersion == 4 )
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "4.0 "));
					else
						xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "3.51 "));
				}
			}
			else
			{
				// TODO : Ή
			}
		}

		if( xcslen(m_Osviex.szCSDVersion) > 0 )
		{
			xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " "));
			xcscat_s(lpString, dwLength, m_Osviex.szCSDVersion);
		}

		// build number
		_Mychar build_number[64];
		xsprintf_s(build_number, 64, IRIS_XTEXT(_Mychar, " (build %d)"), m_Osviex.dwBuildNumber);
		xcscat_s(lpString, dwLength, build_number);
		return TRUE;

	}
	else if( m_Osviex.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS )
	{
		switch( m_Osviex.dwMinorVersion )
		{
		case 0:
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows 95"));
			if( xcschr(m_Osviex.szCSDVersion, IRIS_XTEXT(_Mychar, 'A')) != nullptr )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " OSR1"));
			}
			else if( xcschr(m_Osviex.szCSDVersion, IRIS_XTEXT(_Mychar, 'B')) != nullptr )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " OSR2"));
			}
			else if( xcschr(m_Osviex.szCSDVersion, IRIS_XTEXT(_Mychar, 'C')) != nullptr )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " OSR2.5"));
			}
			else
			{
				xcscat_s(lpString, dwLength, m_Osviex.szCSDVersion);
			}
			break;
		case 10:
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows 98"));
			if( xcschr(m_Osviex.szCSDVersion, IRIS_XTEXT(_Mychar, 'A')) != nullptr )
			{
				xcscat_s(lpString, dwLength, IRIS_XTEXT(_Mychar, " Second Edition"));
			}
			else
			{
				xcscat_s(lpString, dwLength, m_Osviex.szCSDVersion);
			}
			break;
		case 90:
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows ME"));
			break;
		default:
			xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Windows 9x(unknown)"));
			break;
		}
		return TRUE;
	}
#endif

	xcscpy_s(lpString, dwLength, IRIS_XTEXT(_Mychar, "Unknown Windows"));
	return FALSE;
}

template class CTOSVersionInfo<CHAR>;
template class CTOSVersionInfo<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CWXOSVersionUnitTest, Func)
{
	{
		TCHAR osver[256];
		COSVersionInfo osv;
		// GetWindowsOSVersionString
		if( osv.GetString(osver, 256) )
		{
			_putts(osver);
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
