//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXUserEnv.cpp
 * @brief		userenv t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXUserEnv_CPP_

//======================================================================
// include
#include "WXUserEnv.h"

#if !defined(IRIS_WIN32_WCE)

#include <userenv.h>

//======================================================================
// link
#pragma comment ( lib, "userenv.lib" )

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CUserEnv::CUserEnv(void)
{
}

/**********************************************************************//**
 *
 * ϐWJ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpSrc	= ̓obt@
 * @param [out]	lpDest	= o̓obt@
 * @param [in]	dwSize	= o̓obt@TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CUserEnv::ExpandEnvironmentStrings<CHAR>(LPCSTR lpSrc, LPSTR lpDest, DWORD dwSize) const
{
	return ::ExpandEnvironmentStringsForUserA(m_hObject, lpSrc, lpDest, dwSize);
}
template<>
BOOL CUserEnv::ExpandEnvironmentStrings<WCHAR>(LPCWSTR lpSrc, LPWSTR lpDest, DWORD dwSize) const
{
	return ::ExpandEnvironmentStringsForUserW(m_hObject, lpSrc, lpDest, dwSize);
}

/**********************************************************************//**
 *
 * ϐubN쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	bInherit	= p邩ǂ
 * @return	̈AhX
*//***********************************************************************/
LPVOID CUserEnv::CreateEnvironmentBlock(BOOL bInherit) const
{
	LPVOID blk = nullptr;
	if( !::CreateEnvironmentBlock(&blk, m_hObject, bInherit) ) return nullptr;
	return blk;
}

/**********************************************************************//**
 *
 * ϐubN폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpEnvironment	= ̈AhX
 * @return	
*//***********************************************************************/
BOOL CUserEnv::DestroyEnvironmentBlock(LPVOID lpEnvironment) const
{
	return ::DestroyEnvironmentBlock(lpEnvironment);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "../../etc/toolhelp/WXFindProcess.h"
#include "../WXProcess.h"
#include "iris_using.h"
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CWXUserEnv, ParentEnv)
{
	CFindProcess fp;
	DWORD dwID = fp.FindParentProcessId(::GetCurrentProcessId());
	if( dwID == 0 ) return;

	CProcess proc;
	ASSERT_TRUE( proc.Open(dwID) );

	CUserEnv env;
	ASSERT_TRUE( env.OpenFromProcess(proc, TOKEN_QUERY) );

	TCHAR path[MAX_PATH];
	ASSERT_TRUE( env.ExpandEnvironmentStrings(IRIS_TEXT("%hoge%"), path, MAX_PATH) );

	_putts(path);
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
