//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMHid.h
 * @brief		Hid t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMHid_H_
#define INCG_IRIS_WXMHid_H_

//======================================================================
// include
#include "../WXModule.h"

#if	defined(_IRIS_SUPPORT_WDK)

//======================================================================
// define
#ifndef __drv_maxIRQL
#  define __drv_maxIRQL(a)
#endif
#ifndef __drv_when
#  define __drv_when(a, b)
#endif
#ifndef __drv_freesMem
#  define __drv_freesMem(m)
#endif

//======================================================================
// include
EXTERN_C_BEGIN
#include <hidsdi.h>
EXTERN_C_END

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	Hid NX
*/
class CHidLib : private INonCopyable<CHidLib>
{
	CModule m_Module;
private:
	// RXgN^
	CHidLib(void)		{ Load(); }

	// CX^X̎擾
	static	CHidLib&	GetInstance(void)	{ static CHidLib Hid; return Hid; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("Hid32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static BOOLEAN HidD_GetAttributes(HANDLE HidDeviceObject, PHIDD_ATTRIBUTES pAttr)
	{
		PROC_LOAD(BOOLEAN, HidD_GetAttributes, (HANDLE HidDeviceObject, PHIDD_ATTRIBUTES pAttr), FALSE);
		return pfnProc(HidDeviceObject, pAttr);
	}
	static VOID HidD_GetHidGuid(LPGUID lpGuid)
	{
		PROC_LOAD(void, HidD_GetHidGuid, (LPGUID lpGuid), );
		pfnProc(lpGuid);
	}
	static BOOLEAN HidD_GetPreparsedData(HANDLE HidDeviceObject, PHIDP_PREPARSED_DATA * ppData)
	{
		PROC_LOAD(BOOLEAN, HidD_GetPreparsedData, (HANDLE HidDeviceObject, PHIDP_PREPARSED_DATA * ppData), FALSE);
		return pfnProc(HidDeviceObject, ppData);
	}
	static BOOLEAN HidD_FreePreparsedData(PHIDP_PREPARSED_DATA pData)
	{
		PROC_LOAD(BOOLEAN, HidD_FreePreparsedData, (PHIDP_PREPARSED_DATA pData), FALSE);
		return pfnProc(pData);
	}
	static BOOLEAN HidD_FlushQueue(HANDLE HidDeviceObject)
	{
		PROC_LOAD(BOOLEAN, HidD_FlushQueue, (HANDLE HidDeviceObject), FALSE);
		return pfnProc(HidDeviceObject);
	}
	static BOOLEAN HidD_GetConfiguration(HANDLE HidDeviceObject, PHIDD_CONFIGURATION pConfig, ULONG ConfigurationLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetConfiguration, (HANDLE HidDeviceObject, PHIDD_CONFIGURATION pConfig, ULONG ConfigurationLength), FALSE);
		return pfnProc(HidDeviceObject, pConfig, ConfigurationLength);
	}
	static BOOLEAN HidD_SetConfiguration(HANDLE HidDeviceObject, PHIDD_CONFIGURATION pConfig, ULONG ConfigurationLength)
	{
		PROC_LOAD(BOOLEAN, HidD_SetConfiguration, (HANDLE HidDeviceObject, PHIDD_CONFIGURATION pConfig, ULONG ConfigurationLength), FALSE);
		return pfnProc(HidDeviceObject, pConfig, ConfigurationLength);
	}
	static BOOLEAN HidD_GetFeature(HANDLE HidDeviceObject, PVOID ReportBuffer, ULONG ReportBufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetFeature, (HANDLE HidDeviceObject, PVOID ReportBuffer, ULONG ReportBufferLength), FALSE);
		return pfnProc(HidDeviceObject, ReportBuffer, ReportBufferLength);
	}
	static BOOLEAN HidD_SetFeature(HANDLE HidDeviceObject, PVOID ReportBuffer, ULONG ReportBufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetFeature, (HANDLE HidDeviceObject, PVOID ReportBuffer, ULONG ReportBufferLength), FALSE);
		return pfnProc(HidDeviceObject, ReportBuffer, ReportBufferLength);
	}
	static BOOLEAN HidD_GetNumInputBuffers(HANDLE HidDeviceObject, PULONG NumberBuffers)
	{
		PROC_LOAD(BOOLEAN, HidD_GetNumInputBuffers, (HANDLE HidDeviceObject, PULONG NumberBuffers), FALSE);
		return pfnProc(HidDeviceObject, NumberBuffers);
	}
	static BOOLEAN HidD_SetNumInputBuffers(HANDLE HidDeviceObject, ULONG NumberBuffers)
	{
		PROC_LOAD(BOOLEAN, HidD_SetNumInputBuffers, (HANDLE HidDeviceObject, ULONG NumberBuffers), FALSE);
		return pfnProc(HidDeviceObject, NumberBuffers);
	}
	static BOOLEAN HidD_GetPhysicalDescriptor(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetPhysicalDescriptor, (HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength), FALSE);
		return pfnProc(HidDeviceObject, Buffer, BufferLength);
	}
	static BOOLEAN HidD_GetManufacturerString(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetManufacturerString, (HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength), FALSE);
		return pfnProc(HidDeviceObject, Buffer, BufferLength);
	}
	static BOOLEAN HidD_GetProductString(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetProductString, (HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength), FALSE);
		return pfnProc(HidDeviceObject, Buffer, BufferLength);
	}
	static BOOLEAN HidD_GetIndexedString(HANDLE HidDeviceObject, ULONG StringIndex, PVOID Buffer, ULONG BufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetIndexedString, (HANDLE HidDeviceObject, ULONG StringIndex, PVOID Buffer, ULONG BufferLength), FALSE);
		return pfnProc(HidDeviceObject, StringIndex, Buffer, BufferLength);
	}
	static BOOLEAN HidD_GetSerialNumberString(HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength)
	{
		PROC_LOAD(BOOLEAN, HidD_GetSerialNumberString, (HANDLE HidDeviceObject, PVOID Buffer, ULONG BufferLength), FALSE);
		return pfnProc(HidDeviceObject, Buffer, BufferLength);
	}

	static NTSTATUS	HidP_GetCaps(PHIDP_PREPARSED_DATA PreparsedData, PHIDP_CAPS Capabilities)
	{
		PROC_LOAD(NTSTATUS, HidP_GetCaps, (PHIDP_PREPARSED_DATA PreparsedData, PHIDP_CAPS Capabilities), 0);
		return pfnProc(PreparsedData, Capabilities);
	}
	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}

};

}	// end of namespace wx
}	// end of namespace iris

#endif

#endif
