//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMNtDll.h
 * @brief		NtDll W[ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMNtDll_H_
#define INCG_IRIS_WXMNtDll_H_

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	NtDll W[NX
*/
class CNtDllModule : private INonCopyable<CNtDllModule>
{
	CModule m_Module;
private:
	// RXgN^
	CNtDllModule(void)		{ Load(); }

	// CX^X̎擾
	static	CNtDllModule&	GetInstance(void)	{ static CNtDllModule NtDll; return NtDll; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("ntdll.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static WORD RtlCaptureStackBackTrace(DWORD FramesToSkip, DWORD FramesToCapture, PVOID *BackTrace, PDWORD BackTraceHash)
	{
		PROC_LOAD(WORD, RtlCaptureStackBackTrace, (DWORD FramesToSkip, DWORD FramesToCapture, PVOID *BackTrace, PDWORD BackTraceHash), 0);
		return pfnProc(FramesToSkip, FramesToCapture, BackTrace, BackTraceHash);
	}

	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
