//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMVfw.h
 * @brief		Vfw t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMVfw_H_2BBF4EF9_C138_4581_8C17_D8045CCE24DA
#define INCG_IRIS_WXMVfw_H_2BBF4EF9_C138_4581_8C17_D8045CCE24DA

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	Vfw NX
*/
class CVfw : private INonCopyable<CVfw>
{
	CModule m_Module;
private:
	// RXgN^
	CVfw(void)		{ Load(); }

	// CX^X̎擾
	static	CVfw&	GetInstance(void)	{ static CVfw Vfw; return Vfw; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("msvfw32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		if( !GetInstance().Load() ) return _err;	\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static LONG InitVFW(void)
	{
		PROC_LOAD(LONG, InitVFW, (void), 0);
		return pfnProc();
	}
	static LONG TermVFW(void)
	{
		PROC_LOAD(LONG, TermVFW, (void), 0);
		return pfnProc();
	}

	static DWORD VideoForWindowsVersion(void)
	{
		PROC_LOAD(DWORD, VideoForWindowsVersion, (void), 0);
		return pfnProc();
	}

	/**
	* @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
