//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMWab.h
 * @brief		Wab t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXMWab_H_
#define INCG_IRIS_WXMWab_H_

//======================================================================
// include
#include "../WXModule.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	Wab W[NX
*/
class CWabModule : private INonCopyable<CWabModule>
{
	CModule m_Module;
private:
	// RXgN^
	CWabModule(void)		{ Load(); }

	// CX^X̎擾
	static	CWabModule&	GetInstance(void)	{ static CWabModule Wab; return Wab; }
	// W[̃[h
	BOOL	Load(void)
	{
		if( m_Module.IsValid() ) return TRUE;
		return m_Module.Load(IRIS_TEXT("wab32.dll"));
	}
	// W[̃A[h
	BOOL	Unload(void)
	{
		return m_Module.Release();
	}

#define PROC_LOAD(_ret, _name, _args, _err)			\
	typedef _ret (__stdcall *pfn##_name)##_args;	\
	static pfn##_name	pfnProc = nullptr;			\
	do {											\
	if( pfnProc == nullptr ) {						\
		GetInstance().Load();						\
		pfnProc = GetProcAddress<pfn##_name>(#_name);	\
		if( pfnProc == nullptr ) return _err;		\
	} } while(0)

public:
	/**
	 * @name	wrap
	 * @{
	*/
	static HRESULT WABOpen(LPADRBOOK* lpAdrBook, LPWABOBJECT* lpWabObj, LPWAB_PARAM lpWabParam, DWORD dwReserved)
	{
		PROC_LOAD(HRESULT, WABOpen, (LPADRBOOK* lpAdrBook, LPWABOBJECT* lpWabObj, LPWAB_PARAM lpWabParam, DWORD dwReserved), ERROR_INVALID_ACCESS);
		return pfnProc(lpAdrBook, lpWabObj, lpWabParam, dwReserved);
	}
	/**
	 * @}
	*/

#undef PROC_LOAD

public:
	// AhX擾
	template<typename F, typename CHARTYPE_>
	static F	GetProcAddress(const CHARTYPE_ * lpProcName)
	{
IRIS_MSC_PRAGMA_WARNING_BEGIN()
IRIS_MSC_PRAGMA_WARNING_DISABLE(4191)	// PROC  hoge ւ̕ϊ͕ۏ؂܂B
		return reinterpret_cast<F>(GetInstance().m_Module.GetProcAddress(lpProcName));
IRIS_MSC_PRAGMA_WARNING_END()
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
