//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMappedProfile.cpp
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMappedProfile_CPP_

//======================================================================
// include
#include "WXMappedProfile.h"
#include "iris_debug.h"
#include "iris_xchar.hpp"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTMappedPrivateProfile<CHARTYPE_>::CTMappedPrivateProfile(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTMappedPrivateProfile<CHARTYPE_>::~CTMappedPrivateProfile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTMappedPrivateProfile<CHARTYPE_>::Close(void)
{
	_Mybase::Close();
	ClearProfileList();
}

/**********************************************************************//**
 *
 * ZNṼXg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTMappedPrivateProfile<CHARTYPE_>::MakeAppList(void)
{
	if( !IsOpen() ) return false;
	if( !m_Profile.empty() ) return true;
	_Mylpstr buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new _Mychar [size];
		if( buf == nullptr ) return false;
		DWORD ret = GetSectionNames(buf, size);
		if( ret == 0 )
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	_Mylpstr tmp = buf;
	_Mylpstr p = xcschr(tmp, IRIS_XTEXT(_Mychar, '\0'));
	while(p)
	{
		*p = IRIS_XTEXT(_Mychar, '\0');
		_Mystring str = tmp;
		SectionData data;
		m_Profile.push_back(ProfilePair(str, data));
		tmp = p+1;
		p = xcschr(tmp, IRIS_XTEXT(_Mychar, '\0'));
		if( tmp == p ) break;
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * L[̃Xg
 *  ŃZNṼXg܂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTMappedPrivateProfile<CHARTYPE_>::MakeKeyList(_Mylpcstr lpAppName)
{
	if( !MakeAppList() ) return false;
	SectionData* pData = FindSectionData(lpAppName);
	if( pData == nullptr ) return false;
	return MakeKeyList(lpAppName, m_Path, *pData);
}

/**********************************************************************//**
 *
 * L[̃Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpFileName	= t@C
 * @param [out]	rData		= o
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTMappedPrivateProfile<CHARTYPE_>::MakeKeyList(_Mylpcstr lpAppName, _Mylpcstr lpFileName, SectionData& rData)
{
	if( lpAppName == nullptr ) return false;
	if( lpFileName == nullptr ) return false;
	_Mylpstr buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new _Mychar [size];
		if( buf == nullptr ) return false;
		DWORD ret = _Mybase::GetSection(lpAppName, buf, size, lpFileName);
		if( ret == 0 )
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	_Mylpstr tmp = buf;
	_Mylpstr p = xcschr(tmp, IRIS_XTEXT(_Mychar, '='));
	while(p)
	{
		*p = IRIS_XTEXT(_Mychar, '\0');
		// L[
		_Mystring str = tmp;
		tmp = p+1;
		p = xcschr(tmp, IRIS_XTEXT(_Mychar, '\0'));

		// L[l
		KeyData val = tmp;
		rData.push_back(SectionPair(str, val));
		tmp = p+1;
		if( *tmp == IRIS_XTEXT(_Mychar, '\0') ) break;
		p = xcschr(tmp, IRIS_XTEXT(_Mychar, '='));
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[̃Xg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTMappedPrivateProfile<CHARTYPE_>::MakeProfileList(void)
{
	if( !MakeAppList() ) return false;
	for( ProfileData::iterator it=m_Profile.begin(), end = m_Profile.end(); it != end; ++it)
	{
		MakeKeyList(it->first.c_str());
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[Xg̃NA
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTMappedPrivateProfile<CHARTYPE_>::ClearProfileList(void)
{
	m_Profile.clear();
}

/**********************************************************************//**
 *
 * Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
template<typename CHARTYPE_>
bool CTMappedPrivateProfile<CHARTYPE_>::WriteList(bool bClear)
{
	if( !IsOpen() ) return false;
	if( bClear ) Remove();

	for( ProfileData::iterator it = m_Profile.begin(), end = m_Profile.end(); it != end; ++it )
	{
		for( SectionData::iterator sub_it = it->second.begin(), sub_end = it->second.end(); sub_it != sub_end; ++sub_it )
		{
			WriteString(it->first.c_str(), sub_it->first.c_str(), sub_it->second.c_str());
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNV̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @return	ZNV
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::_Mystring* CTMappedPrivateProfile<CHARTYPE_>::GetSectionName(int nIndex)
{
	if( nIndex < 0 || nIndex >= (int)m_Profile.size() ) return nullptr;
	return &m_Profile[nIndex].first;
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::_Mystring* CTMappedPrivateProfile<CHARTYPE_>::GetKeyName(int nAppIndex, int nIndex)
{
	_Mystring* p = GetSectionName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyName(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::_Mystring* CTMappedPrivateProfile<CHARTYPE_>::GetKeyName(_Mylpcstr lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].first);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[l
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::KeyData* CTMappedPrivateProfile<CHARTYPE_>::GetKeyData(int nAppIndex, int nIndex)
{
	_Mystring* p = GetSectionName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyData(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[l
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::KeyData* CTMappedPrivateProfile<CHARTYPE_>::GetKeyData(_Mylpcstr lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].second);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	L[l
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::KeyData* CTMappedPrivateProfile<CHARTYPE_>::GetKeyData(_Mylpcstr lpAppName, _Mylpcstr lpKeyName)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	SectionData::iterator it = p->find(_Mystring(lpKeyName));
	if( it == p->end() ) return nullptr;
	return &it->second;
}

/**********************************************************************//**
 *
 * ZNV폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTMappedPrivateProfile<CHARTYPE_>::DeleteSection(_Mylpcstr lpAppName)
{
	ProfileData::iterator it = m_Profile.find(_Mystring(lpAppName));
	if( it == m_Profile.end() ) return FALSE;
	m_Profile.erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * L[폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTMappedPrivateProfile<CHARTYPE_>::DeleteKey(_Mylpcstr lpAppName, _Mylpcstr lpKeyName)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return FALSE;
	SectionData::iterator it = p->find(_Mystring(lpKeyName));
	if( it == p->end() ) return FALSE;
	p->erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * ZNVXǧ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	ZNVf[^
*//***********************************************************************/
template<typename CHARTYPE_>
typename CTMappedPrivateProfile<CHARTYPE_>::SectionData* CTMappedPrivateProfile<CHARTYPE_>::FindSectionData(_Mylpcstr lpAppName)
{
	ProfileData::iterator it = m_Profile.find(_Mystring(lpAppName));
	if( it == m_Profile.end() ) return nullptr;
	return &it->second;
}

/**********************************************************************//**
 *
 * Dump
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTMappedPrivateProfile<CHARTYPE_>::Dump(void) const
{
	const ProfileData& data = GetProfileData();
	for( u32 i=0; i < data.size(); ++i )
	{
		printf("[");
		xprintf(data[i].first.c_str());
		printf("]\n");
		const SectionData& sec = data[i].second;
		for( u32 i=0; i < sec.size(); ++i )
		{
			printf("\t");
			xprintf(sec[i].first.c_str());
			printf("=");
			xprintf(sec[i].second.c_str());
			printf("\n");
		}
	}
}

template class CTMappedPrivateProfile<CHAR>;
template class CTMappedPrivateProfile<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris_using.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXMappedPrivateProfileUnitTest, Func)
{
	TCHAR path[MAX_PATH];
	std::cout << "Jinit@C͂ĂB" << std::endl;
	std::tcin >> path;

	CMappedPrivateProfile inifile;
	inifile.Open(path);
	inifile.Dump();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
