//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegistry.h
 * @brief		WXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXRegistry_H_
#define INCG_IRIS_WXRegistry_H_

//======================================================================
// include
#include "iris_object.h"
#include <winreg.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! WXgNX
class CRegistry : private INonCopyable<>
{
private:
	HKEY	m_hKey;
public:
	typedef BOOL	(*PFN_EnumProc)(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg);
public:
	// RXgN^
	CRegistry(void);
	CRegistry(HKEY hKey);
	// fXgN^
	virtual ~CRegistry(void);

	HKEY	GetKey(void)		const	{ return m_hKey; }
	HKEY	operator () (void)	const	{ return GetKey(); }
	operator HKEY (void)		const	{ return GetKey(); }

public:
	// ֘At
	HKEY	Attach(HKEY hKey);
	// ֘At̉
	HKEY	Detach(void);

public:
	BOOL	IsValid(void)	const		{ return m_hKey != nullptr ? TRUE : FALSE; }
public:
	// J
	template<typename CHARTYPE_>
	BOOL	Open(HKEY hKey, const CHARTYPE_* lpSubKey);

	template<typename CHARTYPE_>
	BOOL	OpenEx(HKEY hKey, const CHARTYPE_* lpSubKey, DWORD dwOptions, REGSAM samDesired);
	// 
	BOOL	Close(void);

public:
	// 쐬


public:
	// l擾
	template<typename CHARTYPE_>
	BOOL	QueryValue(const CHARTYPE_* lpSubKey, CHARTYPE_* lpValue, PLONG lpcbValue) const;

	template<typename CHARTYPE_>
	BOOL	QueryValueEx(const CHARTYPE_* lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData) const;

public:
	// lݒ
	template<typename CHARTYPE_>
	BOOL	SetValue(const CHARTYPE_* lpSubKey, DWORD dwType, const CHARTYPE_* lpData, DWORD cbData);

	template<typename CHARTYPE_>
	BOOL	SetValueEx(const CHARTYPE_* lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData);

public:
	// 
	template<typename CHARTYPE_>
	LSTATUS	EnumKey(DWORD dwIndex, CHARTYPE_* lpName, DWORD cchName);

	template<typename CHARTYPE_>
	LSTATUS	EnumKeyEx(DWORD dwIndex, CHARTYPE_* lpName, LPDWORD lpcchName, LPDWORD lpReserved, CHARTYPE_* lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime);

	// 񋓏
	BOOL	EnumKeyProc(PFN_EnumProc pfnEnumProc, LPVOID lpArg);

public:
	// L[̃ZLeBݒ
	BOOL	SetKeySecurity(SECURITY_INFORMATION si, PSECURITY_DESCRIPTOR sd);

public:
	// L[̕ۑ
	template<typename CHARTYPE_>
	BOOL	SaveKey (const CHARTYPE_* lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
