//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXActiveDesktop.cpp
 * @brief		ANeBufXNgbvNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXActiveDesktop_CPP_

//======================================================================
// include
#include "WXActiveDesktop.h"
#include <stdio.h>
#include "../wx_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CActiveDesktop::CActiveDesktop(void)
#if	!defined(IRIS_WIN32_WCE)
: m_pAD(nullptr)
#endif
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CActiveDesktop::~CActiveDesktop(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CActiveDesktop::Initialize(void)
{
#if	!defined(IRIS_WIN32_WCE)
	HRESULT hr = S_OK;
	if( !IsInit() )
	{
		hr = CoInitialize();
		if( FAILED(hr) ) return FALSE;
	}
	hr = CoCreateInstance(CLSID_ActiveDesktop, nullptr, CLSCTX_INPROC_SERVER,
								IID_IActiveDesktop, (LPVOID*)&m_pAD);
	if( FAILED(hr) )
	{
		puts("failed CoCreateInstance.");
		return FALSE;
	}
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
void CActiveDesktop::Release(void)
{
#if	!defined(IRIS_WIN32_WCE)
	IRIS_SAFE_RELEASE(m_pAD);
#endif
}

/**********************************************************************//**
 *
 * ANeBx[g
 *
 ----------------------------------------------------------------------
 * @param [in]	bComponents		= 
 * @param [in]	bActiveDesktop	= 
 * @return	
*//***********************************************************************/
HRESULT CActiveDesktop::Activate(BOOL bComponents, BOOL bActiveDesktop)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	COMPONENTSOPT comopt;
	comopt.dwSize = sizeof(comopt);
	//m_pAD->GetDesktopItemOptions(&comopt, 0);
	comopt.fEnableComponents = bComponents;
	comopt.fActiveDesktop	 = bActiveDesktop;
	return m_pAD->SetDesktopItemOptions(&comopt, 0);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= AD_APPLY_***
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::ApplyChanges(DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->ApplyChanges(dwFlags);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎt@C̃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @param [in]	cchWallpaper	= lpszWallpaper̃obt@TCY
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::GetWallpaper<CHAR>(LPSTR  lpszWallpaper, UINT cchWallpaper, DWORD dwReserved) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	WCHAR szWallpaper[MAX_PATH];
	HRESULT hr = m_pAD->GetWallpaper(szWallpaper, MAX_PATH, dwReserved);
	if( FAILED(hr) ) return hr;
	WideCharToMultiByte(CP_THREAD_ACP, 0, szWallpaper, -1, lpszWallpaper, cchWallpaper, nullptr, nullptr);
	return hr;
#else
	return E_NOTIMPL;
#endif
}
/// @ref GetWallpaper
template<>
HRESULT	CActiveDesktop::GetWallpaper<WCHAR>(LPWSTR lpszWallpaper, UINT cchWallpaper, DWORD dwReserved) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->GetWallpaper(lpszWallpaper, cchWallpaper, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎt@C̃pXݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::SetWallpaper<CHAR>(LPCSTR  lpszWallpaper, DWORD dwReserved)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszWallpaper, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszWallpaper, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->SetWallpaper(pwszTemp, dwReserved);
	delete [] pwszTemp;
	return hr;
#else
	return E_NOTIMPL;
#endif
}
/// CActiveDesktop::SetWallpaper Q
template<>
HRESULT	CActiveDesktop::SetWallpaper<WCHAR>(LPCWSTR lpszWallpaper, DWORD dwReserved)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->SetWallpaper(lpszWallpaper, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎ̃IvVݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpwpo			= ݒ
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetWallpaperOptions(LPWALLPAPEROPT lpwpo, DWORD dwReserved) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->GetWallpaperOptions(lpwpo, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎ̃IvVݒݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpwpo			= ݒ
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetWallpaperOptions(LPCWALLPAPEROPT lpwpo, DWORD dwReserved)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->SetWallpaperOptions(lpwpo, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎ̃p^[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszPattern		= p^[
 * @param [in]	cchPattern		= lpszPatterñobt@TCY
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::GetPattern<CHAR>(LPSTR  lpszPattern, UINT cchPattern, DWORD dwReserved) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	WCHAR szTemp[1024];	// TODO:obt@H
	HRESULT hr = m_pAD->GetPattern(szTemp, 1024, dwReserved);
	if( FAILED(hr) ) return hr;
	WideCharToMultiByte(CP_THREAD_ACP, 0, szTemp, -1, lpszPattern, cchPattern, nullptr, nullptr);
	return hr;
#else
	return E_NOTIMPL;
#endif
}
/// CActiveDesktop::GetPattern Q
template<>
HRESULT	CActiveDesktop::GetPattern<WCHAR>(LPWSTR lpszPattern, UINT cchPattern, DWORD dwReserved) const
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->GetPattern(lpszPattern, cchPattern, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

/**********************************************************************//**
 *
 * ǎ̃p^[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszPattern		= p^[
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::SetPattern<CHAR>(LPCSTR  lpszPattern, DWORD dwReserved)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszPattern, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszPattern, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->SetPattern(pwszTemp, dwReserved);
	delete [] pwszTemp;
	return hr;
#else
	return E_NOTIMPL;
#endif
}
/// CActiveDesktop::SetPattern Q
template<>
HRESULT	CActiveDesktop::SetPattern<WCHAR>(LPCWSTR lpszPattern, DWORD dwReserved)
{
#if	!defined(IRIS_WIN32_WCE)
	if( m_pAD == nullptr ) return E_FAIL;
	return m_pAD->SetPattern(lpszPattern, dwReserved);
#else
	return E_NOTIMPL;
#endif
}

#if	!defined(IRIS_WIN32_WCE)

/**********************************************************************//**
 *
 * IvVݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpco			= ݒ
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemOptions(LPCOMPONENTSOPT lpco, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemOptions(lpco, dwReserved);
}

/**********************************************************************//**
 *
 * IvVݒݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpco			= ݒ
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetDesktopItemOptions(LPCCOMPONENTSOPT lpco, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->SetDesktopItemOptions(lpco, dwReserved);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::AddDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddDesktopItem(lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::AddDesktopItemWithUI(HWND hWnd, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddDesktopItemWithUI(hWnd, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwFlags			= tO
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::ModifyDesktopItem(LPCCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->ModifyDesktopItem(lpcomp, dwFlags);
}

/**********************************************************************//**
 *
 * fXNgbvACe̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::RemoveDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->RemoveDesktopItem(lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpiCount		= 
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemCount(LPINT lpiCount, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemCount(lpiCount, dwReserved);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	nComponent		= 
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItem(int nComponent, LPCOMPONENT lpcomp, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItem(nComponent, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * GetDesktopItemByID
 *
 ----------------------------------------------------------------------
 * @param [in]	dwID			= ID
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemByID(ULONG_PTR dwID, LPCOMPONENT lpcomp, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemByID(dwID, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * GenerateDesktopItemHtml
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::GenerateDesktopItemHtml<CHAR>(LPCSTR  lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszFileName, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszFileName, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->GenerateDesktopItemHtml(pwszTemp, lpcomp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::GenerateDesktopItemHtml Q
template<>
HRESULT	CActiveDesktop::GenerateDesktopItemHtml<WCHAR>(LPCWSTR lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GenerateDesktopItemHtml(lpszFileName, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * AddUrl
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= EBhEnh
 * @param [in]	lpszSource		= 
 * @param [in]	lpcomp			= R|[lg
 * @param [in]	dwFlags			= tO
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::AddUrl<CHAR>(HWND hWnd, LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->AddUrl(hWnd, pwszTemp, lpcomp, dwFlags);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::AddUrl Q
template<>
HRESULT	CActiveDesktop::AddUrl<WCHAR>(HWND hWnd, LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddUrl(hWnd, lpszSource, lpcomp, dwFlags);
}

/**********************************************************************//**
 *
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszSource		=
 * @param [in]	lpcomp			=R|[lg
 * @param [in]	dwReserved		= \
 * @return	HRESULTl
*//***********************************************************************/
template<>
HRESULT	CActiveDesktop::GetDesktopItemBySource<CHAR>(LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->GetDesktopItemBySource(pwszTemp, lpcomp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::GetDesktopItemBySource Q
template<>
HRESULT	CActiveDesktop::GetDesktopItemBySource<WCHAR>(LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved) const
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemBySource(lpszSource, lpcomp, dwReserved);
}

#endif

}	// end of namespace wx
}	// end of namespace iris
