//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHExecute.cpp
 * @brief		Shell֐gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSHExecute_CPP_

//======================================================================
// include
#include "WXSHExecute.h"
#include "../os/WXProcess.h"
#include <commctrl.h>
#include <shlwapi.h>
#include <tchar.h>
#include "../wx_inchead.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#    pragma comment( lib, "coredll.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
template<>
HINSTANCE CTSHExecute<CHAR>::Run(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}
template<>
HINSTANCE CTSHExecute<WCHAR>::Run(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @param [out]	lpsei			= 
 * @return	nh
*//***********************************************************************/
template<>
HINSTANCE CTSHExecute<CHAR>::Run(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOA lpsei)
{
	SHELLEXECUTEINFOA sei = {0};
	ULONG mask = SEE_MASK_DOENVSUBST;
	if( lpsei == nullptr ) lpsei = &sei;
	else mask |= SEE_MASK_NOCLOSEPROCESS;
	if( lpsei->cbSize != sizeof(SHELLEXECUTEINFOA) )
	{
		lpsei->cbSize		= sizeof(sei);
		lpsei->hwnd			= hwnd;
		lpsei->lpFile		= lpFile;
		lpsei->nShow		= nShowCmd;
		lpsei->fMask		= mask;
		lpsei->lpDirectory	= lpDirectory;
		lpsei->lpParameters	= lpParameters;
		lpsei->lpVerb		= lpOperation;
	}
	if( !ShellExecuteExA(lpsei) ) return nullptr;
	return lpsei->hInstApp;
}
template<>
HINSTANCE CTSHExecute<WCHAR>::Run(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOW lpsei)
{
	SHELLEXECUTEINFOW sei = {0};
	ULONG mask = SEE_MASK_DOENVSUBST;
	if( lpsei == nullptr ) lpsei = &sei;
	else mask |= SEE_MASK_NOCLOSEPROCESS;
	if( lpsei->cbSize != sizeof(SHELLEXECUTEINFOW) )
	{
		lpsei->cbSize		= sizeof(sei);
		lpsei->hwnd			= hwnd;
		lpsei->lpFile		= lpFile;
		lpsei->nShow		= nShowCmd;
		lpsei->fMask		= mask;
		lpsei->lpDirectory	= lpDirectory;
		lpsei->lpParameters	= lpParameters;
		lpsei->lpVerb		= lpOperation;
	}
	if( !ShellExecuteExW(lpsei) ) return nullptr;
	return lpsei->hInstApp;
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
template<typename CHARTYPE_>
DWORD CTSHExecute<CHARTYPE_>::RunWait(HWND hwnd, _Mylpcstr lpOperation, _Mylpcstr lpFile, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd)
{
	EXECUTEINFO sei;
	if( Run(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd, &sei) )
	{
		CProcess proc(sei.hProcess);
		proc.Wait(INFINITE);
		return proc.GetExitCode();
	}
	return 1;
}


template class CTSHExecute<CHAR>;
template class CTSHExecute<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
