//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSHExecute.h
 * @brief		Shell֐gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXSHExecute_H_
#define INCG_IRIS_WXSHExecute_H_

//======================================================================
// include
#include "iris_object.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include <shellapi.h>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTSHExecute;

//======================================================================
// typedef
typedef CTSHExecute<CHAR>	CSHExecuteA;
typedef CTSHExecute<WCHAR>	CSHExecuteW;
typedef CTSHExecute<TCHAR>	CSHExecute;

//======================================================================
// class
/**
 * @brief	sNX
*/
template<typename CHARTYPE_>
class CTSHExecute : public IIrisObject
{
	typedef CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;

	typedef typename iml::type_select< (cpp0x::is_same<CHARTYPE_, WCHAR>::value), SHELLEXECUTEINFOW, SHELLEXECUTEINFOA >::type EXECUTEINFO;
	typedef EXECUTEINFO		*LPEXECUTEINFO;
public:
	static HINSTANCE	Run(HWND hwnd, _Mylpcstr lpOperation, _Mylpcstr lpFile, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd);

	static HINSTANCE	Run(HWND hwnd, _Mylpcstr lpOperation, _Mylpcstr lpFile, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd, LPEXECUTEINFO lpsei);

	static DWORD		RunWait(HWND hwnd, _Mylpcstr lpOperation, _Mylpcstr lpFile, _Mylpcstr lpParameters
					, _Mylpcstr lpDirectory, INT nShowCmd);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
