//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellLink.cpp
 * @brief		Nt@C쐬֐
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXShellLink_CPP_

//======================================================================
// include
#include "WXShellLink.h"

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif

//======================================================================
// define
#if	defined(IRIS_WIN32_WCE)
#  define IID_IShellLinkA	IID_IShellLink
#  define IID_IShellLinkW	IID_IShellLink
#endif

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * V[gJbgt@C̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwClsContext	= ReLXg(CLSCTX_***)
 * @param [in]	pUnkOuter		= AOQ[gIuWFNg
 * @return 
*//***********************************************************************/
template<>
HRESULT CSHLink<CHAR>::Initialize(DWORD dwClsContext, LPUNKNOWN pUnkOuter)
{
#if	!defined(IRIS_WIN32_WCE)
	HRESULT hr = m_ShellLink.Create(CLSID_ShellLink, pUnkOuter, dwClsContext,
							IID_IShellLinkA);
	return hr;
#else
	return (HRESULT)-1;
#endif
}
template<>
HRESULT CSHLink<WCHAR>::Initialize(DWORD dwClsContext, LPUNKNOWN pUnkOuter)
{
#if	!defined(IRIS_WIN32_WCE)
	HRESULT hr = m_ShellLink.Create(CLSID_ShellLink, pUnkOuter, dwClsContext,
							IID_IShellLinkW);
	return hr;
#else
	return (HRESULT)-1;
#endif
}

/**********************************************************************//**
 *
 * V[gJbgt@C̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	pszLink			= V[gJbg̐΃pX
 * @param [in]	pszFile			= ^[Qbgt@C
 * @param [in]	pszDescription	= 
 * @param [in]	pszArgs			= 
 * @param [in]	pszWorkingDir	= ƃfBNg
 * @param [in]	pszIconPath		= ACȐꏊ
 * @param [in]	nIcon			= ACR̃CfbNX
 * @param [in]	nShowCmd		= EBhE\R}h
 * @return HRESULTl
*//***********************************************************************/
template<>
HRESULT CSHLink<CHAR>::CreateLinkFile(_Mylpcstr  pszLink
						, _Mylpcstr  pszFile
						, _Mylpcstr  pszDescription
						, _Mylpcstr  pszArgs
						, _Mylpcstr  pszWorkingDir
						, _Mylpcstr  pszIconPath
						, int nIcon
						, int nShowCmd )
{
	HRESULT hr;
	_Myt psl;
	hr = psl.Initialize(CLSCTX_INPROC_SERVER);
	if(FAILED(hr)) return hr;

	// V[gJbg񎟋Luɕۑ邽 IPersistFile
	// C^[tFCX̖₢킹Ȃ
	CComObj<IPersistFile> ppf;
	hr = psl.QueryInterface(IID_IPersistFile, ppf);
	if(FAILED(hr)) return hr;

	WORD wsz[MAX_PATH];  // Unicode ւ̃obt@(MAX_PATH΂)
	psl->SetPath(pszFile);						// ^[Qbgt@C
	psl->SetDescription(pszDescription);		// 
	psl->SetArguments(pszArgs);					// 
	psl->SetWorkingDirectory(pszWorkingDir);	// ƃfBNg
	psl->SetIconLocation(pszIconPath, nIcon);	// ACR
	psl->SetShowCmd(nShowCmd);					// EBhE\R}h

	// ANSIō\悤ɂ
	MultiByteToWideChar(CP_ACP, 0, pszLink, -1, (LPWSTR)wsz, MAX_PATH);
	// V[gJbgۑ
	hr = ppf->Save((LPCOLESTR)wsz, TRUE);
    return hr;
}
template<>
HRESULT CSHLink<WCHAR>::CreateLinkFile(_Mylpcstr pszLink
						, _Mylpcstr pszFile
						, _Mylpcstr pszDescription
						, _Mylpcstr pszArgs
						, _Mylpcstr pszWorkingDir
						, _Mylpcstr pszIconPath
						, int nIcon
						, int nShowCmd )
{
	HRESULT hr;
	_Myt psl;
	hr = psl.Initialize(CLSCTX_INPROC_SERVER);
	if(FAILED(hr)) return hr;

	// V[gJbg񎟋Luɕۑ邽 IPersistFile
	// C^[tFCX̖₢킹Ȃ
	CComObj<IPersistFile> ppf;
	hr = psl.QueryInterface(IID_IPersistFile, ppf);
	if(FAILED(hr)) return hr;

#if	!defined(IRIS_WIN32_WCE)
	psl->SetPath(pszFile);						// ^[Qbgt@C
	psl->SetDescription(pszDescription);		// 
	psl->SetArguments(pszArgs);					// 
	psl->SetWorkingDirectory(pszWorkingDir);	// ƃfBNg
	psl->SetIconLocation(pszIconPath, nIcon);	// ACR
#else
	CHAR file[MAX_PATH];
	CHAR descript[512];
	CHAR args[1024];
	CHAR workdir[MAX_PATH];
	CHAR icon[MAX_PATH];
	wcstombs(file, pszFile, MAX_PATH);
	wcstombs(descript, pszDescription, IRIS_NumOfElements(descript));
	wcstombs(args, pszArgs, IRIS_NumOfElements(args));
	wcstombs(workdir, pszWorkingDir, MAX_PATH);
	wcstombs(icon, pszIconPath, MAX_PATH);
	psl->SetPath(file);					// ^[Qbgt@C
	psl->SetDescription(descript);		// 
	psl->SetArguments(args);			// 
	psl->SetWorkingDirectory(workdir);	// ƃfBNg
	psl->SetIconLocation(icon, nIcon);	// ACR
#endif
	psl->SetShowCmd(nShowCmd);					// EBhE\R}h

	// V[gJbgۑ
	hr = ppf->Save((LPCOLESTR)pszLink, TRUE);
    return hr;
}

template class CSHLink<CHAR>;
template class CSHLink<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
