//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellLink.h
 * @brief		Nt@C쐬֐
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXShellLink_H_
#define INCG_IRIS_WXShellLink_H_

//======================================================================
// include
#include "../com/WXComObj.h"
#include "ml/iml_type_select.hpp"
#include "shlobj_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ShellLink NX
*/
template<typename CHARTYPE_>
class CSHLink : public IIrisObject
{
	typedef	CHARTYPE_		_Mychar;
	typedef CHARTYPE_		*_Mylpstr;
	typedef const CHARTYPE_	*_Mylpcstr;

#if	!defined(IRIS_WIN32_WCE)
	typedef typename iml::type_select<(sizeof(_Mychar) == sizeof(WCHAR)), IShellLinkW, IShellLinkA>::type _MyIShellLink;
#else
	typedef IShellLink		_MyIShellLink;
#endif

	typedef CSHLink<CHARTYPE_>	_Myt;

protected:
	CComObj<_MyIShellLink>	m_ShellLink;

public:
	// 
	HRESULT	Initialize(DWORD dwClsContext, LPUNKNOWN pUnkOuter=nullptr);

	template<typename IT2>
	HRESULT	QueryInterface(REFIID riid, CComObj<IT2>& obj)
	{
		return m_ShellLink.QueryInterface(riid, obj);
	}

public:
	// Nt@C̍쐬
	static HRESULT CreateLinkFile(_Mylpcstr pszLink
							, _Mylpcstr pszFile
							, _Mylpcstr pszDescription
							, _Mylpcstr pszArgs = nullptr
							, _Mylpcstr pszWorkingDir = nullptr
							, _Mylpcstr pszIconPath = nullptr
							, int nIcon = 0
							, int nShowCmd = SW_SHOW );

public:
	/**
	 * @name	operator
	 * @{
	*/
			_MyIShellLink*	operator -> (void)			{ return m_ShellLink(); }
	const	_MyIShellLink*	operator -> (void)	const	{ return m_ShellLink(); }
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
