//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellPath.cpp
 * @brief		pXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXShellPath_CPP_

//======================================================================
// include
#include "WXShellPath.h"
#include <shlwapi.h>
#include <tchar.h>

//======================================================================
// link
#if defined(IRIS_MSC)
#  if	defined(IRIS_WIN32_WCE)
#    pragma comment( lib, "ceshell.lib" )
#  else
#    pragma comment( lib, "shlwapi.lib" )
#  endif
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE>
CTPath<CHARTYPE>::CTPath(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE>
CTPath<CHARTYPE>::CTPath(_Mylpcstr  lpszPath)
{
	Copy(lpszPath);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE>
CTPath<CHARTYPE>::~CTPath(void)
{
}

/**********************************************************************//**
 *
 * operator
 *
*//***********************************************************************/
//! _tcscat
template<>
CTPath<CHAR>& CTPath<CHAR>::operator += (_Mylpcstr  lpString)
{
	strcat_s(m_Path, MAX_PATH, lpString);
	return *this;
}
template<>
CTPath<WCHAR>& CTPath<WCHAR>::operator += (_Mylpcstr  lpString)
{
	wcscat_s(m_Path, MAX_PATH, lpString);
	return *this;
}

/**********************************************************************//**
 *
 * Rs[
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::Copy(_Mylpcstr  lpszPath)
{
	strcpy_s(m_Path, MAX_PATH, lpszPath);
}
template<>
void CTPath<WCHAR>::Copy(_Mylpcstr  lpszPath)
{
	wcscpy_s(m_Path, MAX_PATH, lpszPath);
}

/**********************************************************************//**
 *
 * obNXbVǉ
 *
 ----------------------------------------------------------------------
 * @return	g
*//***********************************************************************/
template<>
LPSTR CTPath<CHAR>::AddBackslash(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathAddBackslashA(m_Path);
#else
	return FALSE;
#endif
}
template<>
LPWSTR CTPath<WCHAR>::AddBackslash(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathAddBackslashW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * gqǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::AddExtension(_Mylpcstr  pszExt)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathAddExtensionA(m_Path, pszExt);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::AddExtension(_Mylpcstr  pszExt)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathAddExtensionW(m_Path, pszExt);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * t@Cǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
template<typename CHARTYPE>
BOOL CTPath<CHARTYPE>::AddFileName(_Mylpcstr  pszFile)
{
	return CombineFile(pszFile);
}

/**********************************************************************//**
 *
 * pX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	pszMore	= 镶
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::Append(_Mylpcstr  pszMore)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathAppendA(m_Path, pszMore);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::Append(_Mylpcstr  pszMore)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathAppendW(m_Path, pszMore);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * hCu[gpX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	iDrive	= hCuԍ
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::BuildRoot(int iDrive)
{
#if	!defined(IRIS_WIN32_WCE)
	if( PathBuildRootA(m_Path, iDrive) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::BuildRoot(int iDrive)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( PathBuildRootW(m_Path, iDrive) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::Canonicalize(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCanonicalizeA(m_Path, m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::Canonicalize(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCanonicalizeW(m_Path, m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= ̓pX
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::Canonicalize(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCanonicalizeA(m_Path, pszPath);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::Canonicalize(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCanonicalizeW(m_Path, pszPath);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * fBNgpXƃt@Č
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::Combine(_Mylpcstr  pszDir, _Mylpcstr  pszFile)
{
#if	!defined(IRIS_WIN32_WCE)
	if( PathCombineA(m_Path, pszDir, pszFile) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::Combine(_Mylpcstr  pszDir, _Mylpcstr  pszFile)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( PathCombineW(m_Path, pszDir, pszFile) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * fBNgpXƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CombineDirectory(_Mylpcstr  pszDir)
{
#if	!defined(IRIS_WIN32_WCE)
	if( PathCombineA(m_Path, pszDir, m_Path) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CombineDirectory(_Mylpcstr  pszDir)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( PathCombineW(m_Path, pszDir, m_Path) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * t@Cƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CombineFile(_Mylpcstr  pszFile)
{
#if	!defined(IRIS_WIN32_WCE)
	if( PathCombineA(m_Path, m_Path, pszFile) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CombineFile(_Mylpcstr  pszFile)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( PathCombineW(m_Path, m_Path, pszFile) == nullptr ) return FALSE;
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * \̈Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC		= tHgێĂfoCXReLXg
 * @param [in]	dx		= \
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CompactPath(HDC hDC, UINT dx)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCompactPathA(hDC, m_Path, dx);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CompactPath(HDC hDC, UINT dx)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCompactPathW(hDC, m_Path, dx);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CompactPathEx(UINT cchMax, DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCompactPathExA(m_Path, m_Path, cchMax, dwFlags);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CompactPathEx(UINT cchMax, DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCompactPathExW(m_Path, m_Path, cchMax, dwFlags);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDst		= o̓obt@
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CompactPathEx(_Mylpstr  pszDst, UINT cchMax, DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCompactPathExA(pszDst, m_Path, cchMax, dwFlags);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CompactPathEx(_Mylpstr  pszDst, UINT cchMax, DWORD dwFlags)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCompactPathExW(pszDst, m_Path, cchMax, dwFlags);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * Q̃pX狤ʂ̃pXo
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile1	= pXP
 * @param [in]	pszFile2	= pXQ
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::CommonPrefix(_Mylpcstr  pszFile1, _Mylpcstr  pszFile2)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathCommonPrefixA(pszFile1, pszFile2, m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::CommonPrefix(_Mylpcstr  pszFile1, _Mylpcstr  pszFile2)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathCommonPrefixW(pszFile1, pszFile2, m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXWJpXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc	= ϊ
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::ExpandEnvStrings(_Mylpcstr  lpSrc)
{
#if	!defined(IRIS_WIN32_WCE)
	DWORD dwSize = ExpandEnvironmentStringsA(lpSrc, m_Path, MAX_PATH);
	if( dwSize == 0 ) return FALSE;
	return FileExists();
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::ExpandEnvStrings(_Mylpcstr  lpSrc)
{
#if	!defined(IRIS_WIN32_WCE)
	DWORD dwSize = ExpandEnvironmentStringsW(lpSrc, m_Path, MAX_PATH);
	if( dwSize == 0 ) return FALSE;
	return FileExists();
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTPath<CHARTYPE_>::FileExists(void)
{
	return FileExists(m_Path);
}

/**********************************************************************//**
 *
 * gq
 *
 ----------------------------------------------------------------------
 * @return	gqւ̃|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::FindExtension(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathFindExtensionA(m_Path);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::FindExtension(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathFindExtensionW(m_Path);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @return	t@Cւ̃|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::FindFileName(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathFindFileNameA(m_Path);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::FindFileName(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathFindFileNameW(m_Path);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
template<typename CHARTYPE_>
CHARTYPE_*  CTPath<CHARTYPE_>::FindNextComponent(void)
{
	return FindNextComponent(m_Path);
}

/**********************************************************************//**
 *
 * Ō̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::FindLastComponent(void)
{
	_Mylpstr  ret = nullptr;
	_Mylpstr  next = nullptr;
	next = FindNextComponent();
	while(next && *next != '\0' )
	{
		ret = next;
		next = FindNextComponent(next);
	}
	return ret;
}
template<>
LPWSTR  CTPath<WCHAR>::FindLastComponent(void)
{
	_Mylpstr  ret = nullptr;
	_Mylpstr  next = nullptr;
	next = FindNextComponent();
	while(next && *next != L'\0' )
	{
		ret = next;
		next = FindNextComponent(next);
	}
	return ret;
}

/**********************************************************************//**
 *
 * WpXEst@C
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= pXiʂ̊i[obt@j
 * @return	ppszOtherDirs	= ΏۃpXXg
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::FindOnPath(_Mylpstr pszPath, _Mylpcstr * ppszOtherDirs)
{
#if	!defined(IRIS_WIN32_WCE)
	if( !PathFindOnPathA(pszPath, ppszOtherDirs) ) return FALSE;
	strcpy_s(m_Path, MAX_PATH, pszPath);
	return TRUE;
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::FindOnPath(_Mylpstr pszPath, _Mylpcstr * ppszOtherDirs)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	if( !PathFindOnPathW(pszPath, ppszOtherDirs) ) return FALSE;
	wcscpy_s(m_Path, MAX_PATH, pszPath);
	return TRUE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * TtBbNX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	lppSuffix	= TtBbNXXg
 * @return	nArraySize	= lppSuffix̔z
 * @return	v̐擪|C^BsƂnullptr
*//***********************************************************************/
template<>
LPCSTR  CTPath<CHAR>::FindSuffixArray(_Mylpcstr * lppSuffix, int nArraySize)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathFindSuffixArrayA(m_Path, lppSuffix, nArraySize);
#else
	return FALSE;
#endif
}
template<>
LPCWSTR  CTPath<WCHAR>::FindSuffixArray(_Mylpcstr * lppSuffix, int nArraySize)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathFindSuffixArrayW(m_Path, lppSuffix, nArraySize);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
template<typename CHARTYPE_>
CHARTYPE_*  CTPath<CHARTYPE_>::GetArgs(void)
{
	return GetArgs(m_Path);
}

/**********************************************************************//**
 *
 * hCuԍ̎擾
 *
 ----------------------------------------------------------------------
 * @return	hCuԍ
*//***********************************************************************/
template<>
int CTPath<CHAR>::GetDriveNumber(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathGetDriveNumberA(m_Path);
#else
	return FALSE;
#endif
}
template<>
int CTPath<WCHAR>::GetDriveNumber(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathGetDriveNumberW(m_Path);
#else
	return -1;
#endif
}

/**********************************************************************//**
 *
 * ̃Rec^Cvǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszContentType	= Rec^Cv
 * @return	^Ul
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTPath<CHARTYPE_>::IsContentType(_Mylpcstr  pszContentType)
{
	return IsContentType(m_Path, pszContentType);
}

/**********************************************************************//**
 *
 * fBNg݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTPath<CHARTYPE_>::IsDirectory(void)
{
	return IsDirectory(m_Path);
}

/**********************************************************************//**
 *
 * fBNg󂩂ǂ
 *
 ----------------------------------------------------------------------
 * @retval	true	= 
 * @retval	false	= łȂ
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsDirectoryEmpty(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsDirectoryEmptyA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsDirectoryEmpty(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsDirectoryEmptyW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ؂蕶邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	؂蕶܂܂Ă邩ǂ\^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsFileSpecA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsFileSpecW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXtH[}bgǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsLFNFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsLFNFileSpecA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsLFNFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsLFNFileSpecW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * lbg[ÑpXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsNetworkPath(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsNetworkPathA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsNetworkPath(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsNetworkPathW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXvtBbNXn܂Ă邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPrefix	= vtBbNX
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsPrefix(_Mylpcstr  pszPrefix)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsPrefixA(pszPrefix, m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsPrefix(_Mylpcstr  pszPrefix)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsPrefixW(pszPrefix, m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX΃pXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsRelative(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsRelativeA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsRelative(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsRelativeW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX[gpXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsRoot(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsRootA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsRoot(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsRootW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX̃[gpXǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= r
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsSameRoot(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsSameRootA(m_Path, pszPath);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsSameRoot(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsSameRootW(m_Path, pszPath);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsSystemFolderA(m_Path, 0);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsSystemFolderW(m_Path, 0);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXUNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsUNC(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsUNCA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsUNC(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsUNCW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXT[o[\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsUNCServer(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsUNCServerA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsUNCServer(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsUNCServerW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXL\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsUNCServerShare(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsUNCServerShareA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsUNCServerShare(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsUNCServerShareW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXURL\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsURL(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsURLA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsURL(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsURLW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * 啶̃pXɕϊ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::MakePretty(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathMakePrettyA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::MakePretty(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathMakePrettyW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * t@CVXet@Cɂ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::MakeSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathMakeSystemFolderA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::MakeSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathMakeSystemFolderW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXɈv邩iChJ[hgp\j
 *
 ----------------------------------------------------------------------
 * @param [in]	pszSpec	= r
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::MatchSpec(_Mylpcstr  pszSpec)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathMatchSpecA(m_Path, pszSpec);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::MatchSpec(_Mylpcstr  pszSpec)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathMatchSpecW(m_Path, pszSpec);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * 󔒂pX '"' 
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::QuoteSpaces(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathQuoteSpacesA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::QuoteSpaces(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathQuoteSpacesW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * ̃pXԂ̑΃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFrom		= Qƌ̃pX
 * @param [in]	dwAttrFrom	= Qƌ̃t@C
 * @param [in]	pszTo		= QƐ̃pX
 * @param [in]	dwAttrTo	= QƐ̃t@C
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::RelativePathTo(_Mylpcstr  pszFrom, DWORD dwAttrFrom, _Mylpcstr  pszTo, DWORD dwAttrTo)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathRelativePathToA(m_Path, pszFrom, dwAttrFrom, pszTo, dwAttrTo);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::RelativePathTo(_Mylpcstr  pszFrom, DWORD dwAttrFrom, _Mylpcstr  pszTo, DWORD dwAttrTo)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathRelativePathToW(m_Path, pszFrom, dwAttrFrom, pszTo, dwAttrTo);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * obNXbV폜
 *
 ----------------------------------------------------------------------
 * @return	폜 \ ̈ʒu
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::RemoveBackslash(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathRemoveBackslashA(m_Path);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::RemoveBackslash(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathRemoveBackslashW(m_Path);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * pX̑Ő󔒂폜
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::RemoveBlanks(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathRemoveBlanksA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::RemoveBlanks(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathRemoveBlanksW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * pXgq폜
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::RemoveExtension(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathRemoveExtensionA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::RemoveExtension(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathRemoveExtensionW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::RemoveFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathRemoveFileSpecA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::RemoveFileSpec(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathRemoveFileSpecW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX̊gqύX
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::RenameExtension(_Mylpcstr  pszExt)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathRenameExtensionA(m_Path, pszExt);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::RenameExtension(_Mylpcstr  pszExt)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathRenameExtensionW(m_Path, pszExt);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszBuf	= ߂tpX
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::SearchAndQualify(_Mylpstr  pszBuf, UINT cchBuf)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathSearchAndQualifyA(m_Path, pszBuf, cchBuf);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::SearchAndQualify(_Mylpstr  pszBuf, UINT cchBuf)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathSearchAndQualifyW(m_Path, pszBuf, cchBuf);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= tpX߂pX
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::SearchAndQualify(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathSearchAndQualifyA(pszPath, m_Path, MAX_PATH);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::SearchAndQualify(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathSearchAndQualifyW(pszPath, m_Path, MAX_PATH);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * k߂`̃pXRg[ɕ\
 *
 ----------------------------------------------------------------------
 * @param [in]	hDlg	= _CAOnh
 * @param [in]	id		= _CAOACeID
*//***********************************************************************/
template<>
void CTPath<CHAR>::SetDlgItemPath(HWND hDlg, int id)
{
#if	!defined(IRIS_WIN32_WCE)
	PathSetDlgItemPathA(hDlg, id, m_Path);
#endif
}
template<>
void CTPath<WCHAR>::SetDlgItemPath(HWND hDlg, int id)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathSetDlgItemPathW(hDlg, id, m_Path);
#endif
}

/**********************************************************************//**
 *
 * pX狤L폜
 *
 ----------------------------------------------------------------------
 * @return	LȊO̐擪|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::SkipRoot(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathSkipRootA(m_Path);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::SkipRoot(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathSkipRootW(m_Path);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * pXt@Co
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::StripPath(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathStripPathA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::StripPath(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathStripPathW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * pX烋[gpXo
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::StripToRoot(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathStripToRootA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::StripToRoot(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathStripToRootW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXϐgppXɕύX
 *
 ----------------------------------------------------------------------
 * @param [out]	pszBuf	= o̓obt@
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::UnExpandEnvStrings(_Mylpstr  pszBuf, UINT cchBuf)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathUnExpandEnvStringsA(m_Path, pszBuf, cchBuf);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::UnExpandEnvStrings(_Mylpstr  pszBuf, UINT cchBuf)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathUnExpandEnvStringsW(m_Path, pszBuf, cchBuf);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pXC폜
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::Undecorate(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathUndecorateA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::Undecorate(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathUndecorateW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * t@CVXet@CłȂ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::UnmakeSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathUnmakeSystemFolderA(m_Path);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::UnmakeSystemFolder(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathUnmakeSystemFolderW(m_Path);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * pX̑Õ_uNH[e[V폜
 *
*//***********************************************************************/
template<>
void CTPath<CHAR>::UnquoteSpaces(void)
{
#if	!defined(IRIS_WIN32_WCE)
	PathUnquoteSpacesA(m_Path);
#endif
}
template<>
void CTPath<WCHAR>::UnquoteSpaces(void)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathUnquoteSpacesW(m_Path);
#endif
}

/**********************************************************************//**
 *
 * t@CɎgȂ폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= ͕
 * @param [in]	max_len	= t@CƂĎgpő啶
 * @return	
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::FormatFileName(_Mylpcstr  pszFile, s32 max_len)
{
	if( pszFile == nullptr ) return FALSE;
	_Mylpcstr  p = pszFile;
	// 擪̃Xy[X͍폜
	while( *p == ' ' || *p == '.' )	{ ++p; }
	if( *p == '\0' ) return FALSE;
	// gpłȂ폜
	s32 len = 0;
	s32 max = max_len <= 0 ? MAX_PATH : max_len;
	do
	{
		static const CHAR	code[] = "\\/:*?\"<>|\r\n";
		static const int	num = sizeof(code)/sizeof(code[0]);
		for( int i=0; i < num; ++i )
		{
			if( *p == code[i] ) goto block_end;	// gpsƈv
		}
		if( len >= max )
		{
			m_Path[len-1] = '~';
			break;
		}
		m_Path[len] = *p;
		++len;
block_end:
		;
	} while( *(++p) != '\0' );
	m_Path[len] = '\0';

	return TRUE;
}
template<>
BOOL CTPath<WCHAR>::FormatFileName(_Mylpcstr  pszFile, s32 max_len)
{
	if( pszFile == nullptr ) return FALSE;
	_Mylpcstr  p = pszFile;
	// 擪̃Xy[X͍폜
	while( *p == L' ' || *p == L'.' )	{ ++p; }
	if( *p == L'\0' ) return FALSE;
	// gpłȂ폜
	s32 len = 0;
	s32 max = max_len <= 0 ? MAX_PATH : max_len;
	do
	{
		static const WCHAR	code[] = L"\\/:*?\"<>|\r\n";
		static const int	num = sizeof(code)/sizeof(code[0]);
		for( int i=0; i < num; ++i )
		{
			if( *p == code[i] ) goto block_end;	// gpsƈv
		}
		if( len >= max )
		{
			m_Path[len-1] = L'~';
			break;
		}
		m_Path[len] = *p;
		++len;
block_end:
		;
	} while( *(++p) != L'\0' );
	m_Path[len] = L'\0';

	return TRUE;
}


/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::FileExists(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathFileExistsA(pszPath);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::FileExists(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathFileExistsW(pszPath);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * fBNg݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsDirectory(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsDirectoryA(pszPath);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsDirectory(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsDirectoryW(pszPath);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::FindNextComponent(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathFindNextComponentA(pszPath);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::FindNextComponent(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathFindNextComponentW(pszPath);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
template<>
LPSTR  CTPath<CHAR>::GetArgs(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathGetArgsA(pszPath);
#else
	return nullptr;
#endif
}
template<>
LPWSTR  CTPath<WCHAR>::GetArgs(_Mylpcstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathGetArgsW(pszPath);
#else
	return nullptr;
#endif
}

/**********************************************************************//**
 *
 * pX\镶̎ʂ𔻒
 *
 ----------------------------------------------------------------------
 * @param [in]	ch	= ͕
 * @return	̎(GCT_***)
*//***********************************************************************/
template<>
UINT CTPath<CHAR>::GetCharType(_Mychar ch)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathGetCharTypeA(ch);
#else
	return GCT_INVALID;
#endif
}
template<>
UINT CTPath<WCHAR>::GetCharType(_Mychar ch)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathGetCharTypeW(ch);
#else
	return GCT_INVALID;
#endif
}

/**********************************************************************//**
 *
 * ̃Rec^Cvǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszContentType	= Rec^Cv
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsContentType(_Mylpcstr pszPath, _Mylpcstr  pszContentType)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsContentTypeA(pszPath, pszContentType);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsContentType(_Mylpcstr pszPath, _Mylpcstr  pszContentType)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsContentTypeW(pszPath, pszContentType);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ̃t@CVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwAttrb	= t@C
 * @return	^Ul
*//***********************************************************************/
template<>
BOOL CTPath<CHAR>::IsSystemFolder(DWORD dwAttrb)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathIsSystemFolderA(nullptr, dwAttrb);
#else
	return FALSE;
#endif
}
template<>
BOOL CTPath<WCHAR>::IsSystemFolder(DWORD dwAttrb)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathIsSystemFolderW(nullptr, dwAttrb);
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * ACRpXt@CpXƃCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
template<>
int CTPath<CHAR>::ParseIconLocation(_Mylpstr  pszIconFile)
{
#if	!defined(IRIS_WIN32_WCE)
	return PathParseIconLocationA(pszIconFile);
#else
	return -1;
#endif
}
template<>
int CTPath<WCHAR>::ParseIconLocation(_Mylpstr  pszIconFile)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	return PathParseIconLocationW(pszIconFile);
#else
	return -1;
#endif
}

/**********************************************************************//**
 *
 * R}hC폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= o̓obt@
*//***********************************************************************/
template<>
void CTPath<CHAR>::RemoveArgs(_Mylpstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE)
	PathRemoveArgsA(pszPath);
#endif
}
template<>
void CTPath<WCHAR>::RemoveArgs(_Mylpstr  pszPath)
{
#if	!defined(IRIS_WIN32_WCE) || defined(UNDER_NT)
	PathRemoveArgsW(pszPath);
#endif
}

template class CTPath<CHAR>;
template class CTPath<WCHAR>;


}	// end of namespace wx
}	// end of namespace iris
