//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		wx_support.h
 * @brief		irisT|[g}Nwb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_wx_support_H_
#define INCG_IRIS_wx_support_H_

//======================================================================
// include

//======================================================================
// define
// Visual Studio Version
#define _MSC_VER_CC6		 600	//!< C Compiler 6.0
#define _MSC_VER_CC7		 700	//!< C/C++ Compiler 7.0
#define _MSC_VER_VC1		 800	//!< VC++  1.0
#define _MSC_VER_VC2		 900	//!< VC++  2.0
#define _MSC_VER_VC4		1000	//!< VC++  4.0
#define _MSC_VER_VC4_1		1010	//!< VC++  4.1
#define _MSC_VER_VC4_2		1020	//!< VC++  4.2
#define _MSC_VER_VC5		1100	//!< VC++  5.0 (Visual Studio 97)
#define _MSC_VER_VC6		1200	//!< VC++  6.0 (Visual Studio 6.0)
#define _MSC_VER_VC7		1300	//!< VC++  7.0 (Visual Studio .NET 2002)
#define _MSC_VER_VC7_1		1310	//!< VC++  7.1 (Visual Studio .NET 2003)
#define _MSC_VER_VC8		1400	//!< VC++  8.0 (Visual Studio 2005)
#define _MSC_VER_VC9		1500	//!< VC++  9.0 (Visual Studio 2008)
#define _MSC_VER_VC10		1600	//!< VC++ 10.0 (Visual Studio 2010)

#define _MSC_FULL_VER_VC9_SP1	150030729	//!< VC++  9.0 SP1 (Visual Studio 2008 SP1)
#define _MSC_FULL_VER_VC10_SP1	160040219	//!< VC++ 10.0 SP1 (Visual Studio 2010 SP1)


// `ĂȂꍇ̂ŁA`̒ǉ
#if _MSC_VER < _MSC_VER_VC8
#  define VER_SUITE_STORAGE_SERVER				0x00002000
#  define VER_SUITE_COMPUTE_SERVER				0x00004000
#endif

#if	_MSC_VER < _MSC_VER_VC9
#  define PRODUCT_UNDEFINED						0x00000000

#  define PRODUCT_ULTIMATE						0x00000001
#  define PRODUCT_HOME_BASIC					0x00000002
#  define PRODUCT_HOME_PREMIUM					0x00000003
#  define PRODUCT_ENTERPRISE					0x00000004
#  define PRODUCT_HOME_BASIC_N					0x00000005
#  define PRODUCT_BUSINESS						0x00000006
#  define PRODUCT_STANDARD_SERVER				0x00000007
#  define PRODUCT_DATACENTER_SERVER				0x00000008
#  define PRODUCT_SMALLBUSINESS_SERVER			0x00000009
#  define PRODUCT_ENTERPRISE_SERVER				0x0000000A
#  define PRODUCT_STARTER						0x0000000B
#  define PRODUCT_DATACENTER_SERVER_CORE		0x0000000C
#  define PRODUCT_STANDARD_SERVER_CORE  		0x0000000D
#  define PRODUCT_ENTERPRISE_SERVER_CORE		0x0000000E
#  define PRODUCT_ENTERPRISE_SERVER_IA64		0x0000000F
#  define PRODUCT_BUSINESS_N					0x00000010
#  define PRODUCT_WEB_SERVER					0x00000011
#  define PRODUCT_CLUSTER_SERVER				0x00000012
#  define PRODUCT_HOME_SERVER					0x00000013
#  define PRODUCT_STORAGE_EXPRESS_SERVER		0x00000014
#  define PRODUCT_STORAGE_STANDARD_SERVER		0x00000015
#  define PRODUCT_STORAGE_WORKGROUP_SERVER		0x00000016
#  define PRODUCT_STORAGE_ENTERPRISE_SERVER		0x00000017
#  define PRODUCT_SERVER_FOR_SMALLBUSINESS		0x00000018
#  define PRODUCT_SMALLBUSINESS_SERVER_PREMIUM	0x00000019

#  define SM_TABLETPC				86
#  define SM_MEDIACENTER			87
#  define SM_STARTER				88
#  define SM_SERVERR2				89
#endif

#if	_MSC_VER < _MSC_VER_VC10
#  define PRODUCT_HOME_PREMIUM_N					0x0000001A
#  define PRODUCT_ENTERPRISE_N						0x0000001B
#  define PRODUCT_ULTIMATE_N						0x0000001C
#  define PRODUCT_WEB_SERVER_CORE					0x0000001D
#  define PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT	0x0000001E
#  define PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY	0x0000001F
#  define PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING	0x00000020
#  define PRODUCT_SERVER_FOUNDATION					0x00000021
#  define PRODUCT_HOME_SERVER_PREMIUM				0x00000022	// ?
#  define PRODUCT_SERVER_FOR_SMALLBUSINESS_V		0x00000023
#  define PRODUCT_STANDARD_SERVER_V					0x00000024
#  define PRODUCT_DATACENTER_SERVER_V				0x00000025
#  define PRODUCT_ENTERPRISE_SERVER_V				0x00000026
#  define PRODUCT_DATACENTER_SERVER_CORE_V			0x00000027
#  define PRODUCT_STANDARD_SERVER_CORE_V			0x00000028
#  define PRODUCT_ENTERPRISE_SERVER_CORE_V			0x00000029
#  define PRODUCT_HYPERV							0x0000002A
#  define PRODUCT_STORAGE_EXPRESS_SERVER_CORE		0x0000002B	// ?
#  define PRODUCT_STORAGE_STANDARD_SERVER_CORE		0x0000002C	// ?
#  define PRODUCT_STORAGE_WORKGROUP_SERVER_CORE		0x0000002D	// ?
#  define PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE	0x0000002E	// ?
#  define PRODUCT_STARTER_N							0x0000002F
#  define	PRODUCT_PROFESSIONAL					0x00000030
#  define	PRODUCT_PROFESSIONAL_N					0x00000031
#  define PRODUCT_STARTER_E							0x00000042
#  define PRODUCT_HOME_BASIC_E						0x00000043
#  define PRODUCT_HOME_PREMIUM_E					0x00000044
#  define PRODUCT_PROFESSIONAL_E					0x00000045
#  define PRODUCT_ENTERPRISE_E						0x00000046
#  define PRODUCT_ULTIMATE_E						0x00000047
#endif

#if	_MSC_VER <= _MSC_VER_VC10
#  define PRODUCT_HOME_SERVER_PREMIUM				0x00000022	// ?
#endif

#ifndef PROCESSOR_ARCHITECTURE_AMD64
#  define PROCESSOR_ARCHITECTURE_AMD64				9
#endif
#define PROCESSOR_ARCHITECTURE_X64					PROCESSOR_ARCHITECTURE_AMD64
#define PROCESSOR_ARCHITECTURE_EM64T				PROCESSOR_ARCHITECTURE_AMD64

#ifndef VER_SUITE_WH_SERVER
#  define VER_SUITE_WH_SERVER						0x00008000
#endif

#if _MSC_VER <= _MSC_VER_VC6
#  define _vcprintf(fmt, va)			vprintf(fmt, va)
#  define _vcwprintf(fmt, va)			vwprintf(fmt, va)
#endif

#if _MSC_VER <= _MSC_VER_VC7_1
#  ifdef  _UNICODE
#    define _tcscpy_s	wcscpy_s
#    define _tcscat_s	wcscat_s
#    define _tcsncpy_s	wcsncpy_s
#  else
#    define _tcscpy_s	strcpy_s
#    define _tcscat_s	strcat_s
#    define _tcsncpy_s	strncpy_s
#  endif
#endif

#if	_MSC_VER <= _MSC_VER_VC8
typedef LONG	LSTATUS;
#if !defined(_WIN32_WCE)
typedef DWORD	NTSTATUS;
#endif
#endif

#if		defined(_WIN64)
#  define	GWL_WNDPROC		GWLP_WNDPROC
#  define	GWL_HINSTANCE	GWLP_HINSTANCE
#  define	GWL_HWNDPARENT	GWLP_HWNDPARENT
#  define	GWL_USERDATA	GWLP_USERDATA
#endif

#if !defined(_TRUNCATE)
#  define _TRUNCATE ((size_t)-1)
#endif

#if		defined(_WIN64)
typedef DWORD64		XDWORD;
typedef PDWORD64	PXDWORD;
typedef ULONG64		XULONG;
#else
typedef DWORD		XDWORD;
typedef PDWORD		PXDWORD;
typedef ULONG		XULONG;
#endif

#if		!defined(MAKEDWORD)
#  define MAKEDWORD(a, b)		(DWORD)(MAKELONG(a, b))
#endif

//======================================================================
// include
#include "support/wx_api_support.h"
#include "support/wx_posix_support.h"
#include "support/wx_sdk_support.h"
#include "support/wx_vc8_support.h"

#ifndef GetProcAddressRaw
#if	!defined(IRIS_WIN32_WCE)
#  define GetProcAddressRaw(hModule, lpProcName)	GetProcAddress(hModule, lpProcName)
#else
#  define GetProcAddressRaw(hModule, lpProcName)	GetProcAddressW(hModule, L##lpProcName)
#endif
#endif

#endif
